/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.util;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.MarkdownParser;
import com.tom.cpl.util.MarkdownRenderer;
import com.tom.cpm.externals.com.google.common.cache.CacheBuilder;
import com.tom.cpm.externals.com.google.common.cache.CacheLoader;
import com.tom.cpm.externals.com.google.common.cache.LoadingCache;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.MdResourceIO;
import com.tom.cpm.shared.util.MdResourceLoader$$Lambda$1;
import com.tom.cpm.shared.util.MdResourceLoader$$Lambda$10;
import com.tom.cpm.shared.util.MdResourceLoader$$Lambda$11;
import com.tom.cpm.shared.util.MdResourceLoader$$Lambda$12;
import com.tom.cpm.shared.util.MdResourceLoader$$Lambda$2;
import com.tom.cpm.shared.util.MdResourceLoader$$Lambda$3;
import com.tom.cpm.shared.util.MdResourceLoader$$Lambda$4;
import com.tom.cpm.shared.util.MdResourceLoader$$Lambda$5;
import com.tom.cpm.shared.util.MdResourceLoader$$Lambda$6;
import com.tom.cpm.shared.util.MdResourceLoader$$Lambda$7;
import com.tom.cpm.shared.util.MdResourceLoader$$Lambda$8;
import com.tom.cpm.shared.util.MdResourceLoader$$Lambda$9;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MdResourceLoader
implements MarkdownRenderer.MarkdownResourceLoader {
    public static final String RAW_WIKI_ROOT = "https://raw.githubusercontent.com/wiki/tom5454/CustomPlayerModels/";
    public static final String RAW_IMG_ROOT = "https://raw.githubusercontent.com/wiki/tom5454/CustomPlayerModels/images/";
    private static final String WIKI_ROOT = "https://github.com/tom5454/CustomPlayerModels/wiki";
    private static final String IMAGES_ROOT = "https://github.com/tom5454/CustomPlayerModels/wiki/images/";
    private static final String LOCALE_ROOT = "https://github.com/tom5454/CustomPlayerModels/wiki/locale/";
    public static final Pattern LOCALE_EXT = Pattern.compile("[\\w-/.:]+\\/([\\w-]+)-([a-z]{2,3}-[A-Z]{2,3})");
    private static final LoadingCache<String, CompletableFuture<Image>> imageCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(CacheLoader.from(MdResourceLoader$$Lambda$11.lambdaFactory$()));
    private static final LoadingCache<String, CompletableFuture<String>> pageCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build(CacheLoader.from(MdResourceLoader$$Lambda$12.lambdaFactory$()));
    private boolean offline;
    private Consumer<String> openURL;
    private Consumer<String> nextPage;

    public MdResourceLoader(Consumer<String> openURL, Consumer<String> nextPage, boolean offline) {
        this.offline = offline;
        this.openURL = openURL;
        this.nextPage = nextPage;
    }

    private static CompletableFuture<Image> loadImage0(String url) {
        return MdResourceIO.loadImage0(url, false);
    }

    private static CompletableFuture<String> loadPage0(String url) {
        return MdResourceLoader.fetch(url, false, true).thenApply(MdResourceLoader$$Lambda$1.lambdaFactory$());
    }

    @Override
    public CompletableFuture<Image> loadImage(String url) {
        if (this.offline) {
            return MdResourceIO.loadImage0(url, true);
        }
        try {
            return imageCache.get(url);
        }
        catch (ExecutionException e) {
            CompletableFuture<Image> f = new CompletableFuture<Image>();
            f.completeExceptionally(e.getCause());
            return f;
        }
    }

    private CompletableFuture<String> loadPage(String url) {
        if (this.offline) {
            return MdResourceLoader.fetch(url, true, true).thenApply(MdResourceLoader$$Lambda$2.lambdaFactory$());
        }
        try {
            return pageCache.get(url);
        }
        catch (ExecutionException e) {
            CompletableFuture<String> f = new CompletableFuture<String>();
            f.completeExceptionally(e.getCause());
            return f;
        }
    }

    @Override
    public void browse(MarkdownRenderer rd, String url) {
        if (url.equals(WIKI_ROOT)) {
            this.browse(rd, "https://github.com/tom5454/CustomPlayerModels/wiki/Home.md");
        } else if (url.startsWith(WIKI_ROOT)) {
            String nm;
            if (this.nextPage != null) {
                this.nextPage.accept(url);
            }
            CompletableFuture<String> completableFuture = this.loadPage((nm = url.substring(url.lastIndexOf(47) + 1)).contains("#") ? url.substring(0, url.lastIndexOf(35)) : url);
            Consumer consumer = MdResourceLoader$$Lambda$3.lambdaFactory$(rd, nm);
            IGui iGui = rd.getGui();
            iGui.getClass();
            ((CompletableFuture)completableFuture.thenAcceptAsync(consumer, MdResourceLoader$$Lambda$4.lambdaFactory$(iGui))).exceptionally(MdResourceLoader$$Lambda$5.lambdaFactory$(rd));
        } else if (this.openURL != null) {
            this.openURL.accept(url);
        }
    }

    public static CompletableFuture<byte[]> fetch(String url, boolean offline, boolean logWarn) {
        Log.debug("Wiki fetching: " + url);
        if (url.equals(WIKI_ROOT)) {
            return MdResourceLoader.fetch("https://github.com/tom5454/CustomPlayerModels/wiki/Home.md", offline, logWarn);
        }
        if (url.startsWith(WIKI_ROOT) && url.endsWith(".md")) {
            String p = url.substring(WIKI_ROOT.length() + 1);
            if (offline) {
                return MdResourceLoader.asset0("/assets/cpm/wiki/pages/" + p);
            }
            return MdResourceLoader.fetchOnline(RAW_WIKI_ROOT + p, "/assets/cpm/wiki/pages/" + p, logWarn);
        }
        if (url.startsWith(IMAGES_ROOT)) {
            String p = url.substring(IMAGES_ROOT.length());
            if (offline) {
                return MdResourceLoader.asset0("/assets/cpm/wiki/images/" + p);
            }
            return MdResourceLoader.fetchOnline(RAW_IMG_ROOT + p, "/assets/cpm/wiki/images/" + p, logWarn);
        }
        if (url.startsWith(WIKI_ROOT)) {
            Matcher m = LOCALE_EXT.matcher(url);
            if (m.matches()) {
                String b = m.group(1);
                String lang = m.group(2);
                CompletableFuture<byte[]> cf = MdResourceLoader.fetch(LOCALE_ROOT + lang + "/" + b + "-" + lang + ".md", offline, false);
                return ((CompletableFuture)cf.exceptionally(MdResourceLoader$$Lambda$6.lambdaFactory$())).thenCompose(MdResourceLoader$$Lambda$7.lambdaFactory$(b, offline, logWarn));
            }
            return MdResourceLoader.fetch(url + ".md", offline, logWarn);
        }
        CompletableFuture<byte[]> f = new CompletableFuture<byte[]>();
        f.completeExceptionally(new IOException("Unknown url: " + url));
        return f;
    }

    private static CompletableFuture<byte[]> fetchOnline(String url, String asset, boolean logWarn) {
        return ((CompletableFuture)MdResourceIO.fetch0(url).handle(MdResourceLoader$$Lambda$8.lambdaFactory$(logWarn, asset))).thenCompose(Function.identity());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CompletableFuture<byte[]> asset0(String path) {
        try {
            InputStream is = MdResourceLoader.class.getResourceAsStream(path);
            Throwable throwable = null;
            try {
                if (is == null) {
                    throw new FileNotFoundException(path);
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOHelper.copy(is, baos);
                CompletableFuture<byte[]> completableFuture = CompletableFuture.completedFuture(baos.toByteArray());
                return completableFuture;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            CompletableFuture<byte[]> f = new CompletableFuture<byte[]>();
            f.completeExceptionally(e);
            return f;
        }
    }

    static /* synthetic */ CompletableFuture lambda$fetchOnline$8(boolean logWarn, String asset, byte[] d, Throwable e) {
        if (d != null && e == null) {
            return CompletableFuture.completedFuture(d);
        }
        if (logWarn) {
            Log.warn("Failed to load page, loading local backup", e);
        }
        return ((CompletableFuture)MdResourceLoader.asset0(asset).handle(MdResourceLoader$$Lambda$9.lambdaFactory$(e))).thenCompose(Function.identity());
    }

    static /* synthetic */ CompletableFuture lambda$null$7(Throwable e, byte[] a, Throwable e2) {
        if (a != null && e2 == null) {
            return CompletableFuture.completedFuture(a);
        }
        CompletableFuture cf = new CompletableFuture();
        cf.completeExceptionally(e2);
        return cf;
    }

    static /* synthetic */ CompletionStage lambda$fetch$6(String b, boolean offline, boolean logWarn, byte[] d) {
        if (d == null) {
            return MdResourceLoader.fetch("https://github.com/tom5454/CustomPlayerModels/wiki/" + b + ".md", offline, logWarn);
        }
        return CompletableFuture.completedFuture(d);
    }

    static /* synthetic */ byte[] lambda$fetch$5(Throwable ex) {
        return null;
    }

    static /* synthetic */ Void lambda$browse$4(MarkdownRenderer rd, Throwable e) {
        rd.getGui().executeLater(MdResourceLoader$$Lambda$10.lambdaFactory$(rd, e));
        return null;
    }

    static /* synthetic */ void lambda$null$3(MarkdownRenderer rd, Throwable e) {
        rd.setContent(MarkdownParser.makeErrorPage(rd.getGui(), e));
    }

    static /* synthetic */ void lambda$browse$2(MarkdownRenderer rd, String nm, String pg) {
        rd.setContent(new MarkdownParser(pg));
        if (nm.contains("#")) {
            rd.browse(nm.substring(nm.indexOf(35)));
        }
    }

    static /* synthetic */ String lambda$loadPage$1(byte[] pg) {
        return new String(pg, StandardCharsets.UTF_8);
    }

    static /* synthetic */ String lambda$loadPage0$0(byte[] pg) {
        return new String(pg, StandardCharsets.UTF_8);
    }

    static /* synthetic */ CompletableFuture access$lambda$0(String string) {
        return MdResourceLoader.loadImage0(string);
    }

    static /* synthetic */ CompletableFuture access$lambda$1(String string) {
        return MdResourceLoader.loadPage0(string);
    }
}

