/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.util;

import com.tom.cpl.math.MathHelper;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.ModelLoadingPool$$Lambda$1;
import com.tom.cpm.shared.util.ModelLoadingPool$$Lambda$2;
import com.tom.cpm.shared.util.ModelLoadingPool$$Lambda$3;
import com.tom.cpm.shared.util.ModelLoadingPool$$Lambda$4;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;

public class ModelLoadingPool {
    private static final Executor THREAD_POOL;

    public static Executor workerPool() {
        return THREAD_POOL;
    }

    private static void onThreadException(Thread thr, Throwable ex) {
        Log.error("Exception in background loading thread: " + thr.getName(), ex);
    }

    private static int getMaxThreads() {
        String s = System.getProperty("max.bg.threads");
        if (s != null) {
            try {
                int i = Integer.parseInt(s);
                if (i >= 1 && i <= 255) {
                    return i;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 255;
    }

    static /* synthetic */ ForkJoinWorkerThread lambda$static$1(AtomicInteger atomicinteger, ForkJoinPool p_314383_) {
        ForkJoinWorkerThread forkjoinworkerthread = new ForkJoinWorkerThread(p_314383_){

            @Override
            protected void onTermination(Throwable p_211561_) {
                if (p_211561_ != null) {
                    Log.warn(this.getName() + " died", p_211561_);
                } else {
                    Log.debug(this.getName() + " shutdown");
                }
                super.onTermination(p_211561_);
            }
        };
        forkjoinworkerthread.setName("CPM Background Loading Pool-" + atomicinteger.getAndIncrement());
        return forkjoinworkerthread;
    }

    static /* synthetic */ Thread lambda$static$0(Runnable task) {
        Thread thread = new Thread(task);
        thread.setName("CPM Background Loading Thread");
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(ModelLoadingPool$$Lambda$1.lambdaFactory$());
        return thread;
    }

    static {
        int i = MathHelper.clamp(Runtime.getRuntime().availableProcessors() - 2, 1, ModelLoadingPool.getMaxThreads());
        if (i <= 1) {
            THREAD_POOL = Executors.newSingleThreadExecutor(ModelLoadingPool$$Lambda$2.lambdaFactory$());
        } else {
            AtomicInteger atomicinteger = new AtomicInteger(1);
            THREAD_POOL = new ForkJoinPool(i, ModelLoadingPool$$Lambda$3.lambdaFactory$(atomicinteger), ModelLoadingPool$$Lambda$4.lambdaFactory$(), true);
        }
    }

    static /* synthetic */ void access$lambda$0(Thread thread, Throwable throwable) {
        ModelLoadingPool.onThreadException(thread, throwable);
    }

    static /* synthetic */ void access$lambda$1(Thread thread, Throwable throwable) {
        ModelLoadingPool.onThreadException(thread, throwable);
    }
}

