/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmcore;

import com.tom.cpl.util.ILogger;
import com.tom.cpl.util.Pair;
import com.tom.cpm.externals.org.objectweb.asm.ClassReader;
import com.tom.cpm.externals.org.objectweb.asm.ClassWriter;
import com.tom.cpm.externals.org.objectweb.asm.Type;
import com.tom.cpm.externals.org.objectweb.asm.commons.Remapper;
import com.tom.cpm.externals.org.objectweb.asm.commons.RemappingClassAdapter;
import com.tom.cpm.externals.org.objectweb.asm.tree.AbstractInsnNode;
import com.tom.cpm.externals.org.objectweb.asm.tree.ClassNode;
import com.tom.cpm.externals.org.objectweb.asm.tree.FieldInsnNode;
import com.tom.cpm.externals.org.objectweb.asm.tree.FieldNode;
import com.tom.cpm.externals.org.objectweb.asm.tree.InsnList;
import com.tom.cpm.externals.org.objectweb.asm.tree.InsnNode;
import com.tom.cpm.externals.org.objectweb.asm.tree.JumpInsnNode;
import com.tom.cpm.externals.org.objectweb.asm.tree.LabelNode;
import com.tom.cpm.externals.org.objectweb.asm.tree.LdcInsnNode;
import com.tom.cpm.externals.org.objectweb.asm.tree.MethodInsnNode;
import com.tom.cpm.externals.org.objectweb.asm.tree.MethodNode;
import com.tom.cpm.externals.org.objectweb.asm.tree.VarInsnNode;
import com.tom.cpm.retro.FileLogger;
import com.tom.cpmcore.CPMLoadingPlugin;
import com.tom.cpmcore.CPMTransformerService$$Lambda$1;
import com.tom.cpmcore.CPMTransformerService$$Lambda$2;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;

public class CPMTransformerService {
    public static final ILogger LOG = new FileLogger("CPM Core");
    private static final String HOOKS_CLASS = "com/tom/cpmcore/CPMASMClientHooks";
    private static final String HOOKS_CLASS_SERVER = "com/tom/cpmcore/CPMASMServerHooks";
    private static final String NO_MODEL_SETUP_FIELD = "cpm$noModelSetup";
    private static final String HAS_MOD_FIELD = "cpm$hasMod";
    private static final String DATA_FIELD = "cpm$data";
    private static Map<String, Pair<String, String>> methodObfs = new HashMap<String, Pair<String, String>>();
    private static Map<String, String> fieldObfs = new HashMap<String, String>();
    private static Map<String, List<String>> fieldATs = new HashMap<String, List<String>>();
    private static Map<String, UnaryOperator<ClassNode>> transformers;
    private static Map<String, String> classObfs;
    private static Map<String, String> classObfsR;
    private static Map<String, Set<String>> overrides;
    private static boolean isDedicatedServer;
    private static boolean spc;
    private static boolean dump;
    private static boolean isClient;
    private static boolean bukkit;
    private static Map<String, String> classObfsBukkit;

    private static boolean checkMethod(MethodNode mn, Pair<String, String> mth) {
        return mn.name.equals(mth.getKey()) && mn.desc.equals(mth.getValue());
    }

    private static boolean checkMethod(MethodInsnNode mn, Pair<String, String> mth) {
        return mn.name.equals(mth.getKey()) && mn.desc.equals(mth.getValue());
    }

    public static void init() {
        String ln2;
        Throwable throwable;
        BufferedReader rd;
        transformers = new HashMap<String, UnaryOperator<ClassNode>>();
        boolean bl = isDedicatedServer = !isClient && CPMTransformerService.class.getResource("/net/minecraft/server/MinecraftServer.class") != null;
        if (isDedicatedServer) {
            LOG.info("Detected Dedicated Server Installation");
        } else {
            LOG.info("Detected Client Installation");
        }
        if (isDedicatedServer) {
            boolean bl2 = bukkit = System.getProperty("cpmcore.bukkit", "false").equalsIgnoreCase("true") || CPMTransformerService.class.getResource("/org/bukkit/util/FileUtil.class") != null;
            if (bukkit) {
                LOG.info("Detected Bukkit Server Installation");
            }
        }
        try {
            rd = new BufferedReader(new InputStreamReader(CPMTransformerService.class.getResourceAsStream("/META-INF/cpm_core.cfg")));
            throwable = null;
            try {
                int map;
                int n = map = isDedicatedServer ? 3 : 2;
                while ((ln2 = rd.readLine()) != null) {
                    if ((ln2 = ln2.trim()).isEmpty() || ln2.startsWith("#")) continue;
                    String[] sp = ln2.split(" ");
                    if (sp[0].equals("method")) {
                        if (sp[map].equals("?")) continue;
                        int i = sp[map].indexOf(40);
                        i = sp[map].lastIndexOf(47, i);
                        String nameDesc = sp[map].substring(i + 1);
                        int ind = nameDesc.indexOf(40);
                        String mth = nameDesc.substring(0, ind);
                        String par = nameDesc.substring(ind).replace('.', '/');
                        methodObfs.put(sp[1], Pair.of(mth, par));
                        continue;
                    }
                    if (sp[0].equals("class")) {
                        if (sp[map].equals("?")) continue;
                        classObfs.put(sp[map], sp[1]);
                        classObfsR.put(sp[1], sp[map]);
                        continue;
                    }
                    if (sp[0].equals("field")) {
                        if (sp[map].equals("?")) continue;
                        fieldObfs.put(sp[1], sp[map]);
                        continue;
                    }
                    if (!sp[0].equals("override")) continue;
                    overrides.computeIfAbsent(sp[1], CPMTransformerService$$Lambda$1.lambdaFactory$()).add(sp[2]);
                }
                LOG.info("Loaded Obfuscation Mappings");
            }
            catch (Throwable ln2) {
                throwable = ln2;
                throw ln2;
            }
            finally {
                if (rd != null) {
                    if (throwable != null) {
                        try {
                            rd.close();
                        }
                        catch (Throwable ln2) {
                        }
                    } else {
                        rd.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load obf mapping, installed mod jar is corrupted!", e);
        }
        if (bukkit) {
            classObfsBukkit = new HashMap<String, String>();
            try {
                rd = new BufferedReader(new InputStreamReader(CPMTransformerService.class.getResourceAsStream("/META-INF/cpm_bukkit.cfg")));
                throwable = null;
                try {
                    while ((ln2 = rd.readLine()) != null) {
                        if ((ln2 = ln2.trim()).isEmpty() || ln2.startsWith("#")) continue;
                        String[] sp = ln2.split(" ");
                        if (sp[0].equals("method")) {
                            int i = sp[2].indexOf(40);
                            i = sp[2].lastIndexOf(47, i);
                            String nameDesc = sp[2].substring(i + 1);
                            int ind = nameDesc.indexOf(40);
                            String mth = nameDesc.substring(0, ind);
                            String par = nameDesc.substring(ind).replace('.', '/');
                            methodObfs.put(sp[1], Pair.of(mth, par));
                            continue;
                        }
                        if (sp[0].equals("class")) {
                            classObfsBukkit.put(sp[1], sp[2]);
                            continue;
                        }
                        if (!sp[0].equals("field")) continue;
                        fieldObfs.put(sp[1], sp[2]);
                    }
                    LOG.info("Loaded Bukkit Mappings");
                }
                catch (Throwable ln3) {
                    throwable = ln3;
                    throw ln3;
                }
                finally {
                    if (rd != null) {
                        if (throwable != null) {
                            try {
                                rd.close();
                            }
                            catch (Throwable ln3) {
                            }
                        } else {
                            rd.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load obf mapping, installed mod jar is corrupted!", e);
            }
        }
        transformers.put("net.minecraft.src.NetServerHandler", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                Pair mth = CPMTransformerService.lookupMethod("NetHandler;handleCustomPayload(Lnet.minecraft.src.Packet250CustomPayload;)V");
                InsnList lst = new InsnList();
                lst.add(new VarInsnNode(25, 1));
                lst.add(new VarInsnNode(25, 0));
                lst.add(new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS_SERVER, "onServerPacket", CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/Packet250CustomPayload;Lnet/minecraft/src/NetServerHandler;)Z")));
                LabelNode lbln = new LabelNode();
                lst.add(new JumpInsnNode(153, lbln));
                lst.add(new InsnNode(177));
                lst.add(lbln);
                input.interfaces.add("com/tom/cpm/common/ServerNetworkImpl");
                input.fields.add(new FieldNode(1, CPMTransformerService.HAS_MOD_FIELD, "Z", null, 0));
                input.fields.add(new FieldNode(1, CPMTransformerService.DATA_FIELD, "Lcom/tom/cpm/shared/config/PlayerData;", null, null));
                for (MethodNode method : input.methods) {
                    if (!CPMTransformerService.checkMethod(method, (Pair<String, String>)mth)) continue;
                    LOG.info("CPM ServerNet Hook: Found processCustomPayload");
                    method.instructions.insertBefore(method.instructions.getFirst(), lst);
                    LOG.info("CPM ServerNet Hook: injected");
                }
                CPMTransformerService.injectHasMod("ServerNet", input);
                CPMTransformerService.injectInterfaceWrappers("ServerNet", CPMTransformerService.HOOKS_CLASS_SERVER, input, new String[]{"cpm$sendPacket(Ljava/lang/String;[B)V", "cpm$getPlayer()Lnet/minecraft/src/EntityPlayer;", "cpm$sendChat(Ljava/lang/String;)V", "cpm$kickPlayer(Ljava/lang/String;)V"});
                MethodNode method = new MethodNode(1, "cpm$getEncodedModelData", "()Lcom/tom/cpm/shared/config/PlayerData;", null, null);
                input.methods.add(method);
                method.instructions.add(new VarInsnNode(25, 0));
                method.instructions.add(new FieldInsnNode(180, input.name, CPMTransformerService.DATA_FIELD, "Lcom/tom/cpm/shared/config/PlayerData;"));
                method.instructions.add(new InsnNode(176));
                method.maxLocals = 2;
                method.maxStack = 2;
                LOG.info("CPM ServerNet/getData: injected");
                method = new MethodNode(1, "cpm$setEncodedModelData", "(Lcom/tom/cpm/shared/config/PlayerData;)V", null, null);
                input.methods.add(method);
                method.instructions.add(new VarInsnNode(25, 0));
                method.instructions.add(new VarInsnNode(25, 1));
                method.instructions.add(new FieldInsnNode(181, input.name, CPMTransformerService.DATA_FIELD, "Lcom/tom/cpm/shared/config/PlayerData;"));
                method.instructions.add(new InsnNode(177));
                method.maxLocals = 2;
                method.maxStack = 2;
                LOG.info("CPM ServerNet/setData: injected");
                return input;
            }
        });
        transformers.put("net.minecraft.src.NetClientHandler", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                InsnList lst = new InsnList();
                lst.add(new VarInsnNode(25, 1));
                lst.add(new VarInsnNode(25, 0));
                lst.add(new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onClientPacket", CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/Packet250CustomPayload;Lnet/minecraft/src/NetClientHandler;)Z")));
                LabelNode lbln = new LabelNode();
                lst.add(new JumpInsnNode(153, lbln));
                lst.add(new InsnNode(177));
                lst.add(lbln);
                input.interfaces.add("com/tom/cpm/client/ClientNetworkImpl");
                input.fields.add(new FieldNode(1, CPMTransformerService.HAS_MOD_FIELD, "Z", null, 0));
                Pair mth = CPMTransformerService.lookupMethod("NetHandler;handleCustomPayload(Lnet.minecraft.src.Packet250CustomPayload;)V");
                for (MethodNode method : input.methods) {
                    if (!CPMTransformerService.checkMethod(method, (Pair<String, String>)mth)) continue;
                    LOG.info("CPM ClientNet Hook: Found handleCustomPayload");
                    method.instructions.insertBefore(method.instructions.getFirst(), lst);
                    LOG.info("CPM ClientNet Hook: injected");
                }
                CPMTransformerService.injectHasMod("ClientNet", input);
                CPMTransformerService.injectInterfaceWrappers("ClientNet", CPMTransformerService.HOOKS_CLASS, input, new String[]{"cpm$sendPacket(Ljava/lang/String;[B)V", "cpm$getEntityByID(I)Lnet/minecraft/src/Entity;"});
                return input;
            }
        });
        transformers.put("com.tom.cpmcore.CPMClientAccess", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                for (MethodNode method : input.methods) {
                    if (!method.name.equals("setNoSetup")) continue;
                    method.instructions.clear();
                    method.instructions.add(new VarInsnNode(25, 0));
                    method.instructions.add(new VarInsnNode(21, 1));
                    method.instructions.add(new FieldInsnNode(181, Type.getArgumentTypes(method.desc)[0].getInternalName(), CPMTransformerService.NO_MODEL_SETUP_FIELD, "Z"));
                    method.instructions.add(new InsnNode(177));
                    LOG.info("CPM ASM fields/No Render: injected");
                }
                return input;
            }
        });
        transformers.put("net.minecraft.src.ModelBiped", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                input.fields.add(new FieldNode(1, CPMTransformerService.NO_MODEL_SETUP_FIELD, "Z", null, 0));
                Pair mth = CPMTransformerService.lookupMethod("ModelBiped;setRotationAngles(FFFFFF)V");
                for (MethodNode method : input.methods) {
                    if (!CPMTransformerService.checkMethod(method, (Pair<String, String>)mth)) continue;
                    LOG.info("CPM Armor Hook/No setup: found setRotationAngles method");
                    InsnList lst = new InsnList();
                    lst.add(new VarInsnNode(25, 0));
                    lst.add(new FieldInsnNode(180, input.name, CPMTransformerService.NO_MODEL_SETUP_FIELD, "Z"));
                    LabelNode lbln = new LabelNode();
                    lst.add(new JumpInsnNode(153, lbln));
                    lst.add(new InsnNode(177));
                    lst.add(lbln);
                    method.instructions.insertBefore(method.instructions.getFirst(), lst);
                    LOG.info("CPM Armor Hook/No setup: injected");
                }
                return input;
            }
        });
        transformers.put("net.minecraft.src.RenderLiving", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                Pair mth = CPMTransformerService.lookupMethod("RenderLiving;doRenderLiving(Lnet.minecraft.src.EntityLiving;DDDFF)V");
                Pair mth2 = CPMTransformerService.lookupMethod("ModelBase;render(Lnet.minecraft.src.Entity;FFFFFF)V");
                for (MethodNode m : input.methods) {
                    if (!CPMTransformerService.checkMethod(m, (Pair<String, String>)mth) && !m.name.equals("renderPlayer")) continue;
                    LOG.info("CPM Armor Hook: Found doRender method");
                    m.instructions.insertBefore(m.instructions.getFirst(), new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "prePlayerRender", "()V"));
                    int callLoc = 0;
                    m.maxStack += 3;
                    ListIterator it = m.instructions.iterator();
                    while (it.hasNext()) {
                        AbstractInsnNode insnNode = (AbstractInsnNode)it.next();
                        if (!(insnNode instanceof MethodInsnNode)) continue;
                        MethodInsnNode mn = (MethodInsnNode)insnNode;
                        if (CPMTransformerService.checkMethod(mn, (Pair<String, String>)mth2)) {
                            LOG.info("CPM Armor Hook: Found render call");
                            Type[] argsD = Type.getArgumentTypes(mn.desc);
                            Type[] args = new Type[argsD.length + 3];
                            args[0] = Type.getObjectType(mn.owner);
                            System.arraycopy(argsD, 0, args, 1, argsD.length);
                            args[args.length - 2] = CPMTransformerService.obfType(Type.getObjectType("net/minecraft/src/RenderLiving"));
                            args[args.length - 1] = Type.INT_TYPE;
                            mn.desc = Type.getMethodDescriptor(Type.VOID_TYPE, args);
                            mn.name = "renderPass";
                            mn.setOpcode(184);
                            mn.owner = CPMTransformerService.HOOKS_CLASS;
                            InsnList lst = new InsnList();
                            lst.add(new VarInsnNode(25, 0));
                            lst.add(new LdcInsnNode((Object)callLoc++));
                            m.instructions.insertBefore(insnNode, lst);
                            LOG.info("CPM Armor Hook/Layer: injected");
                            continue;
                        }
                        if (!mn.name.equals("glColor4f")) continue;
                        mn.owner = CPMTransformerService.HOOKS_CLASS;
                        LOG.info("CPM Player Renderer/Color hook: injected");
                    }
                }
                return input;
            }
        });
        transformers.put("net.minecraft.client.Minecraft", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                Pair mth = CPMTransformerService.lookupMethod("Minecraft;changeWorld(Lnet.minecraft.src.World;Ljava/lang/String;Lnet.minecraft.src.EntityPlayer;)V");
                Pair mth2 = CPMTransformerService.lookupMethod("Minecraft;displayGuiScreen(Lnet.minecraft.src.GuiScreen;)V");
                Pair mth3 = CPMTransformerService.lookupMethod("Minecraft;startWorld(Ljava/lang/String;Ljava/lang/String;Lnet.minecraft.src.WorldSettings;)V");
                String f = CPMTransformerService.lookupField("Minecraft;thePlayer");
                Pair mth4 = CPMTransformerService.lookupMethod("Minecraft;runTick()V");
                Pair mth5 = CPMTransformerService.lookupMethod("Minecraft;isMultiplayerWorld()Z");
                Pair mth6 = CPMTransformerService.lookupMethod("Minecraft;lineIsCommand(Ljava/lang/String;)Z");
                for (MethodNode method : input.methods) {
                    AbstractInsnNode insnNode;
                    ListIterator it;
                    if (CPMTransformerService.checkMethod(method, (Pair<String, String>)mth)) {
                        LOG.info("CPM ClientLogout Hook: Found loadWorld");
                        InsnList lst = new InsnList();
                        lst.add(new VarInsnNode(25, 1));
                        lst.add(new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onLogout", CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/World;)V")));
                        method.instructions.insertBefore(method.instructions.getFirst(), lst);
                        LOG.info("CPM ClientLogout Hook: injected");
                        it = method.instructions.iterator();
                        while (it.hasNext()) {
                            insnNode = (AbstractInsnNode)it.next();
                            if (!(insnNode instanceof FieldInsnNode) || insnNode.getOpcode() != 181) continue;
                            FieldInsnNode fn = (FieldInsnNode)insnNode;
                            if (!fn.name.equals(f)) continue;
                            LOG.info("CPM ClientLogin Hook: found create player");
                            method.instructions.insert(insnNode, new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onSinglePlayerLogin", "()V"));
                            LOG.info("CPM ClientLogin Hook: injected");
                        }
                        continue;
                    }
                    if (CPMTransformerService.checkMethod(method, (Pair<String, String>)mth2)) {
                        LOG.info("CPM Open Gui Hook: Found displayGuiScreen");
                        InsnList list = new InsnList();
                        list.add(new VarInsnNode(25, 1));
                        list.add(new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "openGui", CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/GuiScreen;)Lnet/minecraft/src/GuiScreen;")));
                        list.add(new VarInsnNode(58, 1));
                        method.instructions.insertBefore(method.instructions.getFirst(), list);
                        LOG.info("CPM Open Gui Hook: injected");
                        continue;
                    }
                    if (CPMTransformerService.checkMethod(method, (Pair<String, String>)mth3)) {
                        LOG.info("CPM Start World Hook: Found startWorld");
                        ListIterator it2 = method.instructions.iterator();
                        while (it2.hasNext()) {
                            AbstractInsnNode insnNode2 = (AbstractInsnNode)it2.next();
                            if (!(insnNode2 instanceof MethodInsnNode)) continue;
                            MethodInsnNode mn = (MethodInsnNode)insnNode2;
                            if (!mn.name.equals("<init>") || !mn.owner.equals(CPMTransformerService.obfObj("net/minecraft/src/World"))) continue;
                            LOG.info("CPM Button Click Hook: Found World constructor");
                            InsnList list = new InsnList();
                            list.add(new VarInsnNode(25, 4));
                            list.add(new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "startSinglePlayer", CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/ISaveHandler;)V")));
                            method.instructions.insert((AbstractInsnNode)mn, list);
                            LOG.info("CPM Start World Hook: injected");
                        }
                        continue;
                    }
                    if (CPMTransformerService.checkMethod(method, (Pair<String, String>)mth4)) {
                        LOG.info("CPM Tick Hook: Found runTick");
                        int i = 0;
                        it = method.instructions.iterator();
                        while (it.hasNext()) {
                            insnNode = (AbstractInsnNode)it.next();
                            if (spc && insnNode instanceof MethodInsnNode && CPMTransformerService.checkMethod((MethodInsnNode)insnNode, (Pair<String, String>)mth5) && i++ < 2) {
                                LOG.info("CPM SPC Hook: Found isMultiplayerWorld " + i);
                                MethodInsnNode mn = (MethodInsnNode)insnNode;
                                mn.owner = CPMTransformerService.HOOKS_CLASS;
                                mn.name = "isChatEnabled";
                                mn.desc = "(Lnet/minecraft/client/Minecraft;)Z";
                                mn.setOpcode(184);
                                LOG.info("CPM SPC Hook: injected " + i);
                                continue;
                            }
                            if (insnNode.getOpcode() != 177) continue;
                            method.instructions.insertBefore(insnNode, new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "clientTickEnd", "()V"));
                            LOG.info("CPM Tick Hook: injected");
                        }
                        continue;
                    }
                    if (!spc || !CPMTransformerService.checkMethod(method, (Pair<String, String>)mth6)) continue;
                    LOG.info("CPM SPC Hook: Found lineIsCommand");
                    method.instructions.clear();
                    method.instructions.add(new VarInsnNode(25, 0));
                    method.instructions.add(new VarInsnNode(25, 1));
                    method.instructions.add(new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "testCommand", CPMTransformerService.obfMethodDesc("(Lnet/minecraft/client/Minecraft;Ljava/lang/String;)Z")));
                    method.instructions.add(new InsnNode(172));
                    LOG.info("CPM SPC Hook: Found injected");
                }
                return input;
            }
        });
        transformers.put("net.minecraft.src.RenderPlayer", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                Pair mth = CPMTransformerService.lookupMethod("RenderPlayer;renderSpecials(Lnet.minecraft.src.EntityPlayer;F)V");
                Pair mth2 = CPMTransformerService.lookupMethod("RenderPlayer;drawFirstPersonHand()V");
                Pair mth3 = CPMTransformerService.lookupMethod("RenderPlayer;renderPlayer(Lnet.minecraft.src.EntityPlayer;DDDFF)V");
                Pair mth4 = CPMTransformerService.lookupMethod("RenderPlayer;renderName(Lnet.minecraft.src.EntityPlayer;DDD)V");
                Pair mth5 = CPMTransformerService.lookupMethod("Render;loadDownloadableImageTexture(Ljava/lang/String;Ljava/lang/String;)Z");
                input.interfaces.add("com/tom/cpmcore/IPlayerRenderer");
                for (MethodNode method : input.methods) {
                    AbstractInsnNode insnNode;
                    ListIterator it;
                    InsnList lst;
                    if (CPMTransformerService.checkMethod(method, (Pair<String, String>)mth)) {
                        LOG.info("CPM Cape Hook: Found renderEquippedItems");
                        ListIterator it2 = method.instructions.iterator();
                        while (it2.hasNext()) {
                            MethodInsnNode mn;
                            AbstractInsnNode insnNode2 = (AbstractInsnNode)it2.next();
                            if (!(insnNode2 instanceof MethodInsnNode) || !CPMTransformerService.checkMethod(mn = (MethodInsnNode)insnNode2, (Pair<String, String>)mth5)) continue;
                            LOG.info("CPM Cape Hook: Found renderCape");
                            InsnList lst2 = new InsnList();
                            lst2.add(new VarInsnNode(25, 0));
                            lst2.add(new VarInsnNode(25, 1));
                            lst2.add(new VarInsnNode(23, 2));
                            lst2.add(new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "renderCape", CPMTransformerService.obfMethodDesc("(ZLnet/minecraft/src/RenderPlayer;Lnet/minecraft/src/EntityPlayer;F)Z")));
                            method.instructions.insert(insnNode2, lst2);
                            LOG.info("CPM Cape Hook: injected");
                        }
                        continue;
                    }
                    if (CPMTransformerService.checkMethod(method, (Pair<String, String>)mth2)) {
                        LOG.info("CPM Hand Hook: Found renderFirstPersonArm");
                        lst = new InsnList();
                        lst.add(new VarInsnNode(25, 0));
                        lst.add(new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onHandPre", CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/RenderPlayer;)V")));
                        method.instructions.insertBefore(method.instructions.getFirst(), lst);
                        LOG.info("CPM Render Hand Hook Pre: injected");
                        InsnList lst2 = new InsnList();
                        lst2.add(new VarInsnNode(25, 0));
                        lst2.add(new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onHandPost", CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/RenderPlayer;)V")));
                        it = method.instructions.iterator();
                        while (it.hasNext()) {
                            insnNode = (AbstractInsnNode)it.next();
                            if (!(insnNode instanceof InsnNode) || insnNode.getOpcode() != 177) continue;
                            method.instructions.insertBefore(insnNode, lst2);
                            LOG.info("CPM Render Hand Hook Post: injected");
                        }
                        continue;
                    }
                    if (CPMTransformerService.checkMethod(method, (Pair<String, String>)mth3)) {
                        LOG.info("CPM Player Render Hook: Found renderPlayer");
                        InsnList lst2 = new InsnList();
                        lst2.add(new VarInsnNode(25, 0));
                        lst2.add(new VarInsnNode(25, 1));
                        lst2.add(new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "playerRenderPre", CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/RenderPlayer;Lnet/minecraft/src/EntityPlayer;)V")));
                        InsnList lst3 = new InsnList();
                        lst3.add(new VarInsnNode(25, 0));
                        lst3.add(new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "playerRenderPost", CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/RenderPlayer;)V")));
                        method.instructions.insertBefore(method.instructions.getFirst(), lst2);
                        LOG.info("CPM Player Render Hook Pre: injected");
                        it = method.instructions.iterator();
                        while (it.hasNext()) {
                            insnNode = (AbstractInsnNode)it.next();
                            if (!(insnNode instanceof InsnNode) || insnNode.getOpcode() != 177) continue;
                            method.instructions.insertBefore(insnNode, lst3);
                            LOG.info("CPM Player Render Hook Post: injected");
                        }
                        continue;
                    }
                    if (!CPMTransformerService.checkMethod(method, (Pair<String, String>)mth4)) continue;
                    LOG.info("CPM Name Hook: Found renderName method");
                    lst = new InsnList();
                    lst.add(new VarInsnNode(25, 0));
                    lst.add(new VarInsnNode(25, 1));
                    lst.add(new VarInsnNode(24, 2));
                    lst.add(new VarInsnNode(24, 4));
                    lst.add(new VarInsnNode(24, 6));
                    lst.add(new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onRenderName", CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/RenderPlayer;Lnet/minecraft/src/EntityPlayer;DDD)Z")));
                    LabelNode lbln = new LabelNode();
                    lst.add(new JumpInsnNode(153, lbln));
                    lst.add(new InsnNode(177));
                    lst.add(lbln);
                    method.instructions.insertBefore(method.instructions.getFirst(), lst);
                    LOG.info("CPM Name Hook: injected");
                }
                String name = CPMLoadingPlugin.deobf ? "renderModel" : "func_77036_a";
                LOG.info("CPM Render Invis Hook: Injecting method " + (CPMLoadingPlugin.deobf ? "deobf" : ""));
                MethodNode mn = new MethodNode(1, name, CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/EntityLiving;FFFFFF)V"), null, null);
                mn.instructions.add(new VarInsnNode(25, 0));
                mn.instructions.add(new VarInsnNode(25, 1));
                mn.instructions.add(new VarInsnNode(23, 2));
                mn.instructions.add(new VarInsnNode(23, 3));
                mn.instructions.add(new VarInsnNode(23, 4));
                mn.instructions.add(new VarInsnNode(23, 5));
                mn.instructions.add(new VarInsnNode(23, 6));
                mn.instructions.add(new VarInsnNode(23, 7));
                mn.instructions.add(new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onRenderPlayerModel", CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/RenderPlayer;Lnet/minecraft/src/EntityLiving;FFFFFF)Z")));
                LabelNode lbln = new LabelNode();
                mn.instructions.add(new JumpInsnNode(153, lbln));
                mn.instructions.add(new InsnNode(177));
                mn.instructions.add(lbln);
                mn.instructions.add(new VarInsnNode(25, 0));
                mn.instructions.add(new VarInsnNode(25, 1));
                mn.instructions.add(new VarInsnNode(23, 2));
                mn.instructions.add(new VarInsnNode(23, 3));
                mn.instructions.add(new VarInsnNode(23, 4));
                mn.instructions.add(new VarInsnNode(23, 5));
                mn.instructions.add(new VarInsnNode(23, 6));
                mn.instructions.add(new VarInsnNode(23, 7));
                mn.instructions.add(new MethodInsnNode(183, CPMTransformerService.obfObj("net/minecraft/src/RenderLiving"), name, CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/EntityLiving;FFFFFF)V")));
                mn.instructions.add(new InsnNode(177));
                mn.maxLocals = 8;
                mn.maxStack = 8;
                input.methods.add(mn);
                LOG.info("CPM Render Invis Hook: injected");
                name = CPMLoadingPlugin.deobf ? "bindEntityTexture" : "func_110777_b";
                mn = new MethodNode(1, "cpm$bindEntityTexture", CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/EntityPlayer;)V"), null, null);
                mn.instructions.add(new VarInsnNode(25, 0));
                mn.instructions.add(new VarInsnNode(25, 1));
                mn.instructions.add(new MethodInsnNode(182, input.name, name, CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/Entity;)V")));
                mn.instructions.add(new InsnNode(177));
                mn.maxLocals = 2;
                mn.maxStack = 2;
                input.methods.add(mn);
                LOG.info("CPM Render Invis Hook/Bind Texture: injected");
                return input;
            }
        });
        transformers.put("net.minecraft.src.ThreadDownloadImage", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                for (MethodNode method : input.methods) {
                    if (!method.name.equals("run")) continue;
                    LOG.info("CPM Skin Fixer Hook: Found run");
                    ListIterator it = method.instructions.iterator();
                    while (it.hasNext()) {
                        AbstractInsnNode insnNode = (AbstractInsnNode)it.next();
                        if (!(insnNode instanceof MethodInsnNode)) continue;
                        MethodInsnNode mn = (MethodInsnNode)insnNode;
                        if (!mn.owner.equals("java/net/URL") || !mn.name.equals("<init>")) continue;
                        method.instructions.insertBefore(insnNode, new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "fixSkinURL", "(Ljava/lang/String;)Ljava/lang/String;"));
                        LOG.info("CPM Skin Fixer Hook: injected");
                    }
                }
                return input;
            }
        });
        transformers.put("net.minecraft.src.EntityTrackerEntry", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                Pair mth = CPMTransformerService.lookupMethod("EntityTrackerEntry;tryStartWachingThis(Lnet.minecraft.src.EntityPlayerMP;)V");
                Pair mth2 = CPMTransformerService.lookupMethod("EntityPlayer;isPlayerSleeping()Z");
                for (MethodNode method : input.methods) {
                    if (!CPMTransformerService.checkMethod(method, (Pair<String, String>)mth)) continue;
                    LOG.info("CPM Start Tracking Hook: Found tryStartWachingThis");
                    ListIterator it = method.instructions.iterator();
                    while (it.hasNext()) {
                        AbstractInsnNode insnNode = (AbstractInsnNode)it.next();
                        if (!(insnNode instanceof MethodInsnNode) || !CPMTransformerService.checkMethod((MethodInsnNode)insnNode, (Pair<String, String>)mth2)) continue;
                        LOG.info("CPM Start Tracking Hook: Found isPlayerSleeping");
                        InsnList in = new InsnList();
                        in.add(new InsnNode(89));
                        in.add(new VarInsnNode(25, 1));
                        in.add(new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS_SERVER, "startTracking", CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/EntityPlayer;Lnet/minecraft/src/EntityPlayerMP;)V")));
                        method.instructions.insertBefore(insnNode, in);
                        LOG.info("CPM Start Tracking Hook: injected");
                    }
                }
                return input;
            }
        });
        transformers.put("net.minecraft.src.EntityRenderer", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                Pair mth = CPMTransformerService.lookupMethod("EntityRenderer;updateCameraAndRender(F)V");
                Pair mth2 = CPMTransformerService.lookupMethod("GuiScreen;drawScreen(IIF)V");
                for (MethodNode method : input.methods) {
                    if (!CPMTransformerService.checkMethod(method, (Pair<String, String>)mth)) continue;
                    LOG.info("CPM Draw Screen Hook: Found updateCameraAndRender");
                    ListIterator it = method.instructions.iterator();
                    while (it.hasNext()) {
                        AbstractInsnNode insnNode = (AbstractInsnNode)it.next();
                        if (!(insnNode instanceof MethodInsnNode) || !CPMTransformerService.checkMethod((MethodInsnNode)insnNode, (Pair<String, String>)mth2)) continue;
                        LOG.info("CPM Draw Screen Hook: Found drawScreen");
                        method.instructions.insertBefore(insnNode, new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onDrawScreenPre", "()V"));
                        method.instructions.insert(insnNode, new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onDrawScreenPost", "()V"));
                        LOG.info("CPM Draw Screen Hook: injected");
                    }
                }
                return input;
            }
        });
        transformers.put("net.minecraft.src.GuiScreen", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                Pair mth = CPMTransformerService.lookupMethod("GuiScreen;setWorldAndResolution(Lnet.minecraft.client.Minecraft;II)V");
                Pair mth2 = CPMTransformerService.lookupMethod("GuiScreen;mouseClicked(III)V");
                Pair mth3 = CPMTransformerService.lookupMethod("GuiScreen;actionPerformed(Lnet.minecraft.src.GuiButton;)V");
                for (MethodNode method : input.methods) {
                    InsnList list;
                    AbstractInsnNode insnNode;
                    ListIterator it;
                    if (CPMTransformerService.checkMethod(method, (Pair<String, String>)mth)) {
                        LOG.info("CPM Init Screen Hook: Found setWorldAndResolution");
                        it = method.instructions.iterator();
                        while (it.hasNext()) {
                            insnNode = (AbstractInsnNode)it.next();
                            if (!(insnNode instanceof InsnNode) || insnNode.getOpcode() != 177) continue;
                            list = new InsnList();
                            list.add(new VarInsnNode(25, 0));
                            list.add(new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onInitScreen", CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/GuiScreen;)V")));
                            method.instructions.insertBefore(insnNode, list);
                            LOG.info("CPM Init Screen Hook: injected");
                        }
                        continue;
                    }
                    if (!CPMTransformerService.checkMethod(method, (Pair<String, String>)mth2) && !method.name.equals("getEntityID")) continue;
                    LOG.info("CPM Button Click Hook: Found mouseClicked");
                    it = method.instructions.iterator();
                    while (it.hasNext()) {
                        insnNode = (AbstractInsnNode)it.next();
                        if (!(insnNode instanceof MethodInsnNode) || !CPMTransformerService.checkMethod((MethodInsnNode)insnNode, (Pair<String, String>)mth3) && !((MethodInsnNode)insnNode).name.equals("useItem")) continue;
                        LOG.info("CPM Button Click Hook: Found actionPerformed");
                        list = new InsnList();
                        list.add(new InsnNode(89));
                        list.add(new VarInsnNode(25, 0));
                        list.add(new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onGuiButtonClick", CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/GuiButton;Lnet/minecraft/src/GuiScreen;)V")));
                        method.instructions.insertBefore(insnNode, list);
                        LOG.info("CPM Button Click Hook: injected");
                    }
                }
                return input;
            }
        });
        transformers.put("net.minecraft.src.OpenGlHelper", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                Pair mth = CPMTransformerService.lookupMethod("OpenGlHelper;setLightmapTextureCoords(IFF)V");
                for (MethodNode method : input.methods) {
                    if (!CPMTransformerService.checkMethod(method, (Pair<String, String>)mth)) continue;
                    LOG.info("CPM OpenGlHelper Hook: Found setLightmapTextureCoords");
                    InsnList list = new InsnList();
                    list.add(new VarInsnNode(21, 0));
                    list.add(new VarInsnNode(23, 1));
                    list.add(new VarInsnNode(23, 2));
                    list.add(new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "setLightmap", "(IFF)V"));
                    method.instructions.insertBefore(method.instructions.getFirst(), list);
                    LOG.info("CPM OpenGlHelper Hook: Found setLightmapTextureCoords");
                }
                return input;
            }
        });
        transformers.put("com.tom.cpm.CustomPlayerModels", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                for (MethodNode method : input.methods) {
                    if (!method.name.equals("makeProxy")) continue;
                    LOG.info("CPM Proxy Hook: Found makeProxy");
                    String clazz = isDedicatedServer ? "com/tom/cpm/server/ServerProxy" : "com/tom/cpm/client/ClientProxy";
                    method.instructions.clear();
                    method.instructions.add(new MethodInsnNode(184, clazz, method.name, method.desc));
                    method.instructions.add(new InsnNode(176));
                    LOG.info("CPM Proxy Hook: injected");
                }
                return input;
            }
        });
        if (spc) {
            transformers.put("net.minecraft.src.GuiChat", new UnaryOperator<ClassNode>(){

                @Override
                public ClassNode apply(ClassNode input) {
                    Pair mth = CPMTransformerService.lookupMethod("GuiScreen;keyTyped(CI)V");
                    Pair mth2 = CPMTransformerService.lookupMethod("GuiChat;completePlayerName()V");
                    Pair mth3 = CPMTransformerService.lookupMethod("GuiScreen;doesGuiPauseGame()Z");
                    boolean pauseMthFound = false;
                    for (MethodNode method : input.methods) {
                        if (CPMTransformerService.checkMethod(method, (Pair<String, String>)mth)) {
                            LOG.info("CPM SPC Hook: Found keyTyped");
                            ListIterator it = method.instructions.iterator();
                            while (it.hasNext()) {
                                MethodInsnNode mn;
                                AbstractInsnNode insnNode = (AbstractInsnNode)it.next();
                                if (!(insnNode instanceof MethodInsnNode) || !CPMTransformerService.checkMethod(mn = (MethodInsnNode)insnNode, (Pair<String, String>)mth2)) continue;
                                LOG.info("CPM SPC Hook: Found completePlayerName");
                                mn.setOpcode(184);
                                mn.owner = CPMTransformerService.HOOKS_CLASS;
                                mn.name = "tabComplete";
                                mn.desc = CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/GuiChat;)V");
                                LOG.info("CPM SPC Hook: injected");
                            }
                            continue;
                        }
                        if (!CPMTransformerService.checkMethod(method, (Pair<String, String>)mth3)) continue;
                        pauseMthFound = true;
                        LOG.info("CPM SPC Pause Hook: doesGuiPauseGame found skipping");
                    }
                    if (!pauseMthFound) {
                        MethodNode mn = new MethodNode(1, (String)mth3.getKey(), (String)mth3.getValue(), null, null);
                        mn.instructions.add(new InsnNode(3));
                        mn.instructions.add(new InsnNode(172));
                        mn.maxLocals = 2;
                        mn.maxStack = 2;
                        input.methods.add(mn);
                        LOG.info("CPM SPC Pause Hook: injected");
                    }
                    return input;
                }
            });
        }
        transformers.put("net.minecraft.server.MinecraftServer", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                Pair mth = CPMTransformerService.lookupMethod("MinecraftServer;stopServer()V");
                Pair mth2 = CPMTransformerService.lookupMethod("MinecraftServer;initWorld(Lnet.minecraft.src.ISaveFormat;Ljava/lang/String;JLnet.minecraft.src.WorldType;)V");
                for (MethodNode method : input.methods) {
                    if (CPMTransformerService.checkMethod(method, (Pair<String, String>)mth)) {
                        LOG.info("CPM Server Hook: Found stopServer");
                        ListIterator it = method.instructions.iterator();
                        while (it.hasNext()) {
                            AbstractInsnNode insnNode = (AbstractInsnNode)it.next();
                            if (!(insnNode instanceof InsnNode) || insnNode.getOpcode() != 177) continue;
                            method.instructions.insertBefore(insnNode, new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS_SERVER, "onStopped", "()V"));
                            LOG.info("CPM Server Hook: injected");
                        }
                        continue;
                    }
                    if (!CPMTransformerService.checkMethod(method, (Pair<String, String>)mth2)) continue;
                    LOG.info("CPM Server Hook: Found initWorld");
                    InsnList list = new InsnList();
                    list.add(new VarInsnNode(25, 9));
                    list.add(new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS_SERVER, "onStarting", CPMTransformerService.obfMethodDesc("(Lnet/minecraft/src/AnvilSaveHandler;)V")));
                    String ws = (String)classObfsR.get("net.minecraft.src.WorldServer");
                    ListIterator it = method.instructions.iterator();
                    while (it.hasNext()) {
                        AbstractInsnNode insnNode = (AbstractInsnNode)it.next();
                        if (!(insnNode instanceof MethodInsnNode)) continue;
                        MethodInsnNode mn = (MethodInsnNode)insnNode;
                        if (!mn.owner.equals(ws) || !mn.name.equals("<init>")) continue;
                        method.instructions.insert(insnNode, list);
                        LOG.info("CPM Server Hook: injected");
                    }
                }
                return input;
            }
        });
        if (!CPMLoadingPlugin.deobf) {
            try {
                rd = new BufferedReader(new InputStreamReader(CPMTransformerService.class.getResourceAsStream("/META-INF/cpm_at.cfg")));
                throwable = null;
                try {
                    while ((ln2 = rd.readLine()) != null) {
                        if ((ln2 = ln2.trim()).isEmpty() || ln2.startsWith("#")) continue;
                        String[] sp = ln2.split(" ")[1].split("\\.");
                        fieldATs.computeIfAbsent(sp[0], CPMTransformerService$$Lambda$2.lambdaFactory$()).add(sp[1]);
                    }
                    LOG.info("Loaded Access Transformer");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rd != null) {
                        if (throwable != null) {
                            try {
                                rd.close();
                            }
                            catch (Throwable throwable3) {
                            }
                        } else {
                            rd.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load obf mapping, installed mod jar is corrupted!", e);
            }
        }
    }

    private static void injectHasMod(String name, ClassNode input) {
        MethodNode method = new MethodNode(1, HAS_MOD_FIELD, "()Z", null, null);
        input.methods.add(method);
        method.instructions.add(new VarInsnNode(25, 0));
        method.instructions.add(new FieldInsnNode(180, input.name, HAS_MOD_FIELD, "Z"));
        method.instructions.add(new InsnNode(172));
        method.maxLocals = 2;
        method.maxStack = 2;
        LOG.info("CPM " + name + "/hasMod: injected");
        method = new MethodNode(1, "cpm$setHasMod", "(Z)V", null, null);
        input.methods.add(method);
        method.instructions.add(new VarInsnNode(25, 0));
        method.instructions.add(new VarInsnNode(21, 1));
        method.instructions.add(new FieldInsnNode(181, input.name, HAS_MOD_FIELD, "Z"));
        method.instructions.add(new InsnNode(177));
        method.maxLocals = 2;
        method.maxStack = 2;
        LOG.info("CPM " + name + "/setHasMod: injected");
    }

    private static void injectInterfaceWrappers(String name, String hooks, ClassNode input, String ... methods) {
        for (int i = 0; i < methods.length; ++i) {
            String mnd = methods[i];
            int in = mnd.indexOf(40);
            String mn = mnd.substring(0, in);
            String md = mnd.substring(in);
            md = CPMTransformerService.obfMethodDesc(md);
            MethodNode method = new MethodNode(1, mn, md, null, null);
            input.methods.add(method);
            Type mdt = Type.getMethodType(md);
            Type[] args = new Type[mdt.getArgumentTypes().length + 1];
            args[0] = Type.getObjectType(input.name);
            System.arraycopy(mdt.getArgumentTypes(), 0, args, 1, mdt.getArgumentTypes().length);
            for (int j = 0; j < args.length; ++j) {
                Type a = args[j];
                method.instructions.add(new VarInsnNode(a.getOpcode(21), j));
            }
            method.instructions.add(new MethodInsnNode(184, hooks, "inj_" + mn.substring(4), Type.getMethodDescriptor(mdt.getReturnType(), args)));
            method.instructions.add(new InsnNode(mdt.getReturnType().getOpcode(172)));
            method.maxLocals = mdt.getArgumentTypes().length + 2;
            method.maxStack = mdt.getArgumentTypes().length + 2;
            LOG.info("CPM " + name + "/" + mn.substring(4) + ": injected");
        }
    }

    private static Type obfType(Type type) {
        String in;
        if (type.getSort() == 10 && ((in = type.getInternalName()).startsWith("net/minecraft") || isDedicatedServer && in.equals("BaseMod"))) {
            if (isDedicatedServer && in.equals("BaseMod")) {
                return Type.getObjectType("forge/NetworkMod");
            }
            String id = in.replace('/', '.');
            if (bukkit) {
                String obf = classObfsBukkit.get(id);
                if (obf != null) {
                    return Type.getObjectType(obf.replace('.', '/'));
                }
                return Type.getObjectType("net/minecraft/server/" + in.substring(in.lastIndexOf(47) + 1));
            }
            String obf = classObfsR.get(id);
            if (obf == null) {
                LOG.info("Missing mapping: class " + id);
                return type;
            }
            if (CPMLoadingPlugin.deobf) {
                return type;
            }
            return Type.getObjectType(obf);
        }
        return type;
    }

    private static String obfObj(String in) {
        return CPMTransformerService.obfType(Type.getObjectType(in)).getInternalName();
    }

    private static String obfMethodDesc(String descIn) {
        Type t = Type.getMethodType(descIn);
        Type[] args = t.getArgumentTypes();
        Type ret = t.getReturnType();
        ret = CPMTransformerService.obfType(ret);
        for (int i = 0; i < args.length; ++i) {
            args[i] = CPMTransformerService.obfType(args[i]);
        }
        if (CPMLoadingPlugin.deobf) {
            return descIn;
        }
        return Type.getMethodDescriptor(ret, args);
    }

    private static Pair<String, String> lookupMethod(String fullDesc) {
        if (!methodObfs.containsKey(fullDesc)) {
            LOG.info("Missing mapping: method " + fullDesc);
        }
        if (CPMLoadingPlugin.deobf || fullDesc.contains(";cpm$")) {
            String nameDesc = fullDesc.split(";", 2)[1];
            int ind = nameDesc.indexOf(40);
            String mth = nameDesc.substring(0, ind);
            String par = nameDesc.substring(ind).replace('.', '/');
            return Pair.of(mth, par);
        }
        Pair<String, String> p = methodObfs.get(fullDesc);
        if (p.getKey().startsWith("!")) {
            return Pair.of(p.getKey().substring(1), CPMTransformerService.obfMethodDesc(p.getValue()));
        }
        return p;
    }

    private static String lookupField(String fullDesc) {
        if (!fieldObfs.containsKey(fullDesc)) {
            LOG.warn("Missing mapping: field " + fullDesc);
        }
        if (CPMLoadingPlugin.deobf) {
            return fullDesc.split(";")[1];
        }
        String d = fieldObfs.get(fullDesc);
        return d.substring(d.lastIndexOf(47) + 1);
    }

    public static byte[] transform(String name, String transformedName, byte[] basicClass) {
        boolean remap;
        if (transformers == null) {
            return basicClass;
        }
        UnaryOperator<ClassNode> tr = transformers.get(transformedName);
        List<String> ats = fieldATs.get(name);
        boolean bl = remap = !CPMLoadingPlugin.deobf && (name.startsWith("com.tom.cpm") || name.equals("mod_CPM")) && !name.startsWith("com.tom.cpm.shared") && !name.startsWith("com.tom.cpm.externals") && !name.startsWith("com.tom.cpm.api");
        if (tr != null || ats != null || remap) {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept(classNode, 8);
            LOG.info("Applying cpm transformer: " + transformedName);
            if (tr != null) {
                classNode = (ClassNode)tr.apply(classNode);
            }
            if (ats != null) {
                for (FieldNode f : classNode.fields) {
                    if (!ats.contains(f.name)) continue;
                    f.access &= 0xFFFFFFE8;
                    f.access |= 1;
                }
                LOG.info("Applied " + ats.size() + " field ATs");
            }
            if (remap) {
                ClassNode cn = new ClassNode();
                classNode.accept(new RemappingClassAdapter(cn, new DistRemapper(classNode)));
                classNode = cn;
                LOG.info("Applied sided mappings");
            }
            ClassWriter writer = new ClassWriter(0);
            classNode.accept(writer);
            if (dump) {
                File d = new File("asm/dump");
                d.mkdirs();
                File o = new File(d, name + ".class");
                try {
                    FileOutputStream f = new FileOutputStream(o);
                    Throwable throwable = null;
                    try {
                        f.write(writer.toByteArray());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (f != null) {
                            if (throwable != null) {
                                try {
                                    f.close();
                                }
                                catch (Throwable throwable3) {
                                }
                            } else {
                                f.close();
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return writer.toByteArray();
        }
        return basicClass;
    }

    public static byte[] transform(String var1, byte[] var2) {
        String d = classObfs.getOrDefault(var1, var1);
        return CPMTransformerService.transform(var1, d, var2);
    }

    static /* synthetic */ List lambda$init$1(String __) {
        return new ArrayList();
    }

    static /* synthetic */ Set lambda$init$0(String __) {
        return new HashSet();
    }

    static {
        classObfs = new HashMap<String, String>();
        classObfsR = new HashMap<String, String>();
        overrides = new HashMap<String, Set<String>>();
        spc = System.getProperty("cpmcore.spc", "false").equalsIgnoreCase("true");
        dump = System.getProperty("cpmcore.asm_dump", "false").equalsIgnoreCase("true");
        isClient = System.getProperty("cpmcore.env.client", "false").equalsIgnoreCase("true");
    }

    public static class DistRemapper
    extends Remapper {
        private ClassNode classNode;
        private Set<String> fs = new HashSet<String>();
        private Set<String> ms = new HashSet<String>();
        private boolean sm;
        private Set<String> override;

        public DistRemapper(ClassNode classNode) {
            this.classNode = classNode;
            for (Object f : classNode.fields) {
                this.fs.add(((FieldNode)f).name);
            }
            for (Object f : classNode.methods) {
                this.ms.add(((MethodNode)f).name);
            }
            this.sm = classNode.superName.startsWith("net/minecraft");
            this.override = overrides.getOrDefault(classNode.name, Collections.emptySet());
        }

        @Override
        public String map(String var1) {
            return CPMTransformerService.obfObj(var1);
        }

        @Override
        public String mapFieldName(String owner, String name, String desc) {
            if (name.startsWith("cpm$")) {
                return name;
            }
            if (owner.startsWith("net/minecraft")) {
                return CPMTransformerService.lookupField(owner.substring(owner.lastIndexOf(47) + 1) + ";" + name);
            }
            if (!this.fs.contains(name) && owner.equals(this.classNode.name) && this.sm) {
                return CPMTransformerService.lookupField(this.classNode.superName.substring(this.classNode.superName.lastIndexOf(47) + 1) + ";" + name);
            }
            return name;
        }

        @Override
        public String mapMethodName(String owner, String name, String desc) {
            if (name.startsWith("cpm$")) {
                return name;
            }
            if (name.equals("<init>") || name.equals("<clinit>")) {
                return name;
            }
            if (owner.startsWith("net/minecraft")) {
                return (String)CPMTransformerService.lookupMethod(owner.substring(owner.lastIndexOf(47) + 1) + ";" + name + desc).getKey();
            }
            if ((!this.ms.contains(name) || this.override.contains(name + desc)) && owner.equals(this.classNode.name) && this.sm) {
                return (String)CPMTransformerService.lookupMethod(this.classNode.superName.substring(this.classNode.superName.lastIndexOf(47) + 1) + ";" + name + desc).getKey();
            }
            return name;
        }
    }
}

