/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmcore;

import com.tom.cpm.externals.org.objectweb.asm.ClassReader;
import com.tom.cpm.externals.org.objectweb.asm.commons.Remapper;
import com.tom.cpm.externals.org.objectweb.asm.commons.RemappingClassAdapter;
import com.tom.cpm.externals.org.objectweb.asm.tree.ClassNode;
import com.tom.cpm.externals.org.objectweb.asm.tree.FieldNode;
import com.tom.cpm.externals.org.objectweb.asm.tree.MethodNode;
import com.tom.cpmcore.CPMTransformerService;
import com.tom.cpmcore.MappingDump$$Lambda$1;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class MappingDump {
    private Map<String, ClassNode> classNodes = new HashMap<String, ClassNode>();
    private Set<String> clzs = new HashSet<String>();
    private Set<String> fields = new HashSet<String>();
    private Set<String> methods = new HashSet<String>();
    private PrintWriter w;
    private boolean applyTransform;

    public void run(File zip, File dest, boolean verify) throws IOException {
        byte[] buffer = new byte[1024];
        this.applyTransform = verify;
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zip));
        Throwable throwable = null;
        try {
            PrintWriter w = new PrintWriter(dest);
            Throwable throwable2 = null;
            try {
                this.w = w;
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    String name = ze.getName();
                    if (!(ze.isDirectory() || !name.startsWith("com/tom/cpm") || name.startsWith("com/tom/cpm/shared") || name.startsWith("com/tom/cpm/externals") || name.startsWith("com.tom.cpl") || name.startsWith("com/tom/cpm/api") || !name.endsWith(".class"))) {
                        int len;
                        ByteArrayOutputStream fos = new ByteArrayOutputStream();
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        System.out.println("Class: " + name);
                        if (verify) {
                            if (name.startsWith("com/tom/cpm/client")) continue;
                            w.println("Class: " + name);
                            byte[] dt = fos.toByteArray();
                            try {
                                dt = CPMTransformerService.transform(name.substring(0, name.length() - 6).replace('/', '.'), dt);
                            }
                            catch (Throwable e) {
                                w.println("Class: " + name);
                                e.printStackTrace(w);
                                w.println();
                            }
                            ClassNode classNode = new ClassNode();
                            ClassReader classReader = new ClassReader(dt);
                            classReader.accept(classNode, 8);
                            this.classNodes.put(name.substring(0, name.length() - 6), classNode);
                            ClassNode cn = new ClassNode();
                            classNode.accept(new RemappingClassAdapter(cn, new Finder()));
                            w.println();
                        } else {
                            ClassNode classNode = new ClassNode();
                            ClassReader classReader = new ClassReader(fos.toByteArray());
                            classReader.accept(classNode, 8);
                            ClassNode cn = new ClassNode();
                            classNode.accept(new RemappingClassAdapter(cn, new Dumper(classNode)));
                        }
                    }
                    ze = zis.getNextEntry();
                }
                zis.closeEntry();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (w != null) {
                    if (throwable2 != null) {
                        try {
                            w.close();
                        }
                        catch (Throwable throwable4) {
                        }
                    } else {
                        w.close();
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            if (zis != null) {
                if (throwable != null) {
                    try {
                        zis.close();
                    }
                    catch (Throwable throwable6) {
                    }
                } else {
                    zis.close();
                }
            }
        }
    }

    private void mapObj(String owner) {
        this.mapType("L" + owner + ";");
    }

    public ClassNode getClassNode(String clazz) {
        if (clazz.startsWith("java")) {
            return null;
        }
        return this.classNodes.computeIfAbsent(clazz, MappingDump$$Lambda$1.lambdaFactory$(this));
    }

    private void mapType(String desc) {
        if (desc.startsWith("Lnet/minecraft") && this.clzs.add(desc)) {
            this.w.println("class " + desc.substring(1, desc.length() - 1).replace('/', '.'));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ ClassNode lambda$getClassNode$0(MappingDump this_, String n) {
        System.out.println("Loading class: " + n);
        InputStream is = MappingDump.class.getResourceAsStream("/" + n + ".class");
        if (is == null) {
            System.out.println("\tNot Found");
            return null;
        }
        byte[] buffer = new byte[1024];
        try {
            InputStream s = is;
            Throwable throwable = null;
            try {
                int len;
                ByteArrayOutputStream fos = new ByteArrayOutputStream();
                while ((len = s.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                byte[] cl = fos.toByteArray();
                if (this_.applyTransform) {
                    cl = CPMTransformerService.transform(n, cl);
                }
                ClassNode classNode2 = new ClassNode();
                ClassReader classReader = new ClassReader(cl);
                classReader.accept(classNode2, 8);
                ClassNode classNode = classNode2;
                return classNode;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (s != null) {
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                        }
                    } else {
                        s.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public class Dumper
    extends Remapper {
        private ClassNode classNode;
        private Set<String> fs = new HashSet<String>();
        private Set<String> ms = new HashSet<String>();
        private boolean sm;

        public Dumper(ClassNode classNode) {
            this.classNode = classNode;
            for (Object f : classNode.fields) {
                this.fs.add(((FieldNode)f).name);
            }
            for (Object f : classNode.methods) {
                this.ms.add(((MethodNode)f).name);
            }
            this.sm = classNode.superName.startsWith("net/minecraft");
        }

        @Override
        public String map(String var1) {
            MappingDump.this.mapObj(var1);
            return var1;
        }

        @Override
        public String mapFieldName(String owner, String name, String desc) {
            if (owner.startsWith("net/minecraft")) {
                String key = owner.substring(owner.lastIndexOf(47) + 1) + ";" + name;
                if (MappingDump.this.fields.add(key)) {
                    MappingDump.this.w.println("field " + key);
                }
            } else if (!this.fs.contains(name) && owner.equals(this.classNode.name) && this.sm) {
                String key = this.classNode.superName.substring(this.classNode.superName.lastIndexOf(47) + 1) + ";" + name;
                if (MappingDump.this.fields.add(key)) {
                    MappingDump.this.w.println("field " + key);
                }
            }
            return name;
        }

        @Override
        public String mapMethodName(String owner, String name, String desc) {
            String key;
            if (name.equals("<init>") || name.equals("<clinit>")) {
                return name;
            }
            if (owner.startsWith("net/minecraft")) {
                key = owner.substring(owner.lastIndexOf(47) + 1) + ";" + name + desc;
                if (MappingDump.this.methods.add(key)) {
                    MappingDump.this.w.println("method " + key);
                }
            }
            if (owner.equals(this.classNode.name) && this.sm) {
                key = this.classNode.superName.substring(this.classNode.superName.lastIndexOf(47) + 1) + ";" + name + desc;
                if (this.ms.contains(name)) {
                    System.out.println("Scanning for overrides: " + name);
                    ClassNode sup = this.classNode;
                    boolean found = false;
                    while ((sup = MappingDump.this.getClassNode(sup.superName)) != null) {
                        for (MethodNode mn : sup.methods) {
                            if (!mn.name.equals(name) || !mn.desc.equals(desc)) continue;
                            found = true;
                            MappingDump.this.w.println("override " + owner + " " + name + desc);
                            break;
                        }
                        if (!found) continue;
                    }
                    if (!found) {
                        return name;
                    }
                }
                if (MappingDump.this.methods.add(key)) {
                    MappingDump.this.w.println("method " + key);
                }
            }
            return name;
        }
    }

    public class Finder
    extends Remapper {
        @Override
        public String map(String var1) {
            if (!var1.startsWith("java") && MappingDump.this.getClassNode(var1) == null) {
                MappingDump.this.w.println("Class not found: " + var1);
            }
            return var1;
        }

        @Override
        public String mapFieldName(String owner, String name, String desc) {
            if (owner.startsWith("java")) {
                return name;
            }
            ClassNode sup = MappingDump.this.getClassNode(owner);
            boolean found = false;
            while (sup != null) {
                for (FieldNode f : sup.fields) {
                    if (!f.name.equals(name)) continue;
                    if (!f.desc.equals(desc)) {
                        MappingDump.this.w.println("Found field with desc mismatch: " + sup.name + "." + f.name + " " + f.desc + " expected: " + owner + "." + name + " " + desc);
                    }
                    found = true;
                }
                sup = MappingDump.this.getClassNode(sup.superName);
            }
            if (!found) {
                MappingDump.this.w.println("Field not found: " + owner + "." + name);
            }
            return name;
        }

        @Override
        public String mapMethodName(String owner, String name, String desc) {
            if (owner.startsWith("java")) {
                return name;
            }
            ClassNode sup = MappingDump.this.getClassNode(owner);
            boolean found = false;
            while (sup != null) {
                for (MethodNode f : sup.methods) {
                    if (!f.name.equals(name) || !f.desc.equals(desc)) continue;
                    found = true;
                }
                sup = MappingDump.this.getClassNode(sup.superName);
            }
            if (!found) {
                MappingDump.this.w.println("Method not found: " + owner + "." + name + desc);
            }
            return name;
        }
    }
}

