/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.block.Biome;
import com.tom.cpl.block.BlockState;
import com.tom.cpl.block.World;
import com.tom.cpl.util.WeakStorage;
import com.tom.cpm.common.BiomeHandlerImpl;
import com.tom.cpm.common.BlockStateHandlerImpl;
import com.tom.cpm.shared.animation.AnimationState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public class WorldImpl
implements World {
    public WeakStorage<Level> level = new WeakStorage();
    public BlockPos base;

    public static void setWorld(AnimationState a, Entity ent) {
        if (!(a.world instanceof WorldImpl)) {
            a.world = new WorldImpl();
        }
        WorldImpl i = (WorldImpl)a.world;
        Level l = ent.level();
        i.level.set(l);
        i.base = ent.blockPosition();
        a.dayTime = l.dayTime();
        a.skyLight = l.getBrightness(LightLayer.SKY, i.base);
        a.blockLight = l.getBrightness(LightLayer.BLOCK, i.base);
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return this.level.call(l -> BlockStateHandlerImpl.impl.wrap(l.getBlockState(this.base.offset(x, y, z))), BlockState.AIR);
    }

    @Override
    public boolean isCovered() {
        return this.level.call(l -> l.canSeeSky(this.base), false);
    }

    @Override
    public int getYHeight() {
        return this.base.getY();
    }

    @Override
    public int getMaxHeight() {
        return this.level.call(l -> l.getMaxBuildHeight(), 0);
    }

    @Override
    public int getMinHeight() {
        return this.level.call(l -> l.getMinBuildHeight(), 0);
    }

    @Override
    public World.WeatherType getWeather() {
        return this.level.call(l -> l.isThundering() ? World.WeatherType.THUNDER : (l.isRaining() ? World.WeatherType.RAIN : World.WeatherType.CLEAR), World.WeatherType.CLEAR);
    }

    @Override
    public Biome getBiome() {
        return this.level.call(l -> BiomeHandlerImpl.getImpl(l).wrap(new BiomeInfo((Holder<net.minecraft.world.level.biome.Biome>)l.getBiome(this.base), this.base)), null);
    }

    @Override
    public String getDimension() {
        return this.level.call(l -> l.dimension().location().toString(), null);
    }

    public record BiomeInfo(Holder<net.minecraft.world.level.biome.Biome> biome, BlockPos at) {
        public net.minecraft.world.level.biome.Biome value() {
            return (net.minecraft.world.level.biome.Biome)this.biome.value();
        }
    }
}

