/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.tag.TagManager;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.util.ErrorLog;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class CPMTagLoader
extends SimplePreparableReloadListener<Map<String, List<Map<String, Object>>>> {
    private final TagManager<?> tags;
    private final String prefix;

    public CPMTagLoader(Minecraft mc, TagManager<?> tags, String prefix) {
        this.tags = tags;
        this.prefix = prefix;
        ResourceManager mngr = mc.getResourceManager();
        if (mngr != null) {
            this.init(mngr);
        } else {
            mc.schedule(() -> this.init(mc.getResourceManager()));
        }
    }

    private void init(ResourceManager mngr) {
        this.tags.applyBuiltin(this.load(mngr), this.prefix);
        if (mngr instanceof ReloadableResourceManager) {
            ReloadableResourceManager r = (ReloadableResourceManager)mngr;
            r.registerReloadListener((PreparableReloadListener)this);
        }
    }

    protected Map<String, List<Map<String, Object>>> prepare(ResourceManager mngr, ProfilerFiller profiler) {
        return this.load(mngr);
    }

    protected void apply(Map<String, List<Map<String, Object>>> tagMap, ResourceManager mngr, ProfilerFiller profiler) {
        this.tags.applyBuiltin(tagMap, this.prefix);
    }

    private Map<String, List<Map<String, Object>>> load(ResourceManager mngr) {
        HashMap<String, List<Map<String, Object>>> el = new HashMap<String, List<Map<String, Object>>>();
        mngr.listResourceStacks("cpm_tags/" + this.prefix, l -> l.getPath().endsWith(".json")).forEach((rl, rs) -> {
            ArrayList res = new ArrayList();
            el.put(rl.getNamespace() + ":" + rl.getPath().substring(9, rl.getPath().length() - 5), res);
            rs.forEach(r -> {
                try (BufferedReader rd = r.openAsReader();){
                    Map tag = (Map)MinecraftObjectHolder.gson.fromJson((Reader)rd, Object.class);
                    res.add(tag);
                }
                catch (Exception e) {
                    ErrorLog.addLog(ErrorLog.LogLevel.WARNING, "Failed to load cpm builtin tag: " + String.valueOf(rl), e);
                }
            });
        });
        return el;
    }
}

