/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.tom.cpm.CustomPlayerModels;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.ModelTexture;
import com.tom.cpm.client.Platform;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.common.ByteArrayPayload;
import com.tom.cpm.common.PlayerAnimUpdater;
import com.tom.cpm.mixinplugin.IrisDetector;
import com.tom.cpm.mixinplugin.OFDetector;
import com.tom.cpm.shared.model.RenderManager;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.Log;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public abstract class ClientBase {
    public static final ResourceLocation DEFAULT_CAPE = ResourceLocation.parse((String)"cpm:textures/template/cape.png");
    public static boolean optifineLoaded;
    public static boolean irisLoaded;
    public static boolean vrLoaded;
    public static MinecraftObject mc;
    protected Minecraft minecraft;
    public RenderManager<GameProfile, Player, Model, MultiBufferSource> manager;
    public NetHandler<CustomPacketPayload.Type<ByteArrayPayload>, Player, ClientPacketListener> netHandler;

    public void init0() {
        this.minecraft = Minecraft.getInstance();
        mc = new MinecraftObject(this.minecraft);
        optifineLoaded = OFDetector.doApply();
        vrLoaded = Platform.isModLoaded("vivecraft");
        irisLoaded = IrisDetector.doApply();
        if (optifineLoaded) {
            Log.info("Optifine detected, enabling optifine compatibility");
        }
        if (vrLoaded) {
            Log.info("ViveCraft detected, enabling ViveCraft compatibility");
        }
        if (irisLoaded) {
            Log.info("Iris detected, enabling iris compatibility");
        }
    }

    public void init1() {
        this.manager = new RenderManager<GameProfile, Player, Model, MultiBufferSource>(mc.getPlayerRenderManager(), mc.getDefinitionLoader(), PlayerProfile::getPlayerProfile);
        this.manager.setGPGetters(GameProfile::getProperties, Property::value);
        this.netHandler = new NetHandler((k, v) -> new CustomPacketPayload.Type(ResourceLocation.tryBuild((String)k, (String)v)));
        this.netHandler.setExecutor(() -> this.minecraft);
        this.netHandler.setSendPacketClient(Function.identity(), (c, rl, pb) -> c.send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new ByteArrayPayload((CustomPacketPayload.Type<ByteArrayPayload>)rl, (byte[])pb))));
        this.netHandler.setPlayerToLoader(Player::getGameProfile);
        this.netHandler.setGetPlayerById(id -> {
            Entity ent = Minecraft.getInstance().level.getEntity(id);
            if (ent instanceof Player) {
                return (Player)ent;
            }
            return null;
        });
        this.netHandler.setGetClient(() -> this.minecraft.player);
        this.netHandler.setGetNet(c -> ((LocalPlayer)c).connection);
        this.netHandler.setDisplayText(t -> this.minecraft.player.displayClientMessage((Component)t.remap(), false));
        this.netHandler.setGetPlayerAnimGetters(new PlayerAnimUpdater());
    }

    public static void apiInit() {
        CustomPlayerModels.api.buildClient().voicePlayer(Player.class, Entity::getUUID).renderApi(Model.class, ResourceLocation.class, RenderType.class, MultiBufferSource.class, GameProfile.class, ModelTexture::new).localModelApi(GameProfile::new).init();
    }

    public void playerRenderPost(MultiBufferSource buffer, PlayerModel model) {
        this.manager.unbindClear((Model)model);
    }

    public void renderHand(MultiBufferSource buffer, PlayerModel model) {
        this.renderHand((AbstractClientPlayer)this.minecraft.player, buffer, model);
    }

    public void renderHand(AbstractClientPlayer pl, MultiBufferSource buffer, PlayerModel model) {
        this.manager.bindHand((Player)pl, buffer, (Model)model);
    }

    public void renderHandPost(MultiBufferSource buffer, HumanoidModel model) {
        this.manager.unbindClear((Model)model);
    }

    public void renderSkull(Model skullModel, GameProfile profile, MultiBufferSource buffer) {
        this.manager.bindSkull(profile, buffer, skullModel);
    }

    public void renderSkullPost(MultiBufferSource buffer, Model model) {
        this.manager.unbindFlush(model);
    }

    public void renderElytra(HumanoidModel<HumanoidRenderState> player, ElytraModel model) {
        this.manager.bindElytra((Model)player, (Model)model);
    }

    public void renderArmor(HumanoidModel<HumanoidRenderState> modelArmor, HumanoidModel<HumanoidRenderState> modelLeggings, HumanoidModel<HumanoidRenderState> player) {
        this.manager.bindArmor((Model)player, (Model)modelArmor, 1);
        this.manager.bindArmor((Model)player, (Model)modelLeggings, 2);
    }

    public void updateJump() {
        if (this.minecraft.player.onGround() && this.minecraft.player.input.keyPresses.jump()) {
            this.manager.jump((Player)this.minecraft.player);
        }
    }
}

