/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tom.cpl.text.FormatText;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.client.LivingRendererAccess;
import com.tom.cpm.client.ModelTexture;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.client.PlayerRenderStateAccess;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.model.TextureSheetType;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerRenderer.class}, priority=900)
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerRenderState, PlayerModel>
implements LivingRendererAccess {
    @Unique
    private static final ResourceLocation CPM$EMPTY_TEX = ResourceLocation.parse((String)"cpm:textures/template/empty.png");

    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel entityModel, float f) {
        super(context, (EntityModel)entityModel, f);
    }

    @Inject(at={@At(value="RETURN")}, method={"getTextureLocation(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;)Lnet/minecraft/resources/ResourceLocation;"}, cancellable=true)
    public void onGetEntityTexture(PlayerRenderState entity, CallbackInfoReturnable<ResourceLocation> cbi) {
        CustomPlayerModelsClient.mc.getPlayerRenderManager().bindSkin(this.getModel(), new ModelTexture(cbi), TextureSheetType.SKIN);
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;entityTranslucent(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/RenderType;"), method={"renderHand"})
    public ResourceLocation getSkinTex(ResourceLocation arg) {
        ModelTexture tex = new ModelTexture(arg);
        CustomPlayerModelsClient.mc.getPlayerRenderManager().bindSkin(this.getModel(), tex, TextureSheetType.SKIN);
        return tex.getTexture();
    }

    @Inject(at={@At(value="HEAD")}, method={"renderRightHand"})
    public void onRenderRightArmPre(PoseStack poseStack, MultiBufferSource vertexConsumers, int i, ResourceLocation resourceLocation, boolean sleeve, CallbackInfo cbi) {
        CustomPlayerModelsClient.INSTANCE.renderHand(vertexConsumers, (PlayerModel)this.getModel());
    }

    @Inject(at={@At(value="HEAD")}, method={"renderLeftHand"})
    public void onRenderLeftArmPre(PoseStack poseStack, MultiBufferSource vertexConsumers, int i, ResourceLocation resourceLocation, boolean sleeve, CallbackInfo cbi) {
        CustomPlayerModelsClient.INSTANCE.renderHand(vertexConsumers, (PlayerModel)this.getModel());
    }

    @Inject(at={@At(value="RETURN")}, method={"renderRightHand"})
    public void onRenderRightArmPost(PoseStack poseStack, MultiBufferSource vertexConsumers, int i, ResourceLocation resourceLocation, boolean sleeve, CallbackInfo cbi) {
        CustomPlayerModelsClient.INSTANCE.renderHandPost(vertexConsumers, (HumanoidModel)this.getModel());
    }

    @Inject(at={@At(value="RETURN")}, method={"renderLeftHand"})
    public void onRenderLeftArmPost(PoseStack poseStack, MultiBufferSource vertexConsumers, int i, ResourceLocation resourceLocation, boolean sleeve, CallbackInfo cbi) {
        CustomPlayerModelsClient.INSTANCE.renderHandPost(vertexConsumers, (HumanoidModel)this.getModel());
    }

    @Inject(at={@At(value="HEAD")}, method={"renderNameTag"}, cancellable=true)
    public void onRenderName1(PlayerRenderState playerRenderState, Component component, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLightIn, CallbackInfo cbi) {
        PlayerRenderStateAccess sa;
        if (!Player.isEnableNames()) {
            cbi.cancel();
            return;
        }
        if (Player.isEnableLoadingInfo() && (sa = (PlayerRenderStateAccess)playerRenderState).cpm$getModelStatus() != null) {
            poseStack.pushPose();
            poseStack.translate(0.0, (double)1.3f, 0.0);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            super.renderNameTag((EntityRenderState)playerRenderState, sa.cpm$getModelStatus(), poseStack, multiBufferSource, packedLightIn);
            poseStack.popPose();
        }
    }

    @Override
    public void cpm$onGetRenderType(LivingEntityRenderState player, boolean pTranslucent, boolean pGlowing, CallbackInfoReturnable<RenderType> cbi) {
        if (CustomPlayerModelsClient.mc.getPlayerRenderManager().isBound(this.getModel())) {
            boolean r = CustomPlayerModelsClient.mc.getPlayerRenderManager().getHolderSafe(this.getModel(), null, h -> h.setInvisState(), false, false);
            if (pTranslucent) {
                return;
            }
            if (!pGlowing && !r) {
                return;
            }
            ResourceLocation tex = this.getTextureLocation((LivingEntityRenderState)((PlayerRenderState)player));
            CustomPlayerModelsClient.mc.getPlayerRenderManager().getHolderSafe(this.getModel(), null, h -> h.setInvis(pGlowing), false);
            cbi.setReturnValue((Object)(pGlowing ? RenderType.outline((ResourceLocation)tex) : RenderType.entityCutout((ResourceLocation)CPM$EMPTY_TEX)));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"extractRenderState"})
    public void onExtractRenderState(AbstractClientPlayer abstractClientPlayer, PlayerRenderState playerRenderState, float f, CallbackInfo cbi) {
        PlayerRenderStateAccess sa = (PlayerRenderStateAccess)playerRenderState;
        FormatText st = CustomPlayerModelsClient.INSTANCE.manager.getStatus(abstractClientPlayer.getGameProfile(), "player");
        sa.cpm$setModelStatus(st != null ? (Component)st.remap() : null);
        Player<AbstractClientPlayer> pl = CustomPlayerModelsClient.INSTANCE.manager.loadPlayerState(abstractClientPlayer.getGameProfile(), abstractClientPlayer, "player", AnimationEngine.AnimationMode.PLAYER);
        sa.cpm$setPlayer(pl);
        if (pl != null) {
            ((PlayerProfile)pl).updateFromState((PlayerModel)this.getModel(), playerRenderState);
        }
    }
}

