/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.tag.TagManager;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.util.ErrorLog;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;

public class CPMTagLoader
extends ReloadListener<Map<String, List<Map<String, Object>>>> {
    private final TagManager<?> tags;
    private final String prefix;

    public CPMTagLoader(Minecraft mc, TagManager<?> tags, String prefix) {
        this.tags = tags;
        this.prefix = prefix;
        IResourceManager mngr = mc.func_195551_G();
        if (mngr != null) {
            this.init(mngr);
        } else {
            mc.func_212871_a_(() -> this.init(mc.func_195551_G()));
        }
    }

    private void init(IResourceManager mngr) {
        this.tags.applyBuiltin(this.load(mngr), this.prefix);
        if (mngr instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)mngr).func_219534_a((IFutureReloadListener)this);
        }
    }

    protected Map<String, List<Map<String, Object>>> prepare(IResourceManager mngr, IProfiler profiler) {
        return this.load(mngr);
    }

    protected void apply(Map<String, List<Map<String, Object>>> tagMap, IResourceManager mngr, IProfiler profiler) {
        this.tags.applyBuiltin(tagMap, this.prefix);
    }

    private Map<String, List<Map<String, Object>>> load(IResourceManager mngr) {
        HashMap<String, List<Map<String, Object>>> el = new HashMap<String, List<Map<String, Object>>>();
        mngr.func_199003_a("cpm_tags/" + this.prefix, l -> l.endsWith(".json")).forEach(rl -> {
            ArrayList<Map> res = new ArrayList<Map>();
            el.put(rl.func_110624_b() + ":" + rl.func_110623_a().substring(9, rl.func_110623_a().length() - 5), res);
            try {
                Iterator iterator = mngr.func_199004_b(rl).iterator();
                while (iterator.hasNext()) {
                    IResource r;
                    IResource iresource = r = (IResource)iterator.next();
                    Throwable throwable = null;
                    try {
                        InputStream inputstream = iresource.func_199027_b();
                        Throwable throwable2 = null;
                        try {
                            BufferedReader rd = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                            Throwable throwable3 = null;
                            try {
                                Map tag = (Map)MinecraftObjectHolder.gson.fromJson((Reader)rd, Object.class);
                                res.add(tag);
                            }
                            catch (Throwable throwable4) {
                                throwable3 = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (rd == null) continue;
                                if (throwable3 != null) {
                                    try {
                                        ((Reader)rd).close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable3.addSuppressed(throwable5);
                                    }
                                    continue;
                                }
                                ((Reader)rd).close();
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable2 = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (inputstream == null) continue;
                            if (throwable2 != null) {
                                try {
                                    inputstream.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable2.addSuppressed(throwable7);
                                }
                                continue;
                            }
                            inputstream.close();
                        }
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (iresource == null) continue;
                        if (throwable != null) {
                            try {
                                iresource.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                            continue;
                        }
                        iresource.close();
                    }
                }
            }
            catch (Exception e) {
                ErrorLog.addLog(ErrorLog.LogLevel.WARNING, "Failed to load cpm builtin tag: " + rl, e);
            }
        });
        return el;
    }
}

