/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.gui.IKeybind;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpm.client.GuiImpl;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class KeyBindings
implements IKeybind {
    private static KeyConflictCtx conflictCtx = new KeyConflictCtx();
    public static KeyBinding gestureMenuBinding;
    public static KeyBinding renderToggleBinding;
    public static IKeybind[] quickAccess;
    public static List<IKeybind> kbs;
    private final KeyBinding kb;
    private final String name;

    public static void init() {
        gestureMenuBinding = new KeyBinding("key.cpm.gestureMenu", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM.func_197944_a(71), "key.cpm.category");
        renderToggleBinding = new KeyBinding("key.cpm.renderToggle", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.field_197958_a, "key.cpm.category");
        kbs.add(new KeyBindings(gestureMenuBinding, "gestureMenu"));
        kbs.add(new KeyBindings(renderToggleBinding, "renderToggle"));
        for (int i = 1; i <= 16; ++i) {
            KeyBindings.createQA(i);
        }
    }

    private static void createQA(int id) {
        KeyBinding kb = new KeyBinding("key.cpm.qa_" + id, (IKeyConflictContext)conflictCtx, InputMappings.field_197958_a, "key.cpm.category");
        KeyBindings kbs = new KeyBindings(kb, "qa_" + id);
        KeyBindings.kbs.add(kbs);
        KeyBindings.quickAccess[id - 1] = kbs;
    }

    private KeyBindings(KeyBinding kb, String name) {
        this.kb = kb;
        this.name = name;
        ClientRegistry.registerKeyBinding((KeyBinding)kb);
    }

    @Override
    public boolean isPressed(KeyboardEvent evt) {
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)evt.keyCode, (int)evt.scancode);
        return this.kb.isActiveAndMatches(mouseKey);
    }

    @Override
    public String getBoundKey() {
        return this.kb.func_197978_k();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isPressed() {
        return this.kb.func_151470_d();
    }

    static {
        quickAccess = new IKeybind[16];
        kbs = new ArrayList<IKeybind>();
    }

    private static class KeyConflictCtx
    implements IKeyConflictContext {
        private KeyConflictCtx() {
        }

        public boolean isActive() {
            Minecraft mc = Minecraft.func_71410_x();
            return mc.field_71462_r instanceof GuiImpl || !KeyConflictContext.GUI.isActive() && mc.field_71439_g != null;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return other == this || other == KeyConflictContext.IN_GAME;
        }
    }
}

