/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.render.RenderTypes;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.util.Image;
import com.tom.cpm.client.GuiImpl;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.VBuffer;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.Panel3d;
import com.tom.cpm.shared.model.render.RenderMode;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Panel3dImpl
extends Panel3d.Panel3dNative {
    private com.mojang.blaze3d.matrix.MatrixStack matrixstack;
    private Minecraft mc = Minecraft.func_71410_x();

    public Panel3dImpl(Panel3d panel) {
        super(panel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(float partialTicks) {
        ViewportCamera cam = this.panel.getCamera();
        float pitch = (float)Math.asin(cam.look.y);
        float yaw = cam.look.getYaw();
        Box bounds = this.getBounds();
        Vec2i off = this.panel.getGui().getOffset();
        float size = cam.camDist;
        RenderSystem.pushMatrix();
        try {
            RenderSystem.translatef((float)(off.x + bounds.w / 2), (float)(off.y + bounds.h / 2), (float)-50.0f);
            RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-0.1f);
            this.matrixstack = new com.mojang.blaze3d.matrix.MatrixStack();
            this.matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
            this.matrixstack.func_227862_a_(size, size, size);
            Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
            Quaternion quaternion1 = Vector3f.field_229179_b_.func_229193_c_(-pitch);
            quaternion.func_195890_a(quaternion1);
            this.matrixstack.func_227863_a_(quaternion);
            this.matrixstack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)((double)yaw + Math.PI)));
            this.matrixstack.func_227861_a_((double)(-cam.position.x), (double)(-cam.position.y), (double)(-cam.position.z));
            RenderSystem.enableDepthTest();
            IRenderTypeBuffer.Impl bufs = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            int light = LightTexture.func_228451_a_((int)15, (int)15);
            this.panel.render(new MatrixStack(), new VBuffers(rt -> new VBuffer(bufs.getBuffer((RenderType)rt.getNativeType()), light, OverlayTexture.field_229196_a_, this.matrixstack)), partialTicks);
            bufs.func_228461_a_();
        }
        finally {
            RenderSystem.disableDepthTest();
            RenderSystem.popMatrix();
            this.matrixstack = null;
        }
    }

    @Override
    public RenderTypes<RenderMode> getRenderTypes() {
        return this.getRenderTypes0(MinecraftObject.DynTexture.getBoundLoc());
    }

    @Override
    public RenderTypes<RenderMode> getRenderTypes(String texture) {
        return this.getRenderTypes0(new ResourceLocation("cpm", "textures/gui/" + texture + ".png"));
    }

    @Override
    public Image takeScreenshot(Vec2i size) {
        GuiImpl gui = (GuiImpl)this.panel.getGui().getNativeGui();
        int dw = this.mc.func_228018_at_().func_198109_k();
        int dh = this.mc.func_228018_at_().func_198091_l();
        float multiplierX = (float)dw / (float)gui.width;
        float multiplierY = (float)dh / (float)gui.height;
        int width = (int)(multiplierX * (float)size.x);
        int height = (int)(multiplierY * (float)size.y);
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)(width * height * 3));
        GL11.glReadPixels((int)((int)(multiplierX * (float)this.renderPos.x)), (int)(this.mc.func_228018_at_().func_198091_l() - height - (int)(multiplierY * (float)this.renderPos.y)), (int)width, (int)height, (int)6407, (int)5126, (FloatBuffer)buffer);
        Image img = new Image(width, height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float r = buffer.get((x + y * width) * 3);
                float g = buffer.get((x + y * width) * 3 + 1);
                float b = buffer.get((x + y * width) * 3 + 2);
                int color = 0xFF000000 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
                img.setRGB(x, height - y - 1, color);
            }
        }
        Image rImg = new Image(size.x, size.y);
        rImg.draw(img, 0, 0, size.x, size.y);
        return rImg;
    }

    @Override
    public Mat4f getView() {
        return Mat4f.map(2982, GL11::glGetFloatv, this.matrixstack.func_227866_c_().func_227870_a_(), Matrix4f::func_195879_b);
    }

    @Override
    public Mat4f getProjection() {
        return Mat4f.map(2983, GL11::glGetFloatv);
    }
}

