/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.cpl.block.entity.ActiveEffect;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.util.Hand;
import com.tom.cpl.util.HandAnimation;
import com.tom.cpm.client.Platform;
import com.tom.cpm.common.EntityTypeHandlerImpl;
import com.tom.cpm.common.PlayerInventory;
import com.tom.cpm.common.WorldImpl;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.render.PlayerModelSetup;
import com.tom.cpm.shared.skin.PlayerTextureLoader;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class PlayerProfile
extends Player<PlayerEntity> {
    public static boolean inGui;
    public static BooleanSupplier inFirstPerson;
    private final GameProfile profile;
    private String skinType;

    public static GameProfile getPlayerProfile(PlayerEntity player) {
        NetworkPlayerInfo info;
        ClientPlayNetHandler conn;
        if (player == null) {
            return null;
        }
        GameProfile profile = player.func_146103_bH();
        if (profile.getProperties().isEmpty() && (conn = Minecraft.func_71410_x().func_147114_u()) != null && (info = conn.func_175102_a(profile.getId())) != null) {
            profile = info.func_178845_a();
        }
        return profile;
    }

    public PlayerProfile(GameProfile profile) {
        this.profile = new GameProfile(profile.getId(), profile.getName());
        PlayerProfile.cloneProperties(profile.getProperties(), this.profile.getProperties());
        if (profile.getId() != null) {
            this.skinType = DefaultPlayerSkin.func_177332_b((UUID)profile.getId());
        }
    }

    @Override
    public SkinType getSkinType() {
        return SkinType.get(this.skinType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.profile == null ? 0 : this.profile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlayerProfile other = (PlayerProfile)obj;
        return !(this.profile == null ? other.profile != null : !this.profile.equals((Object)other.profile));
    }

    @Override
    public UUID getUUID() {
        return this.profile.getId();
    }

    @Override
    public void updateFromPlayer(PlayerEntity player) {
        float f1;
        float f;
        ItemStack is;
        Pose p = player.func_213283_Z();
        this.animState.resetPlayer();
        switch (p) {
            case FALL_FLYING: {
                this.animState.elytraFlying = true;
                break;
            }
            case SLEEPING: {
                this.animState.sleeping = true;
                break;
            }
            case SPIN_ATTACK: {
                this.animState.tridentSpin = true;
                break;
            }
        }
        this.animState.sneaking = player.func_213453_ef();
        this.animState.crawling = player.func_213300_bk();
        this.animState.swimming = player.func_213314_bj();
        if (!player.func_70089_S()) {
            this.animState.dying = true;
        }
        if (Platform.isSitting(player)) {
            this.animState.riding = true;
        }
        if (player.func_70051_ag()) {
            this.animState.sprinting = true;
        }
        if (player.func_184587_cr()) {
            this.animState.usingAnimation = HandAnimation.of(player.func_184607_cu().func_77975_n());
        }
        if (player.func_70090_H()) {
            this.animState.retroSwimming = true;
        }
        this.animState.moveAmountX = (float)(player.func_226277_ct_() - player.field_70169_q);
        this.animState.moveAmountY = (float)(player.func_226278_cu_() - player.field_70167_r);
        this.animState.moveAmountZ = (float)(player.func_226281_cx_() - player.field_70166_s);
        this.animState.yaw = player.field_70177_z;
        this.animState.pitch = player.field_70125_A;
        this.animState.bodyYaw = player.field_70761_aq;
        if (player.func_175148_a(PlayerModelPart.HAT)) {
            this.animState.encodedState |= 1;
        }
        if (player.func_175148_a(PlayerModelPart.JACKET)) {
            this.animState.encodedState |= 2;
        }
        if (player.func_175148_a(PlayerModelPart.LEFT_PANTS_LEG)) {
            this.animState.encodedState |= 4;
        }
        if (player.func_175148_a(PlayerModelPart.RIGHT_PANTS_LEG)) {
            this.animState.encodedState |= 8;
        }
        if (player.func_175148_a(PlayerModelPart.LEFT_SLEEVE)) {
            this.animState.encodedState |= 0x10;
        }
        if (player.func_175148_a(PlayerModelPart.RIGHT_SLEEVE)) {
            this.animState.encodedState |= 0x20;
        }
        this.animState.hasSkullOnHead = (is = player.func_184582_a(EquipmentSlotType.HEAD)).func_77973_b() instanceof BlockItem && ((BlockItem)is.func_77973_b()).func_179223_d() instanceof AbstractSkullBlock;
        this.animState.wearingHelm = !is.func_190926_b();
        is = player.func_184582_a(EquipmentSlotType.CHEST);
        this.animState.wearingElytra = is.func_77973_b() instanceof ElytraItem;
        this.animState.wearingBody = !is.func_190926_b();
        this.animState.wearingLegs = !player.func_184582_a(EquipmentSlotType.LEGS).func_190926_b();
        this.animState.wearingBoots = !player.func_184582_a(EquipmentSlotType.FEET).func_190926_b();
        this.animState.mainHand = Hand.of(player.func_184591_cq());
        this.animState.activeHand = Hand.of(this.animState.mainHand, player.func_184600_cs());
        this.animState.swingingHand = Hand.of(this.animState.mainHand, player.field_184622_au);
        this.animState.hurtTime = player.field_70737_aN;
        this.animState.isOnLadder = player.func_70617_f_();
        this.animState.isBurning = player.func_90999_ad();
        this.animState.inGui = inGui;
        this.animState.firstPersonMod = inFirstPerson.getAsBoolean();
        PlayerInventory.setInv(this.animState, player.field_71071_by);
        WorldImpl.setWorld(this.animState, (Entity)player);
        if (player.func_184187_bx() != null) {
            this.animState.vehicle = EntityTypeHandlerImpl.impl.wrap(player.func_184187_bx().func_200600_R());
        }
        player.func_70651_bq().forEach(e -> this.animState.allEffects.add(new ActiveEffect(Registry.field_212631_t.func_177774_c((Object)e.func_188419_a()).toString(), e.func_76458_c(), e.func_76459_b(), !e.func_188418_e())));
        if (player.func_184607_cu().func_77973_b() instanceof CrossbowItem) {
            f = CrossbowItem.func_220026_e((ItemStack)player.func_184607_cu());
            f1 = MathHelper.clamp((float)player.func_184612_cw(), 0.0f, f);
            this.animState.crossbowPullback = f1 / f;
        }
        if (player.func_184607_cu().func_77973_b() instanceof BowItem) {
            f = 20.0f;
            f1 = MathHelper.clamp((float)player.func_184612_cw(), 0.0f, f);
            this.animState.bowPullback = f1 / f;
        }
        this.animState.parrotLeft = !player.func_192023_dk().func_74779_i("id").isEmpty();
        this.animState.parrotRight = !player.func_192025_dl().func_74779_i("id").isEmpty();
    }

    @Override
    public void updateFromModel(Object model) {
        if (model instanceof PlayerModel) {
            PlayerModel m = (PlayerModel)model;
            this.animState.resetModel();
            this.animState.attackTime = m.field_217112_c;
            this.animState.swimAmount = m.field_205061_a;
            this.animState.leftArm = PlayerModelSetup.ArmPose.of(m.field_187075_l);
            this.animState.rightArm = PlayerModelSetup.ArmPose.of(m.field_187076_m);
        }
    }

    @Override
    protected PlayerTextureLoader initTextures() {
        return new PlayerTextureLoader(Minecraft.func_71410_x().func_152342_ad().field_152796_d){

            @Override
            protected CompletableFuture<Void> load0() {
                Map map = Minecraft.func_71410_x().func_152342_ad().func_152788_a(PlayerProfile.this.profile);
                this.defineAll(map, MinecraftProfileTexture::getUrl, MinecraftProfileTexture::getHash);
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    MinecraftProfileTexture tex = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
                    PlayerProfile.this.skinType = tex.getMetadata("model");
                    if (PlayerProfile.this.skinType == null) {
                        PlayerProfile.this.skinType = "default";
                    }
                    return CompletableFuture.completedFuture(null);
                }
                final CompletableFuture<Void> cf = new CompletableFuture<Void>();
                Minecraft.func_71410_x().func_152342_ad().func_152790_a(PlayerProfile.this.profile, new SkinManager.ISkinAvailableCallback(){

                    public void onSkinTextureAvailable(MinecraftProfileTexture.Type typeIn, ResourceLocation location, MinecraftProfileTexture profileTexture) {
                        this.defineTexture((Enum)typeIn, profileTexture.getUrl(), profileTexture.getHash());
                        switch (typeIn) {
                            case SKIN: {
                                PlayerProfile.this.skinType = profileTexture.getMetadata("model");
                                if (PlayerProfile.this.skinType == null) {
                                    PlayerProfile.this.skinType = "default";
                                }
                                RenderSystem.recordRenderCall(() -> cf.complete(null));
                                break;
                            }
                        }
                    }
                }, true);
                return cf;
            }
        };
    }

    @Override
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public Object getGameProfile() {
        return this.profile;
    }

    static {
        inFirstPerson = () -> false;
        Platform.initPlayerProfile();
    }
}

