/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.block.BlockState;
import com.tom.cpl.block.BlockStateHandler;
import com.tom.cpl.item.Stack;
import com.tom.cpm.common.ItemStackHandlerImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class BlockStateHandlerImpl
extends BlockStateHandler<net.minecraft.block.BlockState> {
    public static final BlockStateHandlerImpl impl = new BlockStateHandlerImpl();

    @Override
    public String getBlockId(net.minecraft.block.BlockState stack) {
        return Registry.field_212618_g.func_177774_c((Object)stack.func_177230_c()).toString();
    }

    @Override
    public List<String> getBlockStates(net.minecraft.block.BlockState stack) {
        return stack.func_206869_a().stream().map(p -> p.func_177701_a()).collect(Collectors.toList());
    }

    private Stream<Map.Entry<IProperty<?>, Comparable<?>>> getProp(net.minecraft.block.BlockState state, String property) {
        return state.func_206871_b().entrySet().stream().filter(e -> ((IProperty)e.getKey()).func_177701_a().equals(property));
    }

    @Override
    public String getPropertyValue(net.minecraft.block.BlockState state, String property) {
        return this.getProp(state, property).map(this::propValue).findFirst().orElse(null);
    }

    private String propValue(Map.Entry<IProperty<?>, Comparable<?>> e) {
        IProperty<?> p = e.getKey();
        return p.func_177702_a(e.getValue());
    }

    @Override
    public int getPropertyValueInt(net.minecraft.block.BlockState state, String property) {
        return this.getProp(state, property).mapToInt(e -> {
            Comparable o = state.func_177229_b((IProperty)e.getKey());
            return o instanceof Number ? ((Number)((Object)o)).intValue() : -1;
        }).findFirst().orElse(-1);
    }

    @Override
    public List<String> getAllValuesFor(net.minecraft.block.BlockState state, String property) {
        return this.getProp(state, property).flatMap(e -> ((IProperty)e.getKey()).func_177700_c().stream().map(v -> {
            IProperty p = (IProperty)e.getKey();
            return p.func_177702_a(v);
        })).collect(Collectors.toList());
    }

    @Override
    public List<String> listTags(net.minecraft.block.BlockState stack) {
        return BlockTags.func_199896_a().func_199913_a((Object)stack.func_177230_c()).stream().map(e -> "#" + e).collect(Collectors.toList());
    }

    @Override
    public List<BlockState> listNativeEntries(String tag) {
        ArrayList<BlockState> stacks = new ArrayList<BlockState>();
        if (tag.charAt(0) == '#') {
            ResourceLocation rl = ResourceLocation.func_208304_a((String)tag.substring(1));
            if (rl != null) {
                Tag i = BlockTags.func_199896_a().func_199910_a(rl);
                i.func_199885_a().stream().map(b -> this.wrap(b.func_176223_P())).forEach(stacks::add);
            }
        } else {
            ResourceLocation rl = ResourceLocation.func_208304_a((String)tag);
            Block item = (Block)Registry.field_212618_g.func_82594_a(rl);
            if (item != null) {
                stacks.add(this.wrap(item.func_176223_P()));
            }
        }
        return stacks;
    }

    @Override
    public List<String> listNativeTags() {
        return BlockTags.func_199896_a().func_199908_a().stream().map(ResourceLocation::toString).collect(Collectors.toList());
    }

    @Override
    public List<BlockState> getAllElements() {
        return Registry.field_212618_g.func_201756_e().map(b -> this.wrap(b.func_176223_P())).collect(Collectors.toList());
    }

    @Override
    public boolean isInTag(String tag, net.minecraft.block.BlockState stack) {
        if (tag.charAt(0) == '#') {
            ResourceLocation rl = ResourceLocation.func_208304_a((String)tag.substring(1));
            if (rl != null) {
                Tag i = BlockTags.func_199896_a().func_199910_a(rl);
                return stack.func_203425_a(i);
            }
        } else {
            return this.getBlockId(stack).equals(tag);
        }
        return false;
    }

    @Override
    public boolean equals(net.minecraft.block.BlockState a, net.minecraft.block.BlockState b) {
        return a.func_177230_c() == b.func_177230_c();
    }

    @Override
    public Stack getStackFromState(net.minecraft.block.BlockState state) {
        return ItemStackHandlerImpl.impl.wrap(new ItemStack((IItemProvider)state.func_177230_c()));
    }

    @Override
    public boolean equalsFull(net.minecraft.block.BlockState a, net.minecraft.block.BlockState b) {
        return a.equals(b);
    }

    @Override
    public BlockState emptyObject() {
        return this.wrap(Blocks.field_150350_a.func_176223_P());
    }
}

