/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.math;

import com.google.common.collect.Queues;
import com.tom.cpl.math.Mat3f;
import com.tom.cpl.math.Mat4f;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.Quaternion;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.stream.Collectors;

public class MatrixStack {
    public static final Entry NO_RENDER;
    private final Deque<Entry> stack;

    public MatrixStack() {
        this.stack = Queues.newArrayDeque();
        Mat4f matrix4f = new Mat4f();
        matrix4f.setIdentity();
        Mat3f matrix3f = new Mat3f();
        matrix3f.setIdentity();
        this.stack.add(new Entry(matrix4f, matrix3f));
    }

    private MatrixStack(Deque<Entry> stack) {
        this.stack = stack;
    }

    public void translate(double x, double y, double z) {
        Entry e = this.stack.getLast();
        e.matrix.mul(Mat4f.makeTranslate((float)x, (float)y, (float)z));
    }

    public void scale(float x, float y, float z) {
        Entry e = this.stack.getLast();
        e.matrix.mul(Mat4f.makeScale(x, y, z));
        if (x == y && y == z) {
            if (x > 0.0f) {
                return;
            }
            e.normal.mul(-1.0f);
        }
        if (x < 0.0f || y < 0.0f || z < 0.0f) {
            float f = 1.0f / x;
            float f1 = 1.0f / y;
            float f2 = 1.0f / z;
            float f3 = MathHelper.fastInvCubeRoot(f * f1 * f2);
            e.normal.mul(Mat3f.makeScaleMatrix(f3 * f, f3 * f1, f3 * f2));
        }
    }

    public void rotate(Quaternion quaternion) {
        Entry e = this.stack.getLast();
        e.matrix.mul(quaternion);
        e.normal.mul(quaternion);
    }

    public void push() {
        Entry e = this.stack.getLast();
        this.stack.addLast(new Entry(e.matrix.copy(), e.normal.copy()));
    }

    public void pop() {
        this.stack.removeLast();
    }

    public Entry getLast() {
        return this.stack.getLast();
    }

    public boolean clear() {
        return this.stack.size() == 1;
    }

    public MatrixStack fork() {
        return new MatrixStack(this.stack.stream().map(Entry::copy).collect(Collectors.toCollection(ArrayDeque::new)));
    }

    public Entry storeLast() {
        Entry e = this.stack.getLast();
        return e.copy();
    }

    public void setLast(Entry in) {
        this.pop();
        this.stack.addLast(in.copy());
    }

    public void mul(Entry matrix) {
        Entry e = this.stack.getLast();
        e.matrix.mul(matrix.matrix);
        e.normal.mul(e.normal);
    }

    static {
        MatrixStack s = new MatrixStack();
        s.scale(0.0f, 0.0f, 0.0f);
        NO_RENDER = s.getLast();
    }

    public static final class Entry {
        private final Mat4f matrix;
        private final Mat3f normal;

        private Entry(Mat4f matrix, Mat3f normal) {
            this.matrix = matrix;
            this.normal = normal;
        }

        public Mat4f getMatrix() {
            return this.matrix;
        }

        public Mat3f getNormal() {
            return this.normal;
        }

        public float[] getMatrixArray() {
            return this.matrix.toArray();
        }

        public float[] getNormalArray() {
            return new Mat4f(this.normal).toArray();
        }

        public float[] getNormalArray3() {
            return this.normal.toArray();
        }

        public Entry copy() {
            return new Entry(this.matrix.copy(), this.normal.copy());
        }
    }
}

