/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.tom.cpl.text.FormatText;
import com.tom.cpm.CustomPlayerModels;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.ModelTexture;
import com.tom.cpm.client.Platform;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.common.PlayerAnimUpdater;
import com.tom.cpm.mixinplugin.Iris7Detector;
import com.tom.cpm.mixinplugin.IrisDetector;
import com.tom.cpm.mixinplugin.OFDetector;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.RenderManager;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.Log;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_563;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_5944;
import net.minecraft.class_634;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_898;

public abstract class ClientBase {
    public static final class_2960 DEFAULT_CAPE = new class_2960("cpm:textures/template/cape.png");
    public static boolean optifineLoaded;
    public static boolean irisLoaded;
    public static boolean vrLoaded;
    public static MinecraftObject mc;
    protected class_310 minecraft;
    public RenderManager<GameProfile, class_1657, class_3879, class_4597> manager;
    public NetHandler<class_2960, class_1657, class_634> netHandler;

    public void init0() {
        this.minecraft = class_310.method_1551();
        mc = new MinecraftObject(this.minecraft);
        optifineLoaded = OFDetector.doApply();
        vrLoaded = Platform.isModLoaded("vivecraft");
        boolean bl = irisLoaded = Iris7Detector.doApply() || IrisDetector.doApply();
        if (optifineLoaded) {
            Log.info("Optifine detected, enabling optifine compatibility");
        }
        if (vrLoaded) {
            Log.info("ViveCraft detected, enabling ViveCraft compatibility");
        }
        if (irisLoaded) {
            Log.info("Iris detected, enabling iris compatibility");
        }
    }

    public void init1() {
        this.manager = new RenderManager<GameProfile, class_1657, class_3879, class_4597>(mc.getPlayerRenderManager(), mc.getDefinitionLoader(), PlayerProfile::getPlayerProfile);
        this.manager.setGPGetters(GameProfile::getProperties, Property::getValue);
        this.netHandler = new NetHandler(class_2960::new);
        this.netHandler.setExecutor(() -> this.minecraft);
        this.netHandler.setSendPacketClient(d -> new class_2540(Unpooled.wrappedBuffer((byte[])d)), (c, rl, pb) -> c.method_2883((class_2596)new class_2817(rl, pb)));
        this.netHandler.setPlayerToLoader(class_1657::method_7334);
        this.netHandler.setGetPlayerById(id -> {
            class_1297 ent = class_310.method_1551().field_1687.method_8469(id);
            if (ent instanceof class_1657) {
                return (class_1657)ent;
            }
            return null;
        });
        this.netHandler.setGetClient(() -> this.minecraft.field_1724);
        this.netHandler.setGetNet(c -> ((class_746)c).field_3944);
        this.netHandler.setDisplayText(t -> this.minecraft.field_1724.method_7353((class_2561)t.remap(), false));
        this.netHandler.setGetPlayerAnimGetters(new PlayerAnimUpdater());
    }

    public static void apiInit() {
        CustomPlayerModels.api.buildClient().voicePlayer(class_1657.class, class_1297::method_5667).renderApi(class_3879.class, class_2960.class, class_1921.class, class_4597.class, GameProfile.class, ModelTexture::new).localModelApi(GameProfile::new).init();
    }

    public static void renderCape(class_4587 matrixStack, class_4588 buffer, int packedLightIn, class_742 abstractClientPlayerEntity, float partialTicks, class_591<class_742> model, ModelDefinition modelDefinition) {
        float s;
        float r;
        float q;
        matrixStack.method_22903();
        if (abstractClientPlayerEntity != null) {
            double d = class_3532.method_16436((double)partialTicks, (double)abstractClientPlayerEntity.field_7524, (double)abstractClientPlayerEntity.field_7500) - class_3532.method_16436((double)partialTicks, (double)abstractClientPlayerEntity.field_6014, (double)abstractClientPlayerEntity.method_23317());
            double e = class_3532.method_16436((double)partialTicks, (double)abstractClientPlayerEntity.field_7502, (double)abstractClientPlayerEntity.field_7521) - class_3532.method_16436((double)partialTicks, (double)abstractClientPlayerEntity.field_6036, (double)abstractClientPlayerEntity.method_23318());
            double m = class_3532.method_16436((double)partialTicks, (double)abstractClientPlayerEntity.field_7522, (double)abstractClientPlayerEntity.field_7499) - class_3532.method_16436((double)partialTicks, (double)abstractClientPlayerEntity.field_5969, (double)abstractClientPlayerEntity.method_23321());
            float n = abstractClientPlayerEntity.field_6220 + (abstractClientPlayerEntity.field_6283 - abstractClientPlayerEntity.field_6220);
            double o = class_3532.method_15374((float)(n * ((float)Math.PI / 180)));
            double p = -class_3532.method_15362((float)(n * ((float)Math.PI / 180)));
            q = (float)e * 10.0f;
            q = class_3532.method_15363((float)q, (float)-6.0f, (float)32.0f);
            r = (float)(d * o + m * p) * 100.0f;
            r = class_3532.method_15363((float)r, (float)0.0f, (float)150.0f);
            s = (float)(d * p - m * o) * 100.0f;
            s = class_3532.method_15363((float)s, (float)-20.0f, (float)20.0f);
            if (r < 0.0f) {
                r = 0.0f;
            }
            float t = class_3532.method_16439((float)partialTicks, (float)abstractClientPlayerEntity.field_7505, (float)abstractClientPlayerEntity.field_7483);
            q += class_3532.method_15374((float)(class_3532.method_16439((float)partialTicks, (float)abstractClientPlayerEntity.field_6039, (float)abstractClientPlayerEntity.field_5973) * 6.0f)) * 32.0f * t;
            if (abstractClientPlayerEntity.method_18276()) {
                q += 50.0f;
            }
            if (abstractClientPlayerEntity.method_6118(class_1304.field_6174).method_7960()) {
                if (abstractClientPlayerEntity.method_18276()) {
                    model.field_3485.field_3655 = 1.775f;
                    model.field_3485.field_3656 = 2.35f;
                } else {
                    model.field_3485.field_3655 = 2.0f;
                    model.field_3485.field_3656 = 0.0f;
                }
            } else if (abstractClientPlayerEntity.method_18276()) {
                model.field_3485.field_3655 = 2.3f;
                model.field_3485.field_3656 = 1.1f;
            } else {
                model.field_3485.field_3655 = 2.9f;
                model.field_3485.field_3656 = 0.14999998f;
            }
        } else {
            r = 0.0f;
            q = 0.0f;
            s = 0.0f;
        }
        model.field_3485.field_3654 = (float)(-Math.toRadians(6.0f + q / 2.0f + r));
        model.field_3485.field_3675 = (float)Math.toRadians(180.0f - s / 2.0f);
        model.field_3485.field_3674 = (float)Math.toRadians(s / 2.0f);
        mc.getPlayerRenderManager().setModelPose(model);
        model.field_3485.field_3654 = 0.0f;
        model.field_3485.field_3675 = 0.0f;
        model.field_3485.field_3674 = 0.0f;
        model.method_2823(matrixStack, buffer, packedLightIn, class_4608.field_21444);
        matrixStack.method_22909();
    }

    public <E extends class_1297> void renderNameTag(PlayerNameTagRenderer<E> r, E entityIn, GameProfile gprofile, String unique, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        FormatText st;
        double d0 = r.cpm$entityRenderDispatcher().method_23168(entityIn);
        if (d0 < 100.0 && (st = this.manager.getStatus(gprofile, unique)) != null) {
            matrixStackIn.method_22903();
            matrixStackIn.method_22904(0.0, (double)1.3f, 0.0);
            matrixStackIn.method_22905(0.5f, 0.5f, 0.5f);
            r.cpm$renderNameTag(entityIn, (class_2561)st.remap(), matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.method_22909();
        }
    }

    public void playerRenderPre(class_1657 player, class_4597 buffer, class_591 model) {
        this.manager.bindPlayer(player, buffer, (class_3879)model);
    }

    public void playerRenderPost(class_4597 buffer, class_591 model) {
        this.manager.unbindClear((class_3879)model);
    }

    public void renderHand(class_4597 buffer, class_591 model) {
        this.manager.bindHand((class_1657)this.minecraft.field_1724, buffer, (class_3879)model);
    }

    public void renderHandPost(class_4597 buffer, class_572 model) {
        this.manager.unbindClear((class_3879)model);
    }

    public void renderSkull(class_3879 skullModel, GameProfile profile, class_4597 buffer) {
        this.manager.bindSkull(profile, buffer, skullModel);
    }

    public void renderSkullPost(class_4597 buffer, class_3879 model) {
        this.manager.unbindFlush(model);
    }

    public void renderElytra(class_572<class_1309> player, class_563<class_1309> model) {
        this.manager.bindElytra((class_3879)player, (class_3879)model);
    }

    public void renderArmor(class_572<class_1309> modelArmor, class_572<class_1309> modelLeggings, class_572<class_1309> player) {
        this.manager.bindArmor((class_3879)player, (class_3879)modelArmor, 1);
        this.manager.bindArmor((class_3879)player, (class_3879)modelLeggings, 2);
    }

    public void updateJump() {
        if (this.minecraft.field_1724.method_24828() && this.minecraft.field_1724.field_3913.field_3904) {
            this.manager.jump((class_1657)this.minecraft.field_1724);
        }
    }

    public void registerShaders(ShaderLoader loader) {
    }

    public static interface PlayerNameTagRenderer<E extends class_1297> {
        public void cpm$renderNameTag(E var1, class_2561 var2, class_4587 var3, class_4597 var4, int var5);

        public class_898 cpm$entityRenderDispatcher();
    }

    public static interface ShaderLoader {
        public void cpm$registerShader(String var1, class_293 var2, Consumer<class_5944> var3);
    }
}

