/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim.menu;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.parts.anim.menu.AbstractDropdownButtonData;
import com.tom.cpm.shared.parts.anim.menu.GestureButtonType;
import com.tom.cpm.shared.parts.anim.menu.SimpleParameterValueAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LegacyDropdownButtonData
extends AbstractDropdownButtonData {
    public Map<String, Integer> parameters = new HashMap<String, Integer>();

    public LegacyDropdownButtonData() {
        this.parameters.put("", -1);
    }

    @Override
    public void onRegistered() {
        super.onRegistered();
        for (Map.Entry<String, Integer> e : this.parameters.entrySet()) {
            String opt = e.getKey();
            this.commandActions.add(new SimpleParameterValueAction(opt, e.getValue(), 1, this.command));
        }
    }

    @Override
    public GestureButtonType getType() {
        return GestureButtonType.DROPDOWN;
    }

    @Override
    public List<String> getActiveOptions() {
        return new ArrayList<String>(this.parameters.keySet());
    }

    @Override
    public void set(String selected) {
        AnimationEngine an = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine();
        this.parameters.forEach((k, v) -> {
            if (v == -1) {
                return;
            }
            an.setGestureValue((int)v, k.equals(selected) ? 1 : 0);
        });
    }

    @Override
    public String get() {
        AnimationEngine an = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine();
        return this.parameters.entrySet().stream().filter(e -> an.getGestureValue((Integer)e.getValue()) > 0).map(Map.Entry::getKey).findFirst().orElse("");
    }

    @Override
    public String getKeybindId() {
        return "d" + this.name;
    }

    @Override
    public void storeTo(ConfigEntry ce) {
        String sel = this.get();
        this.parameters.forEach((k, v) -> {
            if (v == -1) {
                return;
            }
            ce.setBoolean((String)k, k.equals(sel));
        });
    }

    @Override
    public void loadFrom(ConfigEntry ce) {
        String val = this.parameters.entrySet().stream().filter(e -> ce.getBoolean((String)e.getKey(), false)).map(Map.Entry::getKey).findFirst().orElse("");
        this.set(val);
    }

    public void register(String id, int param) {
        this.parameters.put(id, param);
    }
}

