/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.block.BlockState;
import com.tom.cpl.block.BlockStateHandler;
import com.tom.cpl.item.Stack;
import com.tom.cpm.common.ItemStackHandlerImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockStateHandlerImpl
extends BlockStateHandler<net.minecraft.world.level.block.state.BlockState> {
    public static final BlockStateHandlerImpl impl = new BlockStateHandlerImpl();

    @Override
    public String getBlockId(net.minecraft.world.level.block.state.BlockState stack) {
        return BuiltInRegistries.BLOCK.getKey((Object)stack.getBlock()).toString();
    }

    @Override
    public List<String> getBlockStates(net.minecraft.world.level.block.state.BlockState stack) {
        return stack.getProperties().stream().map(p -> p.getName()).toList();
    }

    private Stream<Map.Entry<Property<?>, Comparable<?>>> getProp(net.minecraft.world.level.block.state.BlockState state, String property) {
        return state.getValues().entrySet().stream().filter(e -> ((Property)e.getKey()).getName().equals(property));
    }

    @Override
    public String getPropertyValue(net.minecraft.world.level.block.state.BlockState state, String property) {
        return this.getProp(state, property).map(this::propValue).findFirst().orElse(null);
    }

    private String propValue(Map.Entry<Property<?>, Comparable<?>> e) {
        Property<?> p = e.getKey();
        return p.getName(e.getValue());
    }

    @Override
    public int getPropertyValueInt(net.minecraft.world.level.block.state.BlockState state, String property) {
        return this.getProp(state, property).mapToInt(e -> {
            int n;
            Comparable patt0$temp = state.getValue((Property)e.getKey());
            if (patt0$temp instanceof Number) {
                Number n2 = (Number)((Object)patt0$temp);
                n = n2.intValue();
            } else {
                n = -1;
            }
            return n;
        }).findFirst().orElse(-1);
    }

    @Override
    public List<String> getAllValuesFor(net.minecraft.world.level.block.state.BlockState state, String property) {
        return this.getProp(state, property).flatMap(e -> ((Property)e.getKey()).getPossibleValues().stream().map(v -> {
            Property p = (Property)e.getKey();
            return p.getName(v);
        })).toList();
    }

    @Override
    public List<String> listTags(net.minecraft.world.level.block.state.BlockState stack) {
        return stack.getBlockHolder().tags().map(k -> "#" + String.valueOf(k.location())).toList();
    }

    @Override
    public List<BlockState> listNativeEntries(String tag) {
        ArrayList<BlockState> stacks = new ArrayList<BlockState>();
        if (tag.charAt(0) == '#') {
            ResourceLocation rl = ResourceLocation.tryParse((String)tag.substring(1));
            if (rl != null) {
                TagKey i = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)rl);
                BuiltInRegistries.BLOCK.getTag(i).map(t -> t.stream().map(h -> h.unwrap().right()).filter(Optional::isPresent).map(o -> this.wrap(((Block)o.get()).defaultBlockState())).toList()).ifPresent(stacks::addAll);
            }
        } else {
            ResourceLocation rl = ResourceLocation.tryParse((String)tag);
            Block item = (Block)BuiltInRegistries.BLOCK.get(rl);
            if (item != null) {
                stacks.add(this.wrap(item.defaultBlockState()));
            }
        }
        return stacks;
    }

    @Override
    public List<String> listNativeTags() {
        return BuiltInRegistries.BLOCK.getTagNames().map(k -> k.location().toString()).toList();
    }

    @Override
    public List<BlockState> getAllElements() {
        return BuiltInRegistries.BLOCK.stream().map(b -> this.wrap(b.defaultBlockState())).toList();
    }

    @Override
    public boolean isInTag(String tag, net.minecraft.world.level.block.state.BlockState stack) {
        if (tag.charAt(0) == '#') {
            ResourceLocation rl = ResourceLocation.tryParse((String)tag.substring(1));
            if (rl != null) {
                TagKey i = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)rl);
                return stack.is(i);
            }
        } else {
            return this.getBlockId(stack).equals(tag);
        }
        return false;
    }

    @Override
    public boolean equals(net.minecraft.world.level.block.state.BlockState a, net.minecraft.world.level.block.state.BlockState b) {
        return a.getBlock() == b.getBlock();
    }

    @Override
    public Stack getStackFromState(net.minecraft.world.level.block.state.BlockState state) {
        return ItemStackHandlerImpl.impl.wrap(new ItemStack((ItemLike)state.getBlock()));
    }

    @Override
    public boolean equalsFull(net.minecraft.world.level.block.state.BlockState a, net.minecraft.world.level.block.state.BlockState b) {
        return a.equals(b);
    }

    @Override
    public BlockState emptyObject() {
        return this.wrap(Blocks.AIR.defaultBlockState());
    }
}

