/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyCodes;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.NativeGuiComponents;
import com.tom.cpl.gui.UIColors;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.item.Stack;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.text.IText;
import com.tom.cpm.client.GLFWKeyCodes;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.Panel3dImpl;
import com.tom.cpm.client.Platform;
import com.tom.cpm.client.TinyFDChooser;
import com.tom.cpm.common.ItemStackHandlerImpl;
import com.tom.cpm.shared.MinecraftCommonAccess;
import com.tom.cpm.shared.gui.panel.Panel3d;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_1309;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1659;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_408;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.client.ClientBrandRetriever;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL11;

public class GuiBase
extends class_437
implements IGui {
    protected static final KeyCodes CODES = new GLFWKeyCodes();
    protected static final NativeGuiComponents nativeComponents = new NativeGuiComponents();
    protected Frame gui;
    protected class_437 parent;
    protected IGui.CtxStack stack;
    protected UIColors colors = new UIColors();
    protected Consumer<Runnable> closeListener;
    protected int keyModif;
    protected boolean noScissorTest;
    protected int vanillaScale = -1;

    public GuiBase(Function<IGui, Frame> creator, class_437 parent) {
        super((class_2561)new class_2585(""));
        this.parent = parent;
        try {
            this.gui = creator.apply(this);
        }
        catch (Throwable e) {
            this.onGuiException("Error creating gui", e, true);
        }
        this.noScissorTest = this.isCtrlDown();
    }

    private static <G extends Supplier<IGui>, N> NativeGuiComponents.NativeConstructor<G, N> local(Function<GuiBase, N> fac) {
        return f -> fac.apply((GuiBase)f.get());
    }

    public boolean isPauseScreen() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(int mouseX, int mouseY, float partialTicks) {
        block8: {
            this.renderBackground(0);
            try {
                RenderSystem.pushMatrix();
                RenderSystem.translated((double)0.0, (double)0.0, (double)500.0);
                GL11.glEnable((int)3089);
                this.stack = new IGui.CtxStack(this.width, this.height);
                this.gui.draw(mouseX, mouseY, partialTicks);
                if (this.noScissorTest) break block8;
            }
            catch (Throwable e) {
                block9: {
                    try {
                        this.onGuiException("Error drawing gui", e, true);
                        if (this.noScissorTest) break block9;
                    }
                    catch (Throwable throwable) {
                        if (!this.noScissorTest) {
                            GL11.glDisable((int)3089);
                        }
                        String modVer = MinecraftCommonAccess.get().getModVersion();
                        String s = "Minecraft " + class_155.method_16673().getName() + " (" + this.minecraft.method_1515() + "/" + ClientBrandRetriever.getClientModName() + ("release".equalsIgnoreCase(this.minecraft.method_1547()) ? "" : "/" + this.minecraft.method_1547()) + ") " + modVer;
                        this.font.method_1729(s, (float)(this.width - this.font.method_1727(s) - 4), 2.0f, -16777216);
                        s = this.minecraft.field_1770;
                        if (this.noScissorTest) {
                            s = s + " No Scissor";
                        }
                        this.font.method_1729(s, (float)(this.width - this.font.method_1727(s) - 4), 11.0f, -16777216);
                        RenderSystem.popMatrix();
                        throw throwable;
                    }
                    GL11.glDisable((int)3089);
                }
                String modVer = MinecraftCommonAccess.get().getModVersion();
                String s = "Minecraft " + class_155.method_16673().getName() + " (" + this.minecraft.method_1515() + "/" + ClientBrandRetriever.getClientModName() + ("release".equalsIgnoreCase(this.minecraft.method_1547()) ? "" : "/" + this.minecraft.method_1547()) + ") " + modVer;
                this.font.method_1729(s, (float)(this.width - this.font.method_1727(s) - 4), 2.0f, -16777216);
                s = this.minecraft.field_1770;
                if (this.noScissorTest) {
                    s = s + " No Scissor";
                }
                this.font.method_1729(s, (float)(this.width - this.font.method_1727(s) - 4), 11.0f, -16777216);
                RenderSystem.popMatrix();
            }
            GL11.glDisable((int)3089);
        }
        String modVer = MinecraftCommonAccess.get().getModVersion();
        String s = "Minecraft " + class_155.method_16673().getName() + " (" + this.minecraft.method_1515() + "/" + ClientBrandRetriever.getClientModName() + ("release".equalsIgnoreCase(this.minecraft.method_1547()) ? "" : "/" + this.minecraft.method_1547()) + ") " + modVer;
        this.font.method_1729(s, (float)(this.width - this.font.method_1727(s) - 4), 2.0f, -16777216);
        s = this.minecraft.field_1770;
        if (this.noScissorTest) {
            s = s + " No Scissor";
        }
        this.font.method_1729(s, (float)(this.width - this.font.method_1727(s) - 4), 11.0f, -16777216);
        RenderSystem.popMatrix();
    }

    public void removed() {
        this.minecraft.field_1774.method_1462(false);
        if (this.vanillaScale >= 0 && this.vanillaScale != this.minecraft.field_1690.field_1868) {
            this.minecraft.field_1690.field_1868 = this.vanillaScale;
            this.vanillaScale = -999;
            this.minecraft.method_15993();
        }
    }

    public void onClose() {
        class_437 p = this.parent;
        this.parent = null;
        this.minecraft.method_1507(p);
    }

    @Override
    public void drawBox(int x, int y, int w, int h, int color) {
        GuiBase.fill((int)(x += this.getOffset().x), (int)(y += this.getOffset().y), (int)(x + w), (int)(y + h), (int)color);
    }

    @Override
    public void drawBox(float x, float y, float w, float h, int color) {
        float minX = x += (float)this.getOffset().x;
        float minY = y += (float)this.getOffset().y;
        float maxX = x + w;
        float maxY = y + h;
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        class_287 bufferbuilder = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        bufferbuilder.method_1328(7, class_290.field_1576);
        bufferbuilder.method_22912((double)minX, (double)maxY, 0.0).method_22915(f, f1, f2, f3).method_1344();
        bufferbuilder.method_22912((double)maxX, (double)maxY, 0.0).method_22915(f, f1, f2, f3).method_1344();
        bufferbuilder.method_22912((double)maxX, (double)minY, 0.0).method_22915(f, f1, f2, f3).method_1344();
        bufferbuilder.method_22912((double)minX, (double)minY, 0.0).method_22915(f, f1, f2, f3).method_1344();
        bufferbuilder.method_1326();
        class_286.method_1309((class_287)bufferbuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    protected void init() {
        this.minecraft.field_1774.method_1462(true);
        try {
            this.gui.init(this.width, this.height);
        }
        catch (Throwable e) {
            this.onGuiException("Error in init gui", e, true);
        }
    }

    @Override
    public void drawText(int x, int y, String text, int color) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)50.0f);
        this.font.method_1729(text, (float)(x += this.getOffset().x), (float)(y += this.getOffset().y), color);
        RenderSystem.popMatrix();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        try {
            this.keyModif = modifiers;
            KeyboardEvent evt = new KeyboardEvent(keyCode, scanCode, '\uffff', GLFW.glfwGetKeyName((int)keyCode, (int)scanCode));
            this.gui.keyPressed(evt);
            if (!evt.isConsumed() && this.gui.enableChat() && this.gui.enableChat() && this.minecraft.field_1724 != null && this.minecraft.field_1690.field_1890.method_1417(keyCode, scanCode) && this.minecraft.field_1690.field_1877 != class_1659.field_7536) {
                RenderSystem.recordRenderCall(() -> {
                    int scale = this.vanillaScale;
                    this.vanillaScale = -1;
                    this.minecraft.method_1507((class_437)new Overlay());
                    this.vanillaScale = scale;
                });
                return true;
            }
            return true;
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
            return true;
        }
    }

    public boolean charTyped(char codePoint, int modifiers) {
        try {
            this.keyModif = modifiers;
            KeyboardEvent evt = new KeyboardEvent(-1, -1, codePoint, null);
            this.gui.keyPressed(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
            return true;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseClick(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseDrag(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseRelease(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (delta != 0.0) {
            try {
                MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, (int)delta);
                this.gui.mouseWheel(evt);
                return evt.isConsumed();
            }
            catch (Throwable e) {
                this.onGuiException("Error processing mouse event", e, false);
                return true;
            }
        }
        return false;
    }

    @Override
    public void displayError(String e) {
        class_437 p = this.parent;
        this.parent = null;
        class_310.method_1551().method_1507((class_437)new CrashScreen(e, p));
    }

    @Override
    public void closeGui() {
        if (this.closeListener != null) {
            this.closeListener.accept(this::onClose);
        } else {
            this.onClose();
        }
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture) {
        this.minecraft.method_1531().method_22813(new class_2960("cpm", "textures/gui/" + texture + ".png"));
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.blit(x += this.getOffset().x, y += this.getOffset().y, u, v, w, h);
        RenderSystem.disableBlend();
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture, int color) {
        this.minecraft.method_1531().method_22813(new class_2960("cpm", "textures/gui/" + texture + ".png"));
        x += this.getOffset().x;
        y += this.getOffset().y;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.blit(x, y, u, v, w, h);
        RenderSystem.disableBlend();
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float u1, float v1, float u2, float v2) {
        x += this.getOffset().x;
        y += this.getOffset().y;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.method_1531().method_22813(MinecraftObject.DynTexture.getBoundLoc());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        bufferbuilder.method_1328(7, class_290.field_1585);
        float bo = this.getBlitOffset();
        bufferbuilder.method_22912((double)x, (double)(y + height), (double)bo).method_22913(u1, v2).method_1344();
        bufferbuilder.method_22912((double)(x + width), (double)(y + height), (double)bo).method_22913(u2, v2).method_1344();
        bufferbuilder.method_22912((double)(x + width), (double)y, (double)bo).method_22913(u2, v1).method_1344();
        bufferbuilder.method_22912((double)x, (double)y, (double)bo).method_22913(u1, v1).method_1344();
        bufferbuilder.method_1326();
        RenderSystem.enableAlphaTest();
        class_286.method_1309((class_287)bufferbuilder);
        RenderSystem.disableBlend();
    }

    @Override
    public String i18nFormat(String key, Object ... obj) {
        return class_1074.method_4662((String)key, (Object[])obj);
    }

    @Override
    public void setupCut() {
        if (!this.noScissorTest) {
            int dw = this.minecraft.method_22683().method_4489();
            int dh = this.minecraft.method_22683().method_4506();
            float multiplierX = (float)dw / (float)this.width;
            float multiplierY = (float)dh / (float)this.height;
            Box box = this.getContext().cutBox;
            GL11.glScissor((int)((int)((float)box.x * multiplierX)), (int)(dh - (int)((float)(box.y + box.h) * multiplierY)), (int)((int)((float)box.w * multiplierX)), (int)((int)((float)box.h * multiplierY)));
        }
    }

    @Override
    public int textWidth(String text) {
        return this.font.method_1727(text);
    }

    private TextField.ITextField createTextField() {
        return new TxtField();
    }

    @Override
    public UIColors getColors() {
        return this.colors;
    }

    @Override
    public void setCloseListener(Consumer<Runnable> listener) {
        this.closeListener = listener;
    }

    @Override
    public boolean isShiftDown() {
        return GuiBase.hasShiftDown();
    }

    @Override
    public boolean isCtrlDown() {
        return GuiBase.hasControlDown();
    }

    @Override
    public boolean isAltDown() {
        return GuiBase.hasAltDown();
    }

    @Override
    public KeyCodes getKeyCodes() {
        return CODES;
    }

    @Override
    public void drawGradientBox(int x, int y, int w, int h, int topLeft, int topRight, int bottomLeft, int bottomRight) {
        int left = x += this.getOffset().x;
        int top = y += this.getOffset().y;
        int right = x + w;
        int bottom = y + h;
        float atr = (float)(topRight >> 24 & 0xFF) / 255.0f;
        float rtr = (float)(topRight >> 16 & 0xFF) / 255.0f;
        float gtr = (float)(topRight >> 8 & 0xFF) / 255.0f;
        float btr = (float)(topRight & 0xFF) / 255.0f;
        float atl = (float)(topLeft >> 24 & 0xFF) / 255.0f;
        float rtl = (float)(topLeft >> 16 & 0xFF) / 255.0f;
        float gtl = (float)(topLeft >> 8 & 0xFF) / 255.0f;
        float btl = (float)(topLeft & 0xFF) / 255.0f;
        float abl = (float)(bottomLeft >> 24 & 0xFF) / 255.0f;
        float rbl = (float)(bottomLeft >> 16 & 0xFF) / 255.0f;
        float gbl = (float)(bottomLeft >> 8 & 0xFF) / 255.0f;
        float bbl = (float)(bottomLeft & 0xFF) / 255.0f;
        float abr = (float)(bottomRight >> 24 & 0xFF) / 255.0f;
        float rbr = (float)(bottomRight >> 16 & 0xFF) / 255.0f;
        float gbr = (float)(bottomRight >> 8 & 0xFF) / 255.0f;
        float bbr = (float)(bottomRight & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        bufferbuilder.method_1328(7, class_290.field_1576);
        bufferbuilder.method_22912((double)right, (double)top, (double)this.getBlitOffset()).method_22915(rtr, gtr, btr, atr).method_1344();
        bufferbuilder.method_22912((double)left, (double)top, (double)this.getBlitOffset()).method_22915(rtl, gtl, btl, atl).method_1344();
        bufferbuilder.method_22912((double)left, (double)bottom, (double)this.getBlitOffset()).method_22915(rbl, gbl, bbl, abl).method_1344();
        bufferbuilder.method_22912((double)right, (double)bottom, (double)this.getBlitOffset()).method_22915(rbr, gbr, bbr, abr).method_1344();
        tessellator.method_1350();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    @Override
    public NativeGuiComponents getNative() {
        return nativeComponents;
    }

    @Override
    public void setClipboardText(String text) {
        this.minecraft.field_1774.method_1455(text);
    }

    @Override
    public Frame getFrame() {
        return this.gui;
    }

    @Override
    public String getClipboardText() {
        return this.minecraft.field_1774.method_1460();
    }

    @Override
    public void setScale(int value) {
        if (this.vanillaScale == -999) {
            return;
        }
        if (value != this.minecraft.field_1690.field_1868) {
            if (this.vanillaScale == -1) {
                this.vanillaScale = this.minecraft.field_1690.field_1868;
            }
            if (value == -1) {
                if (this.minecraft.field_1690.field_1868 != this.vanillaScale) {
                    this.minecraft.field_1690.field_1868 = this.vanillaScale;
                    this.vanillaScale = -1;
                    this.minecraft.method_15993();
                }
            } else {
                this.minecraft.field_1690.field_1868 = value;
                this.minecraft.method_15993();
            }
        }
    }

    @Override
    public int getScale() {
        return this.minecraft.field_1690.field_1868;
    }

    @Override
    public int getMaxScale() {
        return this.minecraft.method_22683().method_4476(0, this.minecraft.method_1573()) + 1;
    }

    @Override
    public IGui.CtxStack getStack() {
        return this.stack;
    }

    public void tick() {
        try {
            this.gui.tick();
        }
        catch (Throwable e) {
            this.onGuiException("Error in tick gui", e, true);
        }
    }

    @Override
    public void drawFormattedText(float x, float y, IText text, int color, float scale) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(x += (float)this.getOffset().x), (float)(y += (float)this.getOffset().y), (float)50.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        this.font.method_1729(((class_2561)text.remap()).method_10863(), 0.0f, 0.0f, color);
        RenderSystem.popMatrix();
    }

    @Override
    public int textWidthFormatted(IText text) {
        return this.font.method_1727(((class_2561)text.remap()).getString());
    }

    @Override
    public void openURL0(String url) {
        class_156.method_668().method_670(url);
    }

    public void onOpened() {
        this.vanillaScale = -1;
    }

    @Override
    public void drawStack(int x, int y, Stack stack) {
        class_1799 s = (class_1799)ItemStackHandlerImpl.impl.unwrap(stack);
        this.itemRenderer.method_4026((class_1309)this.minecraft.field_1724, s, x += this.getOffset().x, y += this.getOffset().y);
        this.itemRenderer.method_4022(this.font, s, x, y, null);
    }

    @Override
    public void drawStackTooltip(int mx, int my, Stack stack) {
        class_1799 s = (class_1799)ItemStackHandlerImpl.impl.unwrap(stack);
        this.renderTooltip(s, mx, my);
        RenderSystem.disableRescaleNormal();
    }

    static {
        nativeComponents.register(TextField.class, GuiBase.local(GuiBase::createTextField));
        nativeComponents.register(FileChooserPopup.class, TinyFDChooser::new);
        nativeComponents.register(Panel3d.class, Panel3dImpl::new);
    }

    private static class CrashScreen
    extends class_437 {
        private String error;
        private class_437 parent;

        public CrashScreen(String error, class_437 p) {
            super((class_2561)new class_2585("Error"));
            this.error = error;
            this.parent = p;
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            this.renderBackground();
            String[] txt = IGui.wordWrap(class_1074.method_4662((String)"error.cpm.crash", (Object[])new Object[]{this.error}), this.width - 200, arg_0 -> ((class_327)this.font).method_1727(arg_0)).split("\\\\");
            for (int i = 0; i < txt.length; ++i) {
                this.drawCenteredString(this.font, txt[i], this.width / 2, 15 + i * 10, 0xFFFFFF);
            }
            super.render(mouseX, mouseY, partialTicks);
        }

        protected void init() {
            super.init();
            this.addButton((class_339)new class_4185(this.width / 2 - 100, 140, 200, 20, class_1074.method_4662((String)"gui.back", (Object[])new Object[0]), p_213034_1_ -> this.minecraft.method_1507((class_437)null)));
        }

        public void onClose() {
            if (this.parent != null) {
                class_437 p = this.parent;
                this.parent = null;
                this.minecraft.method_1507(p);
            }
        }
    }

    private class TxtField
    implements TextField.ITextField,
    Consumer<String> {
        private class_342 field;
        private Runnable eventListener;
        private Vec2i currentOff = new Vec2i(0, 0);
        private Box bounds = new Box(0, 0, 0, 0);
        private boolean settingText;
        private boolean updateField;
        private boolean enabled;

        public TxtField() {
            this.field = new class_342(GuiBase.this.font, 0, 0, 0, 0, class_1074.method_4662((String)"narrator.cpm.field", (Object[])new Object[0]));
            this.field.method_1880(0x100000);
            this.field.method_1858(false);
            this.field.method_1862(true);
            this.field.method_1868(GuiBase.this.colors.label_text_color);
            this.field.method_1863((Consumer)this);
            this.enabled = true;
        }

        @Override
        public void draw(int mouseX, int mouseY, float partialTicks, Box bounds) {
            Vec2i off = GuiBase.this.getOffset();
            this.field.x = bounds.x + off.x + 4;
            this.field.y = bounds.y + off.y + 6;
            this.currentOff.x = off.x;
            this.currentOff.y = off.y;
            this.bounds.x = bounds.x;
            this.bounds.y = bounds.y;
            this.bounds.w = bounds.w;
            this.bounds.h = bounds.h;
            this.field.setWidth(bounds.w - 5);
            Platform.setHeight((class_339)this.field, bounds.h - 12);
            if (this.updateField) {
                this.settingText = true;
                this.field.method_1872();
                this.settingText = false;
                this.updateField = false;
            }
            this.field.render(mouseX, mouseY, partialTicks);
        }

        @Override
        public void keyPressed(KeyboardEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            if (evt.keyCode == -1) {
                if (this.field.charTyped(evt.charTyped, GuiBase.this.keyModif)) {
                    evt.consume();
                }
            } else if (this.field.keyPressed(evt.keyCode, evt.scancode, GuiBase.this.keyModif) || this.field.method_20315()) {
                evt.consume();
            }
        }

        @Override
        public void mouseClick(MouseEvent evt) {
            if (evt.isConsumed()) {
                this.field.mouseClicked(-2.147483648E9, -2.147483648E9, evt.btn);
                return;
            }
            this.field.x = this.bounds.x + this.currentOff.x;
            this.field.y = this.bounds.y + this.currentOff.y;
            this.field.setWidth(this.bounds.w);
            Platform.setHeight((class_339)this.field, this.bounds.h);
            if (this.field.mouseClicked((double)(evt.x + this.currentOff.x), (double)(evt.y + this.currentOff.y), evt.btn)) {
                evt.consume();
            }
        }

        @Override
        public String getText() {
            return this.field.method_1882();
        }

        @Override
        public void setText(String txt) {
            this.settingText = true;
            this.field.method_1852(txt);
            this.settingText = false;
            this.updateField = true;
        }

        @Override
        public void setEventListener(Runnable eventListener) {
            this.eventListener = eventListener;
        }

        @Override
        public void accept(String value) {
            if (this.eventListener != null && !this.settingText && this.enabled) {
                this.eventListener.run();
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.field.method_1888(enabled);
            this.enabled = enabled;
        }

        @Override
        public boolean isFocused() {
            return this.field.isFocused();
        }

        @Override
        public void setFocused(boolean focused) {
            this.field.method_1876(focused);
        }

        @Override
        public int getCursorPos() {
            return this.field.method_1881();
        }

        @Override
        public void setCursorPos(int pos) {
            this.field.method_1875(pos);
        }

        @Override
        public void setSelectionPos(int pos) {
            this.field.method_1884(pos);
        }

        @Override
        public int getSelectionPos() {
            return this.field.field_2101;
        }
    }

    public class Overlay
    extends class_408 {
        public Overlay() {
            super("");
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-100.0f);
            GuiBase.this.render(Integer.MIN_VALUE, Integer.MIN_VALUE, partialTicks);
            RenderSystem.popMatrix();
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)900.0f);
            super.render(mouseX, mouseY, partialTicks);
            RenderSystem.popMatrix();
        }

        public class_437 getGui() {
            return GuiBase.this;
        }
    }
}

