/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts;

import com.tom.cpl.math.Vec3f;
import com.tom.cpl.text.FormatText;
import com.tom.cpm.shared.animation.Animation;
import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.animation.IModelComponent;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.InterpolatorChannel;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.animation.interpolator.InterpolatorType;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.ExportException;
import com.tom.cpm.shared.editor.anim.AnimFrame;
import com.tom.cpm.shared.editor.anim.IElem;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.project.loaders.AnimationsLoaderV1;
import com.tom.cpm.shared.editor.util.PlayerSkinLayer;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart;
import com.tom.cpm.shared.parts.ModelPartType;
import com.tom.cpm.shared.parts.anim.LegacyAnimationParser;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@Deprecated
public class ModelPartAnimation
implements IModelPart,
IResolvedModelPart {
    private Map<Integer, ResolvedData> parsedData = new HashMap<Integer, ResolvedData>();
    private int blankId;
    private int resetId;
    private String modelProfilesId;

    public ModelPartAnimation(IOHelper din, ModelDefinition def) throws IOException {
        Type type;
        while ((type = (Type)din.readEnum(Type.VALUES)) != Type.END) {
            IOHelper block = din.readNextBlock();
            if (type == null) continue;
            switch (type) {
                case END: {
                    break;
                }
                case GESTURE: {
                    int id = block.read();
                    String name = block.readUTF();
                    int flags = block.read();
                    this.parsedData.put(id, new ResolvedData(name, (flags & 2) != 0, (flags & 1) != 0));
                    break;
                }
                case POSE: {
                    VanillaPose pose = (VanillaPose)block.readEnum(VanillaPose.values());
                    int id = block.read();
                    int flags = block.read();
                    if (pose == VanillaPose.CUSTOM) {
                        String name = block.readUTF();
                        CustomPose p = this.parsedData.values().stream().map(k -> ((ResolvedData)k).pose).filter(k -> k instanceof CustomPose && ((CustomPose)k).getName().equals(name)).map(k -> (CustomPose)k).findFirst().orElse(null);
                        if (p == null) {
                            p = new CustomPose(name, 0);
                        }
                        this.parsedData.put(id, new ResolvedData(p, (flags & 1) != 0));
                        break;
                    }
                    this.parsedData.put(id, new ResolvedData(pose, (flags & 1) != 0));
                    break;
                }
                case ANIMATION_DATA_COLOR: {
                    int id = block.read();
                    ResolvedData rd = this.parsedData.get(id);
                    if (rd == null) break;
                    int cid = block.read();
                    ((ResolvedData)rd).color[cid] = new Vec3f[rd.frames];
                    for (int i = 0; i < rd.frames; ++i) {
                        int b;
                        int g;
                        int r = block.read();
                        if ((r | (g = block.read()) | (b = block.read())) < 0) {
                            throw new EOFException();
                        }
                        ((ResolvedData)rd).color[cid][i] = new Vec3f(r, g, b);
                    }
                    break;
                }
                case ANIMATION_DATA_POS: {
                    int id = block.read();
                    ResolvedData rd = this.parsedData.get(id);
                    if (rd == null) break;
                    int cid = block.read();
                    ((ResolvedData)rd).pos[cid] = new Vec3f[rd.frames];
                    for (int i = 0; i < rd.frames; ++i) {
                        ((ResolvedData)rd).pos[cid][i] = block.readVec6b();
                    }
                    break;
                }
                case ANIMATION_DATA_ROTATION: {
                    int id = block.read();
                    ResolvedData rd = this.parsedData.get(id);
                    if (rd == null) break;
                    int cid = block.read();
                    ((ResolvedData)rd).rot[cid] = new Vec3f[rd.frames];
                    for (int i = 0; i < rd.frames; ++i) {
                        ((ResolvedData)rd).rot[cid][i] = block.readAngle();
                    }
                    break;
                }
                case ANIMATION_DATA_VIS: {
                    int id = block.read();
                    ResolvedData rd = this.parsedData.get(id);
                    if (rd == null) break;
                    int cid = block.read();
                    ((ResolvedData)rd).show[cid] = new Boolean[rd.frames];
                    for (int i = 0; i < rd.frames; i += 8) {
                        int dt = block.read();
                        for (int j = 0; i + j < rd.frames && j < 8; ++j) {
                            ((ResolvedData)rd).show[cid][i + j] = (dt & 1 << j) != 0;
                        }
                    }
                    break;
                }
                case ANIMATION_INFO: {
                    int id = block.read();
                    ResolvedData rd = this.parsedData.get(id);
                    if (rd == null) break;
                    int count = block.read();
                    int frames = block.read();
                    short duration = block.readShort();
                    ResolvedData.access$502(rd, new int[count]);
                    for (int i = 0; i < count; ++i) {
                        ((ResolvedData)rd).components[i] = block.readVarInt();
                    }
                    ResolvedData.access$202(rd, new Vec3f[count][]);
                    ResolvedData.access$302(rd, new Vec3f[count][]);
                    ResolvedData.access$602(rd, new Vec3f[count][]);
                    ResolvedData.access$002(rd, new Vec3f[count][]);
                    ResolvedData.access$402(rd, new Boolean[count][]);
                    rd.frames = frames;
                    rd.duration = duration;
                    break;
                }
                case ENCODING: 
                case ANIMATION_DATA_ENC: {
                    int id = block.read();
                    ResolvedData rd = this.parsedData.get(id);
                    if (rd == null) break;
                    rd.gid = block.read();
                    rd.layerCtrl = type == Type.ENCODING;
                    break;
                }
                case CTRL_IDS: {
                    this.blankId = block.read();
                    this.resetId = block.read();
                    break;
                }
                case ANIMATION_DATA_EXTRA: {
                    int id = block.read();
                    ResolvedData rd = this.parsedData.get(id);
                    if (rd == null) break;
                    rd.priority = block.readByte();
                    break;
                }
                case ANIMATION_DATA_INTERPOLATION: {
                    int id = block.read();
                    ResolvedData rd = this.parsedData.get(id);
                    if (rd == null) break;
                    rd.it = (InterpolatorType)block.readEnum(InterpolatorType.VALUES);
                    break;
                }
                case ANIMATION_DATA_SCALE: {
                    int id = block.read();
                    ResolvedData rd = this.parsedData.get(id);
                    if (rd == null) break;
                    int cid = block.read();
                    ((ResolvedData)rd).scale[cid] = new Vec3f[rd.frames];
                    for (int i = 0; i < rd.frames; ++i) {
                        ((ResolvedData)rd).scale[cid][i] = block.readVec6b();
                    }
                    break;
                }
                case ANIMATION_DATA_LAYER_DEFAULT: {
                    int id = block.read();
                    ResolvedData rd = this.parsedData.get(id);
                    if (rd == null) break;
                    rd.defaultValue = block.readByte();
                    break;
                }
                case ANIMATION_DATA_ORDER: {
                    int id = block.read();
                    ResolvedData rd = this.parsedData.get(id);
                    if (rd == null) break;
                    rd.order = block.readByte();
                    if (!(rd.pose instanceof CustomPose)) break;
                    ((CustomPose)((ResolvedData)rd).pose).order = rd.order;
                    break;
                }
                case ANIMATION_DATA_IS_PROPERTY: {
                    int id = block.read();
                    ResolvedData rd = this.parsedData.get(id);
                    if (rd == null) break;
                    rd.isProperty = true;
                    break;
                }
                case ANIMATION_DATA_GROUP: {
                    int id = block.read();
                    ResolvedData rd = this.parsedData.get(id);
                    if (rd == null) break;
                    rd.group = block.readUTF();
                    break;
                }
                case MODEL_PROFILES_ID: {
                    this.modelProfilesId = block.readUTF();
                    break;
                }
                case ANIMATION_DATA_COMMAND: {
                    int id = block.read();
                    ResolvedData rd = this.parsedData.get(id);
                    if (rd == null) break;
                    rd.command = true;
                    break;
                }
                case ANIMATION_MUST_FINISH: {
                    int id = block.read();
                    ResolvedData rd = this.parsedData.get(id);
                    if (rd == null) break;
                    rd.finish = true;
                    break;
                }
                case ANIMATION_SLIDER_OPT: {
                    int id = block.read();
                    ResolvedData rd = this.parsedData.get(id);
                    if (rd == null) break;
                    rd.interpolateVal = block.readBoolean();
                    rd.maxValue = block.readByte();
                    break;
                }
                case ANIMATION_BUTTON_HIDDEN: {
                    int id = block.read();
                    ResolvedData rd = this.parsedData.get(id);
                    if (rd == null) break;
                    rd.buttonHidden = true;
                    break;
                }
            }
        }
    }

    public ModelPartAnimation(Editor e, List<IModelPart> otherParts) {
        int[] idc = new int[]{0, 1};
        int valMask = e.animEnc == null ? 0 : PlayerSkinLayer.encode(e.animEnc.freeLayers);
        int defMask = e.animEnc == null ? 0 : PlayerSkinLayer.encode(e.animEnc.defaultLayerValue) & ~valMask;
        this.resetId = defMask | valMask;
        this.blankId = defMask | 0;
        this.modelProfilesId = e.modelId;
        ArrayList<PlayerSkinLayer> allLayers = e.animEnc != null ? new ArrayList<PlayerSkinLayer>(e.animEnc.freeLayers) : new ArrayList();
        Collections.sort(allLayers);
        ArrayList notLayerControlled = new ArrayList();
        HashSet addedPoses = new HashSet();
        HashSet addedGestures = new HashSet();
        HashSet allElems = new HashSet();
        Editor.walkElements(e.elements, allElems::add);
        e.animations.forEach(ea -> {
            ResolvedData rd;
            int n = idc[0];
            idc[0] = n + 1;
            int id = n;
            if (id > 250) {
                idc[0] = 1;
                id = 0;
                ModelPartAnimation part = new ModelPartAnimation();
                part.parsedData = this.parsedData;
                this.parsedData = new HashMap<Integer, ResolvedData>();
                otherParts.add(part);
            }
            if (ea.pose instanceof VanillaPose) {
                rd = new ResolvedData((VanillaPose)ea.pose, ea.add);
            } else if (ea.pose != null) {
                rd = new ResolvedData(ea.pose, ea.add);
                if (ea.layerControlled) {
                    if (addedPoses.add((CustomPose)ea.pose)) {
                        int n2 = idc[1];
                        idc[1] = n2 + 1;
                        ModelPartAnimation.resolveEncID(rd, n2, allLayers);
                    } else {
                        rd.gid = -1;
                    }
                } else if (addedPoses.add((CustomPose)ea.pose)) {
                    notLayerControlled.add(rd);
                }
            } else {
                rd = new ResolvedData(AnimationsLoaderV1.encodeTypeInName(ea.getId(), ea.type), ea.loop, ea.add);
                if (ea.isLayer()) {
                    rd.defaultValue = (byte)(ea.layerDefault * 255.0f);
                }
                if (!ea.type.isStaged() && !ea.type.isLayer()) {
                    if (ea.layerControlled) {
                        if (addedGestures.add(rd.name)) {
                            int n3 = idc[1];
                            idc[1] = n3 + 1;
                            ModelPartAnimation.resolveEncID(rd, n3, allLayers);
                        } else {
                            rd.gid = -1;
                        }
                    } else if (addedGestures.add(rd.name)) {
                        notLayerControlled.add(rd);
                    }
                }
            }
            rd.gid &= valMask;
            rd.gid |= defMask;
            if (ea.type.isStaged() || ea.type.isLayer()) {
                rd.gid = -1;
            }
            this.parsedData.put(id, rd);
            List<ModelElement> elems = ea.getComponentsFiltered();
            List<AnimFrame> frames = ea.getFrames();
            int fc = frames.size();
            rd.frames = fc;
            int cs = elems.size();
            rd.duration = ea.duration;
            ResolvedData.access$502(rd, new int[cs]);
            ResolvedData.access$202(rd, new Vec3f[cs][]);
            ResolvedData.access$302(rd, new Vec3f[cs][]);
            ResolvedData.access$602(rd, new Vec3f[cs][]);
            ResolvedData.access$002(rd, new Vec3f[cs][]);
            ResolvedData.access$402(rd, new Boolean[cs][]);
            rd.loop = ea.loop;
            rd.priority = ea.priority;
            if (ea.type == AnimationType.VALUE_LAYER) {
                rd.maxValue = (byte)ea.maxValue;
                rd.interpolateVal = ea.interpolateValue;
            }
            if (ea.isCustom() && !ea.type.isStaged()) {
                rd.command = ea.command;
                if (!ea.command) {
                    rd.order = ea.order;
                }
                rd.buttonHidden = ea.hidden;
            }
            if (ea.isLayer() && !ea.command) {
                rd.isProperty = ea.isProperty;
            }
            if (ea.type == AnimationType.LAYER && ea.group != null && !ea.group.isEmpty() && !ea.command) {
                rd.group = ea.group;
            }
            rd.it = ea.intType;
            rd.finish = ea.mustFinish;
            for (int i = 0; i < cs; ++i) {
                ModelElement elem = elems.get(i);
                if (!allElems.contains(elem)) continue;
                ((ResolvedData)rd).components[i] = elem.id;
                if (frames.stream().anyMatch(f -> f.hasPosChanges(elem))) {
                    ((ResolvedData)rd).pos[i] = new Vec3f[fc];
                    ModelPartAnimation.fillArray(rd.pos[i], frames, elem, IElem::getPosition, ea.add, new Vec3f());
                }
                if (frames.stream().anyMatch(f -> f.hasRotChanges(elem))) {
                    ((ResolvedData)rd).rot[i] = new Vec3f[fc];
                    ModelPartAnimation.fillArray(rd.rot[i], frames, elem, IElem::getRotation, ea.add, new Vec3f());
                }
                if (frames.stream().anyMatch(f -> f.hasColorChanges(elem))) {
                    ((ResolvedData)rd).color[i] = new Vec3f[fc];
                    ModelPartAnimation.fillArray(rd.color[i], frames, elem, IElem::getColor, ea.add, new Vec3f());
                }
                if (frames.stream().anyMatch(f -> f.hasVisChanges(elem))) {
                    ((ResolvedData)rd).show[i] = new Boolean[fc];
                    ModelPartAnimation.fillArray(rd.show[i], frames, elem, IElem::isVisible, ea.add, !elem.hidden);
                }
                if (!frames.stream().anyMatch(f -> f.hasScaleChanges(elem))) continue;
                ((ResolvedData)rd).scale[i] = new Vec3f[fc];
                ModelPartAnimation.fillArray(rd.scale[i], frames, elem, IElem::getScale, ea.add, new Vec3f(1.0f, 1.0f, 1.0f));
            }
        });
        notLayerControlled.forEach(rd -> {
            int n = idc[1];
            idc[1] = n + 1;
            int n2 = n;
            if (n2 == this.resetId) {
                int n3 = idc[1];
                idc[1] = n3 + 1;
                n2 = n3;
            }
            ((ResolvedData)rd).gid = n2;
        });
    }

    private ModelPartAnimation() {
    }

    private static void resolveEncID(ResolvedData rd, int id, List<PlayerSkinLayer> allLayers) {
        if (allLayers.size() < 2) {
            throw new ExportException(new FormatText("error.cpm.custom_anims_not_supported", new Object[0]));
        }
        HashSet<PlayerSkinLayer> encL = new HashSet<PlayerSkinLayer>();
        for (int i = 0; i < allLayers.size(); ++i) {
            PlayerSkinLayer l = allLayers.get(i);
            if ((id & 1 << i) == 0) continue;
            encL.add(l);
        }
        if (encL.containsAll(allLayers)) {
            throw new ExportException(new FormatText("error.cpm.too_many_animations", new Object[0]));
        }
        rd.gid = PlayerSkinLayer.encode(encL);
        rd.layerCtrl = true;
    }

    private static <T> void fillArray(T[] array, List<AnimFrame> frames, ModelElement elem, Function<IElem, T> func, boolean add, T empty) {
        for (int i = 0; i < frames.size(); ++i) {
            AnimFrame frm = frames.get(i);
            IElem dt = frm.getData(elem);
            if (dt == null) {
                if (add) {
                    array[i] = empty;
                    continue;
                }
                array[i] = func.apply(elem);
                continue;
            }
            array[i] = func.apply(dt);
        }
    }

    @Override
    public IResolvedModelPart resolve() throws IOException {
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void write(IOHelper dout) throws IOException {
        for (Map.Entry<Integer, ResolvedData> entry : this.parsedData.entrySet()) {
            id = entry.getKey();
            dt = entry.getValue();
            if (ResolvedData.access$1400(dt) != null) {
                dout.writeEnum(Type.POSE);
                d = dout.writeNextBlock();
                try {
                    if (ResolvedData.access$1400(dt) instanceof VanillaPose) {
                        d.writeEnum((VanillaPose)ResolvedData.access$1400(dt));
                    } else {
                        d.writeEnum(VanillaPose.CUSTOM);
                    }
                    d.write(id);
                    flags = 0;
                    if (ResolvedData.access$2200(dt)) {
                        flags |= 1;
                    }
                    d.write(flags);
                    if (!(ResolvedData.access$1400(dt) instanceof CustomPose)) ** GOTO lbl40
                    d.writeUTF(((CustomPose)ResolvedData.access$1400(dt)).getId());
                }
                finally {
                    if (d != null) {
                        d.close();
                    }
                }
            } else {
                dout.writeEnum(Type.GESTURE);
                d = dout.writeNextBlock();
                try {
                    d.write(id);
                    d.writeUTF(ResolvedData.access$2300(dt));
                    flags = 0;
                    if (ResolvedData.access$2200(dt)) {
                        flags |= 1;
                    }
                    if (ResolvedData.access$2400(dt)) {
                        flags |= 2;
                    }
                    d.write(flags);
                }
                finally {
                    if (d != null) {
                        d.close();
                    }
                }
            }
            dout.writeEnum(Type.ANIMATION_INFO);
            d = dout.writeNextBlock();
            try {
                d.write(id);
                d.write(ResolvedData.access$500(dt).length);
                d.write(ResolvedData.access$100(dt));
                d.writeShort(ResolvedData.access$700(dt));
                for (i = 0; i < ResolvedData.access$500(dt).length; ++i) {
                    d.writeVarInt(ResolvedData.access$500(dt)[i]);
                }
            }
            finally {
                if (d != null) {
                    d.close();
                }
            }
            if (ResolvedData.access$800(dt) != -1) {
                dout.writeEnum(ResolvedData.access$900(dt) != false ? Type.ENCODING : Type.ANIMATION_DATA_ENC);
                d = dout.writeNextBlock();
                try {
                    d.write(id);
                    d.write(ResolvedData.access$800(dt));
                }
                finally {
                    if (d != null) {
                        d.close();
                    }
                }
            }
            for (i = 0; i < ResolvedData.access$500(dt).length; ++i) {
                if (ResolvedData.access$200(dt)[i] != null) {
                    dout.writeEnum(Type.ANIMATION_DATA_POS);
                    d = dout.writeNextBlock();
                    try {
                        d.write(id);
                        d.write(i);
                        for (f = 0; f < ResolvedData.access$100(dt); ++f) {
                            d.writeVec6b(ResolvedData.access$200(dt)[i][f]);
                        }
                    }
                    finally {
                        if (d != null) {
                            d.close();
                        }
                    }
                }
                if (ResolvedData.access$300(dt)[i] != null) {
                    dout.writeEnum(Type.ANIMATION_DATA_ROTATION);
                    d = dout.writeNextBlock();
                    try {
                        d.write(id);
                        d.write(i);
                        for (f = 0; f < ResolvedData.access$100(dt); ++f) {
                            d.writeAngle(ResolvedData.access$300(dt)[i][f]);
                        }
                    }
                    finally {
                        if (d != null) {
                            d.close();
                        }
                    }
                }
                if (ResolvedData.access$000(dt)[i] != null) {
                    dout.writeEnum(Type.ANIMATION_DATA_COLOR);
                    d = dout.writeNextBlock();
                    try {
                        d.write(id);
                        d.write(i);
                        for (f = 0; f < ResolvedData.access$100(dt); ++f) {
                            c = ResolvedData.access$000(dt)[i][f];
                            d.write((int)c.x);
                            d.write((int)c.y);
                            d.write((int)c.z);
                        }
                    }
                    finally {
                        if (d != null) {
                            d.close();
                        }
                    }
                }
                if (ResolvedData.access$400(dt)[i] != null) {
                    dout.writeEnum(Type.ANIMATION_DATA_VIS);
                    d = dout.writeNextBlock();
                    try {
                        d.write(id);
                        d.write(i);
                        for (f = 0; f < ResolvedData.access$100(dt); f += 8) {
                            flgs = 0;
                            for (j = 0; f + j < ResolvedData.access$100(dt) && j < 8; ++j) {
                                if (!ResolvedData.access$400(dt)[i][f + j].booleanValue()) continue;
                                flgs |= 1 << j;
                            }
                            d.write(flgs);
                        }
                    }
                    finally {
                        if (d != null) {
                            d.close();
                        }
                    }
                }
                if (ResolvedData.access$600(dt)[i] == null) continue;
                dout.writeEnum(Type.ANIMATION_DATA_SCALE);
                d = dout.writeNextBlock();
                try {
                    d.write(id);
                    d.write(i);
                    for (f = 0; f < ResolvedData.access$100(dt); ++f) {
                        d.writeVec6b(ResolvedData.access$600(dt)[i][f]);
                    }
                    continue;
                }
                finally {
                    if (d != null) {
                        d.close();
                    }
                }
            }
            if (ResolvedData.access$1000(dt) != 0) {
                dout.writeEnum(Type.ANIMATION_DATA_EXTRA);
                d = dout.writeNextBlock();
                try {
                    d.write(id);
                    d.writeByte(ResolvedData.access$1000(dt));
                }
                finally {
                    if (d != null) {
                        d.close();
                    }
                }
            }
            if (ResolvedData.access$1100(dt) != InterpolatorType.POLY_LOOP) {
                dout.writeEnum(Type.ANIMATION_DATA_INTERPOLATION);
                d = dout.writeNextBlock();
                try {
                    d.write(id);
                    d.writeEnum(ResolvedData.access$1100(dt));
                }
                finally {
                    if (d != null) {
                        d.close();
                    }
                }
            }
            if (ResolvedData.access$1200(dt) != 0) {
                dout.writeEnum(Type.ANIMATION_DATA_LAYER_DEFAULT);
                d = dout.writeNextBlock();
                try {
                    d.write(id);
                    d.writeByte(ResolvedData.access$1200(dt));
                }
                finally {
                    if (d != null) {
                        d.close();
                    }
                }
            }
            if (ResolvedData.access$1300(dt) != 0) {
                dout.writeEnum(Type.ANIMATION_DATA_ORDER);
                d = dout.writeNextBlock();
                try {
                    d.write(id);
                    d.writeByte(ResolvedData.access$1300(dt));
                }
                finally {
                    if (d != null) {
                        d.close();
                    }
                }
            }
            if (ResolvedData.access$1500(dt)) {
                dout.writeEnum(Type.ANIMATION_DATA_IS_PROPERTY);
                d = dout.writeNextBlock();
                try {
                    d.write(id);
                }
                finally {
                    if (d != null) {
                        d.close();
                    }
                }
            }
            if (ResolvedData.access$1600(dt) != null) {
                dout.writeEnum(Type.ANIMATION_DATA_GROUP);
                d = dout.writeNextBlock();
                try {
                    d.write(id);
                    d.writeUTF(ResolvedData.access$1600(dt));
                }
                finally {
                    if (d != null) {
                        d.close();
                    }
                }
            }
            if (ResolvedData.access$1700(dt)) {
                dout.writeEnum(Type.ANIMATION_DATA_COMMAND);
                d = dout.writeNextBlock();
                try {
                    d.write(id);
                }
                finally {
                    if (d != null) {
                        d.close();
                    }
                }
            }
            if (ResolvedData.access$1800(dt)) {
                dout.writeEnum(Type.ANIMATION_MUST_FINISH);
                d = dout.writeNextBlock();
                try {
                    d.write(id);
                }
                finally {
                    if (d != null) {
                        d.close();
                    }
                }
            }
            if (ResolvedData.access$2000(dt) != 0) {
                dout.writeEnum(Type.ANIMATION_SLIDER_OPT);
                d = dout.writeNextBlock();
                try {
                    d.write(id);
                    d.writeBoolean(ResolvedData.access$1900(dt));
                    d.writeByte(ResolvedData.access$2000(dt));
                }
                finally {
                    if (d != null) {
                        d.close();
                    }
                }
            }
            if (!ResolvedData.access$2100(dt)) continue;
            dout.writeEnum(Type.ANIMATION_BUTTON_HIDDEN);
            d = dout.writeNextBlock();
            try {
                d.write(id);
            }
            finally {
                if (d == null) continue;
                d.close();
            }
        }
        dout.writeEnum(Type.CTRL_IDS);
        d = dout.writeNextBlock();
        try {
            d.write(this.blankId);
            d.write(this.resetId);
        }
        finally {
            if (d != null) {
                d.close();
            }
        }
        if (this.modelProfilesId != null) {
            dout.writeEnum(Type.MODEL_PROFILES_ID);
            d = dout.writeNextBlock();
            try {
                d.writeUTF(this.modelProfilesId);
            }
            finally {
                if (d != null) {
                    d.close();
                }
            }
        }
        dout.writeEnum(Type.END);
    }

    @Override
    public void apply(ModelDefinition def) {
        this.parsedData.values().forEach(rd -> {
            IModelComponent[] comp = new IModelComponent[((ResolvedData)rd).components.length];
            for (int i = 0; i < comp.length; ++i) {
                comp[i] = def.getElementById(((ResolvedData)rd).components[i]);
            }
            float[][][] data = new float[((ResolvedData)rd).components.length][InterpolatorChannel.VALUES.length][((ResolvedData)rd).frames];
            for (int i = 0; i < comp.length; ++i) {
                Vec3f[] pos = ((ResolvedData)rd).pos[i];
                Vec3f[] rot = ((ResolvedData)rd).rot[i];
                Vec3f[] scale = ((ResolvedData)rd).scale[i];
                Vec3f[] color = ((ResolvedData)rd).color[i];
                float[][] dt = data[i];
                IModelComponent c = comp[i];
                for (int f = 0; f < ((ResolvedData)rd).frames; ++f) {
                    if (pos != null) {
                        dt[0][f] = pos[f].x;
                        dt[1][f] = pos[f].y;
                        dt[2][f] = pos[f].z;
                    } else if (!((ResolvedData)rd).add) {
                        dt[0][f] = c.getPosition().x;
                        dt[1][f] = c.getPosition().y;
                        dt[2][f] = c.getPosition().z;
                    }
                    if (rot != null) {
                        dt[3][f] = rot[f].x;
                        dt[4][f] = rot[f].y;
                        dt[5][f] = rot[f].z;
                    } else if (!((ResolvedData)rd).add) {
                        dt[3][f] = c.getRotation().x;
                        dt[4][f] = c.getRotation().y;
                        dt[5][f] = c.getRotation().z;
                    }
                    if (color != null) {
                        dt[6][f] = color[f].x;
                        dt[7][f] = color[f].y;
                        dt[8][f] = color[f].z;
                    } else if (c.getRGB() != -1) {
                        dt[6][f] = (c.getRGB() & 0xFF0000) >> 16;
                        dt[7][f] = (c.getRGB() & 0xFF00) >> 8;
                        dt[8][f] = c.getRGB() & 0xFF;
                    }
                    if (scale != null) {
                        dt[9][f] = scale[f].x;
                        dt[10][f] = scale[f].y;
                        dt[11][f] = scale[f].z;
                        continue;
                    }
                    if (((ResolvedData)rd).add) continue;
                    dt[9][f] = 1.0f;
                    dt[10][f] = 1.0f;
                    dt[11][f] = 1.0f;
                }
                if (((ResolvedData)rd).show[i] != null) continue;
                ((ResolvedData)rd).show[i] = new Boolean[((ResolvedData)rd).frames];
                Arrays.fill(((ResolvedData)rd).show[i], (Object)c.isVisible());
            }
            if (rd.dynamicProgress()) {
                ((ResolvedData)rd).duration = 1001;
            }
            ((ResolvedData)rd).anim = new Animation(comp, data, ((ResolvedData)rd).show, ((ResolvedData)rd).duration, ((ResolvedData)rd).priority, ((ResolvedData)rd).add, ((ResolvedData)rd).it);
        });
        AnimationRegistry reg = def.getAnimations();
        LegacyAnimationParser state = reg.getLegacyParser(def);
        this.parsedData.values().forEach(rd -> {
            if (((ResolvedData)rd).pose instanceof VanillaPose) {
                state.addPose(((ResolvedData)rd).pose, ((ResolvedData)rd).anim, ((ResolvedData)rd).finish);
            } else if (((ResolvedData)rd).name != null) {
                state.gestures.computeIfAbsent(((ResolvedData)rd).name, k -> {
                    ArrayList<IAnimation> l = new ArrayList<IAnimation>();
                    LegacyAnimationParser.Gesture g = new LegacyAnimationParser.Gesture(AnimationsLoaderV1.getType(((ResolvedData)rd).name), l, AnimationsLoaderV1.cleanName(((ResolvedData)rd).name), ((ResolvedData)rd).loop, ((ResolvedData)rd).order, ((ResolvedData)rd).finish);
                    g.defVal = ((ResolvedData)rd).defaultValue;
                    g.isProperty = ((ResolvedData)rd).isProperty;
                    g.group = ((ResolvedData)rd).group;
                    g.command = ((ResolvedData)rd).command;
                    g.layerCtrl = ((ResolvedData)rd).layerCtrl;
                    g.maxValue = ((ResolvedData)rd).maxValue;
                    g.interpolateVal = ((ResolvedData)rd).interpolateVal;
                    g.hidden = ((ResolvedData)rd).buttonHidden;
                    state.addGesture(g, ((ResolvedData)rd).gid);
                    return l;
                }).add(((ResolvedData)rd).anim);
            } else {
                state.addPose(((ResolvedData)rd).pose, ((ResolvedData)rd).anim, ((ResolvedData)rd).finish);
                CustomPose cp = (CustomPose)((ResolvedData)rd).pose;
                LegacyAnimationParser.Pose p = new LegacyAnimationParser.Pose(cp);
                p.hidden = ((ResolvedData)rd).buttonHidden;
                cp.command = ((ResolvedData)rd).command;
                cp.layerCtrl = ((ResolvedData)rd).layerCtrl;
                state.addCustomPose(p, ((ResolvedData)rd).gid);
            }
        });
        reg.setBlankGesture(this.blankId);
        reg.setPoseResetId(this.resetId);
        reg.setProfileId(this.modelProfilesId);
    }

    @Override
    public ModelPartType getType() {
        return ModelPartType.ANIMATION_DATA;
    }

    public String toString() {
        StringBuilder bb = new StringBuilder("Animations:");
        for (ResolvedData r : this.parsedData.values()) {
            bb.append("\n\t");
            bb.append(r.toString().replace("\n", "\n\t\t"));
        }
        return bb.toString();
    }

    public static enum Type {
        END,
        POSE,
        GESTURE,
        ANIMATION_DATA_ROTATION,
        ANIMATION_DATA_POS,
        ANIMATION_DATA_VIS,
        ANIMATION_DATA_COLOR,
        ANIMATION_INFO,
        ENCODING,
        CTRL_IDS,
        ANIMATION_DATA_EXTRA,
        ANIMATION_DATA_INTERPOLATION,
        ANIMATION_DATA_SCALE,
        ANIMATION_DATA_LAYER_DEFAULT,
        ANIMATION_DATA_ORDER,
        ANIMATION_DATA_IS_PROPERTY,
        ANIMATION_DATA_GROUP,
        MODEL_PROFILES_ID,
        ANIMATION_DATA_COMMAND,
        ANIMATION_DATA_ENC,
        ANIMATION_MUST_FINISH,
        ANIMATION_SLIDER_OPT,
        ANIMATION_BUTTON_HIDDEN;

        public static final Type[] VALUES;

        static {
            VALUES = Type.values();
        }
    }

    private static class ResolvedData {
        private IPose pose;
        private int gid = -1;
        private String name;
        private int[] components;
        private Vec3f[][] pos;
        private Vec3f[][] rot;
        private Vec3f[][] scale;
        private Vec3f[][] color;
        private Boolean[][] show;
        private int frames;
        private int duration;
        private Animation anim;
        private boolean loop;
        private boolean add;
        private int priority;
        private InterpolatorType it = InterpolatorType.POLY_LOOP;
        private byte defaultValue;
        private int order;
        private boolean isProperty;
        private String group;
        private boolean command;
        private boolean layerCtrl;
        private boolean finish;
        private byte maxValue;
        private boolean interpolateVal;
        private boolean buttonHidden;

        public ResolvedData(VanillaPose pose, boolean add) {
            this.pose = pose;
            this.add = add;
        }

        public ResolvedData(IPose pose, boolean add) {
            this.pose = pose;
            this.add = add;
        }

        public ResolvedData(String name, boolean loop, boolean add) {
            this.name = name;
            this.loop = loop;
            this.add = add;
        }

        public String toString() {
            StringBuilder bb = new StringBuilder("Animation: ");
            if (this.pose != null) {
                bb.append(this.pose);
            } else {
                bb.append(this.name);
            }
            bb.append("\n\tAdd: ");
            bb.append(this.add);
            bb.append("\n\tLoop: ");
            bb.append(this.loop);
            bb.append("\n\tFrame Count: ");
            bb.append(this.frames);
            bb.append("\n\tDuration: ");
            bb.append(this.duration);
            bb.append("ms\n\tComponents: ");
            bb.append(this.components.length);
            bb.append("\n\t\t");
            bb.append(Arrays.toString(this.components));
            bb.append("\n\tPriority: ");
            bb.append(this.priority);
            bb.append("\n\tColorValues: \n\t\t[");
            for (Object[] objectArray : this.color) {
                bb.append(Arrays.toString(objectArray));
                bb.append(", ");
            }
            bb.append("]");
            bb.append("\n\tVisValues: \n\t\t[");
            for (Object[] objectArray : this.show) {
                bb.append(Arrays.toString(objectArray));
                bb.append(", ");
            }
            bb.append("]");
            return bb.toString();
        }

        public boolean dynamicProgress() {
            return this.pose instanceof VanillaPose && ((VanillaPose)this.pose).hasStateGetter();
        }

        static /* synthetic */ int[] access$502(ResolvedData x0, int[] x1) {
            x0.components = x1;
            return x1;
        }

        static /* synthetic */ Vec3f[][] access$202(ResolvedData x0, Vec3f[][] x1) {
            x0.pos = x1;
            return x1;
        }

        static /* synthetic */ Vec3f[][] access$302(ResolvedData x0, Vec3f[][] x1) {
            x0.rot = x1;
            return x1;
        }

        static /* synthetic */ Vec3f[][] access$602(ResolvedData x0, Vec3f[][] x1) {
            x0.scale = x1;
            return x1;
        }

        static /* synthetic */ Vec3f[][] access$002(ResolvedData x0, Vec3f[][] x1) {
            x0.color = x1;
            return x1;
        }

        static /* synthetic */ Boolean[][] access$402(ResolvedData x0, Boolean[][] x1) {
            x0.show = x1;
            return x1;
        }
    }
}

