/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.item;

import com.tom.cpl.nbt.MappedNBTCompound;
import com.tom.cpl.nbt.NBTTagCompound;

public abstract class NbtMapper<T, C, L, N> {
    public abstract long getLong(N var1);

    public abstract int getInt(N var1);

    public abstract short getShort(N var1);

    public abstract byte getByte(N var1);

    public abstract double getDouble(N var1);

    public abstract float getFloat(N var1);

    public abstract String getString(T var1);

    public abstract T getTag(C var1, String var2);

    public abstract N asNumber(T var1);

    public abstract L asList(T var1);

    public abstract C asCompound(T var1);

    public abstract int listSize(L var1);

    public abstract T getAt(L var1, int var2);

    public abstract boolean contains(C var1, String var2, int var3);

    public abstract C newCompound();

    public abstract L newList();

    public abstract Iterable<String> keys(C var1);

    public abstract int getId(T var1);

    public abstract byte[] getByteArray(T var1);

    public abstract int[] getIntArray(T var1);

    public abstract long[] getLongArray(T var1);

    public byte getByte(C tag, String name) {
        if (this.contains(tag, name, 99)) {
            N n = this.asNumber(this.getTag(tag, name));
            return n != null ? this.getByte(n) : (byte)0;
        }
        return 0;
    }

    public short getShort(C tag, String name) {
        if (this.contains(tag, name, 99)) {
            N n = this.asNumber(this.getTag(tag, name));
            return n != null ? this.getShort(n) : (short)0;
        }
        return 0;
    }

    public int getInt(C tag, String name) {
        if (this.contains(tag, name, 99)) {
            N n = this.asNumber(this.getTag(tag, name));
            return n != null ? this.getInt(n) : 0;
        }
        return 0;
    }

    public long getLong(C tag, String name) {
        if (this.contains(tag, name, 99)) {
            N n = this.asNumber(this.getTag(tag, name));
            return n != null ? this.getLong(n) : 0L;
        }
        return 0L;
    }

    public float getFloat(C tag, String name) {
        if (this.contains(tag, name, 99)) {
            N n = this.asNumber(this.getTag(tag, name));
            return n != null ? this.getFloat(n) : 0.0f;
        }
        return 0.0f;
    }

    public double getDouble(C tag, String name) {
        if (this.contains(tag, name, 99)) {
            N n = this.asNumber(this.getTag(tag, name));
            return n != null ? this.getDouble(n) : 0.0;
        }
        return 0.0;
    }

    public String getString(C tag, String name) {
        if (this.contains(tag, name, 8)) {
            return this.getString(this.getTag(tag, name));
        }
        return "";
    }

    public C getCompoundTag(C tag, String name) {
        C c;
        if (this.contains(tag, name, 10) && (c = this.asCompound(this.getTag(tag, name))) != null) {
            return c;
        }
        return this.newCompound();
    }

    public L getListTag(C tag, String name) {
        L c;
        if (this.contains(tag, name, 9) && (c = this.asList(this.getTag(tag, name))) != null) {
            return c;
        }
        return this.newList();
    }

    public byte getByteAt(L list, int i) {
        if (i >= 0 && i < this.listSize(list)) {
            N n = this.asNumber(this.getAt(list, i));
            return n != null ? this.getByte(n) : (byte)0;
        }
        return 0;
    }

    public short getShortAt(L list, int i) {
        if (i >= 0 && i < this.listSize(list)) {
            N n = this.asNumber(this.getAt(list, i));
            return n != null ? this.getShort(n) : (short)0;
        }
        return 0;
    }

    public int getIntAt(L list, int i) {
        if (i >= 0 && i < this.listSize(list)) {
            N n = this.asNumber(this.getAt(list, i));
            return n != null ? this.getInt(n) : 0;
        }
        return 0;
    }

    public long getLongAt(L list, int i) {
        if (i >= 0 && i < this.listSize(list)) {
            N n = this.asNumber(this.getAt(list, i));
            return n != null ? this.getLong(n) : 0L;
        }
        return 0L;
    }

    public float getFloatAt(L list, int i) {
        if (i >= 0 && i < this.listSize(list)) {
            N n = this.asNumber(this.getAt(list, i));
            return n != null ? this.getFloat(n) : 0.0f;
        }
        return 0.0f;
    }

    public double getDoubleAt(L list, int i) {
        if (i >= 0 && i < this.listSize(list)) {
            N n = this.asNumber(this.getAt(list, i));
            return n != null ? this.getDouble(n) : 0.0;
        }
        return 0.0;
    }

    public String getStringAt(L list, int i) {
        if (i >= 0 && i < this.listSize(list)) {
            return this.getString(this.getAt(list, i));
        }
        return "";
    }

    public C getCompoundTagAt(L list, int i) {
        C c;
        if (i >= 0 && i < this.listSize(list) && (c = this.asCompound(this.getAt(list, i))) != null) {
            return c;
        }
        return this.newCompound();
    }

    public L getListTagAt(L list, int i) {
        L c;
        if (i >= 0 && i < this.listSize(list) && (c = this.asList(this.getAt(list, i))) != null) {
            return c;
        }
        return this.newList();
    }

    public NBTTagCompound wrap(C tag) {
        return new MappedNBTCompound<C>(this, tag);
    }
}

