/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.tag.TagManager;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.util.ErrorLog;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class CPMTagLoader
extends SimplePreparableReloadListener<Map<String, List<Map<String, Object>>>> {
    private final TagManager<?> tags;
    protected final String prefix;
    protected final ResourceLocation id;

    public CPMTagLoader(Consumer<CPMTagLoader> mc, TagManager<?> tags, String prefix) {
        this.tags = tags;
        this.prefix = prefix;
        this.id = ResourceLocation.tryBuild((String)"cpm", (String)("tags_" + prefix));
        mc.accept(this);
    }

    protected Map<String, List<Map<String, Object>>> prepare(ResourceManager mngr, ProfilerFiller profiler) {
        return this.load(mngr);
    }

    protected void apply(Map<String, List<Map<String, Object>>> tagMap, ResourceManager mngr, ProfilerFiller profiler) {
        this.tags.applyBuiltin(tagMap, this.prefix);
    }

    private Map<String, List<Map<String, Object>>> load(ResourceManager mngr) {
        HashMap<String, List<Map<String, Object>>> el = new HashMap<String, List<Map<String, Object>>>();
        mngr.listResourceStacks("cpm_tags/" + this.prefix, l -> l.getPath().endsWith(".json")).forEach((rl, rs) -> {
            ArrayList res = new ArrayList();
            el.put(rl.getNamespace() + ":" + rl.getPath().substring(9, rl.getPath().length() - 5), res);
            rs.forEach(r -> {
                try (BufferedReader rd = r.openAsReader();){
                    Map tag = (Map)MinecraftObjectHolder.gson.fromJson((Reader)rd, Object.class);
                    res.add(tag);
                }
                catch (Exception e) {
                    ErrorLog.addLog(ErrorLog.LogLevel.WARNING, "Failed to load cpm builtin tag: " + String.valueOf(rl), e);
                }
            });
        });
        return el;
    }
}

