/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerCapeModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class CapeTransformUtil {
    public static void applyTransform(HumanoidModel<AvatarRenderState> model) {
        if (model instanceof PlayerCapeModel) {
            PlayerCapeModel m = (PlayerCapeModel)model;
            m.cape.loadPose(CapeTransformUtil.combine(model.body.storePose(), m.cape.storePose()));
        }
    }

    public static PartPose combine(PartPose first, PartPose second) {
        Matrix4f transformA = new Matrix4f().translate(first.x(), first.y(), first.z()).rotateZYX(first.zRot(), first.yRot(), first.xRot()).scale(first.xScale(), first.yScale(), first.zScale());
        Matrix4f transformB = new Matrix4f().translate(second.x(), second.y(), second.z()).rotateZYX(second.zRot(), second.yRot(), second.xRot()).scale(second.xScale(), second.yScale(), second.zScale());
        transformA.mul((Matrix4fc)transformB);
        Vector3f translation = transformA.getTranslation(new Vector3f());
        Vector3f scale = transformA.getScale(new Vector3f());
        Quaternionf rotation = transformA.getUnnormalizedRotation(new Quaternionf());
        Vector3f eulerAngles = rotation.getEulerAnglesZYX(new Vector3f());
        return new PartPose(translation.x, translation.y, translation.z, eulerAngles.x, eulerAngles.y, eulerAngles.z, scale.x, scale.y, scale.z);
    }
}

