/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.tom.cpm.CustomPlayerModels;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.client.IrisPipelineSetup;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.Platform;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.client.PlayerRenderStateAccess;
import com.tom.cpm.common.ByteArrayPayload;
import com.tom.cpm.common.PlayerAnimUpdater;
import com.tom.cpm.mixinplugin.IrisDetector;
import com.tom.cpm.mixinplugin.OFDetector;
import com.tom.cpm.shared.model.RenderManager;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.Log;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public abstract class ClientBase {
    public static final ResourceLocation DEFAULT_CAPE = ResourceLocation.parse((String)"cpm:textures/template/cape.png");
    public static boolean optifineLoaded;
    public static boolean irisLoaded;
    public static boolean vrLoaded;
    public static MinecraftObject mc;
    public RenderManager<GameProfile, Avatar, Model, Void> manager;
    public NetHandler<CustomPacketPayload.Type<ByteArrayPayload>, Avatar, ClientPacketListener> netHandler;

    public void init0() {
        mc = new MinecraftObject();
        optifineLoaded = OFDetector.doApply();
        vrLoaded = Platform.isModLoaded("vivecraft");
        irisLoaded = IrisDetector.doApply();
        if (optifineLoaded) {
            Log.info("Optifine detected, enabling optifine compatibility");
        }
        if (vrLoaded) {
            Log.info("ViveCraft detected, enabling ViveCraft compatibility");
        }
        if (irisLoaded) {
            Log.info("Iris detected, enabling iris compatibility");
        }
    }

    public void init1() {
        this.manager = new RenderManager<GameProfile, Avatar, Model, Void>(mc.getPlayerRenderManager(), mc.getDefinitionLoader(), PlayerProfile::getPlayerProfile);
        this.manager.setGPGetters(GameProfile::properties, Property::value);
        this.netHandler = new NetHandler((k, v) -> new CustomPacketPayload.Type(ResourceLocation.tryBuild((String)k, (String)v)));
        this.netHandler.setExecutor(Minecraft::getInstance);
        this.netHandler.setSendPacketClient(Function.identity(), (c, rl, pb) -> c.send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new ByteArrayPayload((CustomPacketPayload.Type<ByteArrayPayload>)rl, (byte[])pb))));
        this.netHandler.setPlayerToLoader(PlayerProfile::getPlayerProfile);
        this.netHandler.setGetPlayerById(id -> {
            Entity ent = Minecraft.getInstance().level.getEntity(id);
            if (ent instanceof Avatar) {
                Avatar a = (Avatar)ent;
                return a;
            }
            return null;
        });
        this.netHandler.setGetClient(() -> Minecraft.getInstance().player);
        this.netHandler.setGetNet(c -> ((LocalPlayer)c).connection);
        this.netHandler.setDisplayText(t -> Minecraft.getInstance().player.displayClientMessage((Component)t.remap(), false));
        this.netHandler.setGetPlayerAnimGetters(new PlayerAnimUpdater());
        if (irisLoaded) {
            IrisPipelineSetup.setup();
        }
    }

    public static void apiInit() {
        CustomPlayerModels.api.buildClient().voicePlayer(Player.class, Entity::getUUID).localModelApi(GameProfile::new).init();
    }

    public void playerRenderPre(PlayerRenderStateAccess sa, PlayerModel model, AvatarRenderState renderState) {
        CustomPlayerModelsClient.INSTANCE.manager.bindPlayerState(sa.cpm$getPlayer(), null, model, null);
        model.setupAnim(renderState);
        mc.getPlayerRenderManager().setModelPose(model);
    }

    public void playerRenderPost(PlayerModel model) {
        this.manager.unbindClear((Model)model);
    }

    public void renderHand(PlayerModel model) {
        this.renderHand((AbstractClientPlayer)Minecraft.getInstance().player, model);
    }

    public void renderHand(AbstractClientPlayer pl, PlayerModel model) {
        this.manager.bindHand((Avatar)pl, null, (Model)model);
    }

    public void renderHandPost(HumanoidModel model) {
        this.manager.unbindClear((Model)model);
    }

    public void renderElytra(HumanoidModel<HumanoidRenderState> player, ElytraModel model) {
        this.manager.bindElytra((Model)player, (Model)model);
    }

    public void renderArmor(ArmorModelSet<HumanoidModel<HumanoidRenderState>> modelSet, HumanoidModel<HumanoidRenderState> player) {
        this.manager.bindArmor((Model)player, (Model)modelSet.head(), 1);
        this.manager.bindArmor((Model)player, (Model)modelSet.legs(), 2);
        this.manager.bindArmor((Model)player, (Model)modelSet.chest(), 3);
        this.manager.bindArmor((Model)player, (Model)modelSet.feet(), 4);
    }

    public void updateJump() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player.onGround() && minecraft.player.input.keyPresses.jump()) {
            this.manager.jump((Avatar)minecraft.player);
        }
    }
}

