/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.brigadier.CommandDispatcher;
import com.tom.cpl.tag.AllTagManagers;
import com.tom.cpm.client.CPMTagLoader;
import com.tom.cpm.client.ClientBase;
import com.tom.cpm.client.GuiGraphicsEx;
import com.tom.cpm.client.GuiImpl;
import com.tom.cpm.client.KeyBindings;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.client.PlayerRenderStateAccess;
import com.tom.cpm.common.Command;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.gui.GestureGui;
import com.tom.cpm.shared.gui.SettingsGui;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.options.SkinCustomizationScreen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterPictureInPictureRendererEvent;
import net.minecraftforge.client.event.RenderAvatarEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class CustomPlayerModelsClient
extends ClientBase {
    public static final CustomPlayerModelsClient INSTANCE = new CustomPlayerModelsClient();

    public void preInit(FMLJavaModLoadingContext ctx) {
        this.init0();
        RegisterKeyMappingsEvent.BUS.addListener(KeyBindings::init);
        RegisterClientReloadListenersEvent.BUS.addListener(INSTANCE::registerReloadListeners);
        RegisterPictureInPictureRendererEvent.BUS.addListener(INSTANCE::registerPip);
        ctx.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, scr) -> new GuiImpl(SettingsGui::new, (Screen)scr)));
    }

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.init1();
    }

    @SubscribeEvent
    public void playerRenderPre(RenderAvatarEvent.Pre event) {
        PlayerRenderStateAccess sa = (PlayerRenderStateAccess)event.getState();
        if (sa.cpm$getPlayer() != null) {
            this.playerRenderPre(sa, (PlayerModel)event.getRenderer().getModel(), event.getState());
        }
    }

    @SubscribeEvent(priority=-128)
    public void playerRenderPreC(RenderAvatarEvent.Pre event, boolean cancelled) {
        if (cancelled) {
            this.playerRenderPost((PlayerModel)event.getRenderer().getModel());
        }
    }

    @SubscribeEvent
    public void playerRenderPost(RenderAvatarEvent.Post event) {
        this.playerRenderPost((PlayerModel)event.getRenderer().getModel());
    }

    @SubscribeEvent
    public void initGui(ScreenEvent.Init.Post evt) {
        if (evt.getScreen() instanceof TitleScreen && ModConfig.getCommonConfig().getSetBoolean("titleScreenButton", true) || evt.getScreen() instanceof SkinCustomizationScreen) {
            Screen screen = evt.getScreen();
            Button btn = Button.builder((Component)Component.translatable((String)"button.cpm.open_editor"), b -> Minecraft.getInstance().setScreen((Screen)new GuiImpl(EditorGui::new, screen))).bounds(0, 0, 100, 20).build();
            evt.addListener((GuiEventListener)btn);
            evt.getScreen().children().add(btn);
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent.Pre evt) {
        mc.getPlayerRenderManager().getAnimationEngine().update(evt.timer().getGameTimeDeltaPartialTick(true));
    }

    @SubscribeEvent
    public void clientTickPre(TickEvent.ClientTickEvent.Pre evt) {
        if (!Minecraft.getInstance().isPaused()) {
            mc.getPlayerRenderManager().getAnimationEngine().tick();
        }
    }

    @SubscribeEvent
    public void clientTickPost(TickEvent.ClientTickEvent.Post evt) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        if (KeyBindings.gestureMenuBinding.consumeClick()) {
            Minecraft.getInstance().setScreen((Screen)new GuiImpl(GestureGui::new, null));
        }
        if (KeyBindings.renderToggleBinding.consumeClick()) {
            Player.setEnableRendering(!Player.isEnableRendering());
        }
        mc.getPlayerRenderManager().getAnimationEngine().updateKeys(KeyBindings.quickAccess);
    }

    @SubscribeEvent
    public void openGui(ScreenEvent.Opening openGui) {
        if (openGui.getScreen() instanceof TitleScreen && EditorGui.doOpenEditor()) {
            openGui.setNewScreen((Screen)new GuiImpl(EditorGui::new, openGui.getScreen()));
        }
    }

    @SubscribeEvent
    public void drawGuiPre(ScreenEvent.Render.Pre evt) {
        PlayerProfile.inGui = true;
    }

    @SubscribeEvent
    public void drawGuiPost(ScreenEvent.Render.Post evt) {
        PlayerProfile.inGui = false;
    }

    @SubscribeEvent
    public void onLogout(ClientPlayerNetworkEvent.LoggingOut evt) {
        mc.onLogOut();
    }

    @SubscribeEvent
    public void registerClientCommands(RegisterClientCommandsEvent event) {
        new Command((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), true);
    }

    private void registerReloadListeners(RegisterClientReloadListenersEvent event) {
        mc.setTags(new AllTagManagers(arg_0 -> ((RegisterClientReloadListenersEvent)event).registerReloadListener(arg_0), CPMTagLoader::new));
    }

    private void registerPip(final RegisterPictureInPictureRendererEvent event) {
        GuiGraphicsEx.registerPictureInPictureRenderers(new GuiGraphicsEx.RegistrationHandler(){

            @Override
            public <T extends PictureInPictureRenderState> void register(Class<T> stateClass, Function<MultiBufferSource.BufferSource, PictureInPictureRenderer<T>> factory) {
                event.register(factory.apply(event.getBufferSource()));
            }
        });
    }
}

