/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.tom.cpl.gui.IKeybind;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpm.client.GuiImpl;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;

public class KeyBindings
implements IKeybind {
    public static KeyMapping.Category category;
    private static KeyConflictCtx conflictCtx;
    public static KeyMapping gestureMenuBinding;
    public static KeyMapping renderToggleBinding;
    public static IKeybind[] quickAccess;
    public static List<IKeybind> kbs;
    private final KeyMapping kb;
    private final String name;

    public static void init(RegisterKeyMappingsEvent evt) {
        category = KeyMapping.Category.register((ResourceLocation)ResourceLocation.tryBuild((String)"cpm", (String)"keys"));
        gestureMenuBinding = new KeyMapping("key.cpm.gestureMenu", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM.getOrCreate(72), category);
        renderToggleBinding = new KeyMapping("key.cpm.renderToggle", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, category);
        kbs.add(new KeyBindings(gestureMenuBinding, "gestureMenu", evt));
        kbs.add(new KeyBindings(renderToggleBinding, "renderToggle", evt));
        for (int i = 1; i <= 16; ++i) {
            KeyBindings.createQA(i, evt);
        }
    }

    private static void createQA(int id, RegisterKeyMappingsEvent evt) {
        KeyMapping kb = new KeyMapping("key.cpm.qa_" + id, (IKeyConflictContext)conflictCtx, InputConstants.UNKNOWN, category);
        KeyBindings kbs = new KeyBindings(kb, "qa_" + id, evt);
        KeyBindings.kbs.add(kbs);
        KeyBindings.quickAccess[id - 1] = kbs;
    }

    private KeyBindings(KeyMapping kb, String name, RegisterKeyMappingsEvent evt) {
        this.kb = kb;
        this.name = name;
        evt.register(kb);
    }

    @Override
    public boolean isPressed(KeyboardEvent evt) {
        InputConstants.Key mouseKey = InputConstants.getKey((KeyEvent)new KeyEvent(evt.keyCode, evt.scancode, 0));
        return this.kb.isActiveAndMatches(mouseKey);
    }

    @Override
    public String getBoundKey() {
        return this.kb.getTranslatedKeyMessage().getString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isPressed() {
        return this.kb.isDown();
    }

    static {
        conflictCtx = new KeyConflictCtx();
        quickAccess = new IKeybind[16];
        kbs = new ArrayList<IKeybind>();
    }

    private static class KeyConflictCtx
    implements IKeyConflictContext {
        private KeyConflictCtx() {
        }

        public boolean isActive() {
            Minecraft mc = Minecraft.getInstance();
            return mc.screen instanceof GuiImpl || !KeyConflictContext.GUI.isActive() && mc.player != null;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return other == this || other == KeyConflictContext.IN_GAME;
        }
    }
}

