/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.NativeImage;
import com.tom.cpl.block.BiomeHandler;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.IKeybind;
import com.tom.cpl.render.RenderTypeBuilder;
import com.tom.cpl.tag.AllTagManagers;
import com.tom.cpl.util.DynamicTexture;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ImageIO;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.client.CustomRenderTypes;
import com.tom.cpm.client.GuiImpl;
import com.tom.cpm.client.KeyBindings;
import com.tom.cpm.client.NativeImageIO;
import com.tom.cpm.client.Platform;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.client.PlayerRenderManager;
import com.tom.cpm.common.BiomeHandlerImpl;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.render.RenderMode;
import com.tom.cpm.shared.network.ModelEventType;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.MojangAPI;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.player.PlayerModelPart;

public class MinecraftObject
implements MinecraftClientAccess {
    private final ModelDefinitionLoader<GameProfile> loader;
    private final PlayerRenderManager prm;
    private AllTagManagers tags;
    public RenderTypeBuilder<ResourceLocation, RenderType> renderBuilder;

    public MinecraftObject() {
        MinecraftObjectHolder.setClientObject(this);
        this.loader = new ModelDefinitionLoader<GameProfile>(PlayerProfile::new, GameProfile::id, GameProfile::name);
        this.prm = new PlayerRenderManager();
        this.renderBuilder = new RenderTypeBuilder();
        this.renderBuilder.register(RenderMode.DEFAULT, RenderType::entityTranslucent, 0);
        this.renderBuilder.register(RenderMode.GLOW, CustomRenderTypes::glowingEyes, 1);
        this.renderBuilder.register(RenderMode.COLOR, CustomRenderTypes::entityColorTranslucent, 0);
        this.renderBuilder.register(RenderMode.COLOR_GLOW, CustomRenderTypes::entityColorEyes, 1);
        this.renderBuilder.register(RenderMode.OUTLINE, CustomRenderTypes::linesNoDepth, 2);
    }

    public void setTags(AllTagManagers tags) {
        this.tags = tags;
    }

    @Override
    public PlayerRenderManager getPlayerRenderManager() {
        return this.prm;
    }

    @Override
    public DynamicTexture.ITexture createTexture() {
        return new DynTexture();
    }

    @Override
    public void executeOnGameThread(Runnable r) {
        Minecraft.getInstance().execute(r);
    }

    @Override
    public void executeNextFrame(Runnable r) {
        Minecraft.getInstance().schedule(r);
    }

    @Override
    public ModelDefinitionLoader<GameProfile> getDefinitionLoader() {
        return this.loader;
    }

    @Override
    public SkinType getSkinType() {
        return SkinType.get(DefaultPlayerSkin.get((UUID)Minecraft.getInstance().getUser().getProfileId()).model().getSerializedName());
    }

    @Override
    public void setEncodedGesture(int value) {
        Set s = Minecraft.getInstance().options.modelParts;
        MinecraftObject.setEncPart(s, value, 0, PlayerModelPart.HAT);
        MinecraftObject.setEncPart(s, value, 1, PlayerModelPart.JACKET);
        MinecraftObject.setEncPart(s, value, 2, PlayerModelPart.LEFT_PANTS_LEG);
        MinecraftObject.setEncPart(s, value, 3, PlayerModelPart.RIGHT_PANTS_LEG);
        MinecraftObject.setEncPart(s, value, 4, PlayerModelPart.LEFT_SLEEVE);
        MinecraftObject.setEncPart(s, value, 5, PlayerModelPart.RIGHT_SLEEVE);
        Minecraft.getInstance().options.broadcastOptions();
    }

    private static void setEncPart(Set<PlayerModelPart> s, int value, int off, PlayerModelPart part) {
        if ((value & 1 << off) != 0) {
            s.add(part);
        } else {
            s.remove(part);
        }
    }

    @Override
    public boolean isInGame() {
        return Minecraft.getInstance().player != null;
    }

    @Override
    public Object getPlayerIDObject() {
        return Minecraft.getInstance().getGameProfile();
    }

    @Override
    public Object getCurrentPlayerIDObject() {
        Minecraft mc = Minecraft.getInstance();
        return PlayerProfile.getPlayerProfile((Avatar)mc.player);
    }

    @Override
    public List<IKeybind> getKeybinds() {
        return KeyBindings.kbs;
    }

    @Override
    public MinecraftClientAccess.ServerStatus getServerSideStatus() {
        Minecraft mc = Minecraft.getInstance();
        ClientPacketListener conn = mc.getConnection();
        return mc.player != null ? (conn instanceof NetH && ((NetH)conn).cpm$hasMod() ? MinecraftClientAccess.ServerStatus.INSTALLED : MinecraftClientAccess.ServerStatus.SKIN_LAYERS_ONLY) : MinecraftClientAccess.ServerStatus.OFFLINE;
    }

    @Override
    public File getGameDir() {
        return Minecraft.getInstance().gameDirectory;
    }

    @Override
    public void openGui(Function<IGui, Frame> creator) {
        Minecraft mc = Minecraft.getInstance();
        mc.setScreen((Screen)new GuiImpl(creator, mc.screen));
    }

    @Override
    public Runnable openSingleplayer() {
        Minecraft mc = Minecraft.getInstance();
        return () -> mc.setScreen((Screen)new SelectWorldScreen(mc.screen));
    }

    @Override
    public NetHandler<?, ?, ?> getNetHandler() {
        return CustomPlayerModelsClient.INSTANCE.netHandler;
    }

    @Override
    public ImageIO.IImageIO getImageIO() {
        return new NativeImageIO();
    }

    @Override
    public MojangAPI getMojangAPI() {
        Minecraft mc = Minecraft.getInstance();
        return new MojangAPI(mc.getUser().getName(), mc.getUser().getProfileId(), mc.getUser().getAccessToken());
    }

    @Override
    public void clearSkinCache() {
        MojangAPI.clearYggdrasilCache(Minecraft.getInstance().services().sessionService());
    }

    @Override
    public String getConnectedServer() {
        if (Minecraft.getInstance().getConnection() == null) {
            return null;
        }
        SocketAddress sa = Platform.getChannel(Minecraft.getInstance().getConnection().getConnection()).remoteAddress();
        if (sa instanceof InetSocketAddress) {
            return ((InetSocketAddress)sa).getHostString();
        }
        return null;
    }

    @Override
    public List<Object> getPlayers() {
        if (Minecraft.getInstance().getConnection() == null) {
            return Collections.emptyList();
        }
        return Minecraft.getInstance().getConnection().getOnlinePlayers().stream().map(PlayerInfo::getProfile).collect(Collectors.toList());
    }

    @Override
    public Proxy getProxy() {
        return Minecraft.getInstance().getProxy();
    }

    @Override
    public RenderTypeBuilder<?, ?> getRenderBuilder() {
        return this.renderBuilder;
    }

    @Override
    public AllTagManagers getBuiltinTags() {
        return this.tags;
    }

    @Override
    public BiomeHandler<?> getBiomeHandler() {
        return BiomeHandlerImpl.clientImpl;
    }

    @Override
    public boolean requiresSelfEventForAnimation(ModelEventType type) {
        return type == ModelEventType.FALLING;
    }

    public static class DynTexture
    implements DynamicTexture.ITexture {
        private static int ID = 0;
        private DynamicTexture dynTex;
        private ResourceLocation loc;
        private static ResourceLocation bound_loc;
        private Minecraft mc = Minecraft.getInstance();

        @Override
        public void bind() {
            if (this.loc == null) {
                return;
            }
            bound_loc = this.loc;
            if (this.mc.getTextureManager().getTexture(this.loc) == null) {
                this.mc.getTextureManager().register(this.loc, (AbstractTexture)this.dynTex);
            }
        }

        @Override
        public void load(Image texture) {
            if (this.loc == null || this.dynTex.getTexture().getWidth(0) != texture.getWidth() || this.dynTex.getTexture().getHeight(0) != texture.getHeight()) {
                if (this.loc != null) {
                    this.mc.getTextureManager().release(this.loc);
                }
                int id = ID++;
                this.dynTex = new DynamicTexture("CPM Dynamic Texture #" + id, texture.getWidth(), texture.getHeight(), true);
                this.loc = ResourceLocation.fromNamespaceAndPath((String)"cpm", (String)("dyn_" + id));
                this.mc.getTextureManager().register(this.loc, (AbstractTexture)this.dynTex);
            }
            NativeImage ni = NativeImageIO.createFromBufferedImage(texture);
            this.dynTex.setPixels(ni);
            this.dynTex.upload();
        }

        public static ResourceLocation getBoundLoc() {
            return bound_loc;
        }

        @Override
        public void free() {
            if (this.loc != null) {
                this.mc.getTextureManager().release(this.loc);
            }
        }
    }
}

