/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpm.shared.animation.ServerAnimationState;
import java.util.function.BiConsumer;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.player.Player;

public class PlayerAnimUpdater
implements BiConsumer<Avatar, ServerAnimationState> {
    @Override
    public void accept(Avatar t, ServerAnimationState u) {
        u.updated = true;
        u.falling = (float)t.fallDistance;
        u.health = t.getHealth() / t.getMaxHealth();
        u.air = Math.max((float)t.getAirSupply() / (float)t.getMaxAirSupply(), 0.0f);
        if (t instanceof Player) {
            Player p = (Player)t;
            u.creativeFlying = p.getAbilities().flying;
            u.hunger = (float)p.getFoodData().getFoodLevel() / 20.0f;
            u.inMenu = p.containerMenu != p.inventoryMenu;
        } else {
            u.creativeFlying = false;
            u.hunger = 1.0f;
            u.inMenu = false;
        }
    }
}

