/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.render;

import com.tom.cpl.render.VertexBuffer;
import java.util.ArrayList;
import java.util.List;

public class RecordBuffer
implements VertexBuffer {
    private List<Entry> toReplay = new ArrayList<Entry>();
    private Entry entry = new Entry();

    @Override
    public VertexBuffer pos(float x, float y, float z) {
        this.entry.x = x;
        this.entry.y = y;
        this.entry.z = z;
        return this;
    }

    @Override
    public VertexBuffer color(float red, float green, float blue, float alpha) {
        this.entry.red = red;
        this.entry.green = green;
        this.entry.blue = blue;
        this.entry.alpha = alpha;
        return this;
    }

    @Override
    public VertexBuffer tex(float u, float v) {
        this.entry.u = u;
        this.entry.v = v;
        return this;
    }

    @Override
    public VertexBuffer normal(float x, float y, float z) {
        this.entry.nx = x;
        this.entry.ny = y;
        this.entry.nz = z;
        return this;
    }

    @Override
    public void endVertex() {
        this.toReplay.add(this.entry);
        this.entry = new Entry();
    }

    @Override
    public void finish() {
    }

    public void replay(VertexBuffer to) {
        if (!this.toReplay.isEmpty()) {
            for (Entry entry : this.toReplay) {
                entry.replay(to);
            }
        }
    }

    private static class Entry {
        private float x;
        private float y;
        private float z;
        private float red;
        private float green;
        private float blue;
        private float alpha;
        private float u;
        private float v;
        private float nx;
        private float ny;
        private float nz;

        private Entry() {
        }

        public void replay(VertexBuffer parent) {
            parent.addVertex(this.x, this.y, this.z, this.red, this.green, this.blue, this.alpha, this.u, this.v, this.nx, this.ny, this.nz);
        }
    }
}

