/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.tag.TagManager;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.util.ErrorLog;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CPMTagLoader {
    private static final List<String> DOMAINS = Arrays.asList("cpm");
    private final TagManager<?> tags;
    private final String prefix;

    public CPMTagLoader(Void mngr, TagManager<?> tags, String prefix) {
        this.tags = tags;
        this.prefix = prefix;
        tags.applyBuiltin(this.load(), prefix);
    }

    private Map<String, List<Map<String, Object>>> load() {
        HashMap<String, List<Map<String, Object>>> el = new HashMap<String, List<Map<String, Object>>>();
        HashSet allEntries = new HashSet();
        DOMAINS.forEach(d -> {
            String rl = "/assets/" + d + "/cpm_tags/dictionary.json";
            try {
                InputStream is = CPMTagLoader.class.getResourceAsStream(rl);
                if (is == null) {
                    return;
                }
                try (InputStream inputstream = is;
                     BufferedReader rd = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                    Map tag = (Map)MinecraftObjectHolder.gson.fromJson((Reader)rd, Object.class);
                    List entries = (List)tag.get(this.prefix);
                    if (entries != null) {
                        for (String e : entries) {
                            allEntries.add(d + ":cpm_tags/" + this.prefix + "/" + e + ".json");
                        }
                    }
                }
                catch (Exception e) {
                    ErrorLog.addLog(ErrorLog.LogLevel.WARNING, "Failed to load cpm tag dictionary: " + rl, e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        allEntries.forEach(rl -> {
            ArrayList<Map> res = new ArrayList<Map>();
            String[] sp = rl.split(":");
            el.put(sp[0] + ":" + sp[1].substring(9, sp[1].length() - 5), res);
            try {
                InputStream is = CPMTagLoader.class.getResourceAsStream("/assets/" + sp[0] + "/" + sp[1]);
                if (is == null) {
                    return;
                }
                try (InputStream inputstream = is;
                     BufferedReader rd = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                    Map tag = (Map)MinecraftObjectHolder.gson.fromJson((Reader)rd, Object.class);
                    res.add(tag);
                }
            }
            catch (Exception e) {
                ErrorLog.addLog(ErrorLog.LogLevel.WARNING, "Failed to load cpm builtin tag: " + rl, e);
            }
        });
        return el;
    }
}

