/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyCodes;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.NativeGuiComponents;
import com.tom.cpl.gui.UIColors;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.item.Stack;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.text.IText;
import com.tom.cpl.util.AWTChooser;
import com.tom.cpm.client.LWJGLKeyCodes;
import com.tom.cpm.client.Lang;
import com.tom.cpm.client.Panel3dImpl;
import com.tom.cpm.client.RetroGL;
import com.tom.cpm.common.ItemStackHandlerImpl;
import com.tom.cpm.shared.MinecraftCommonAccess;
import com.tom.cpm.shared.gui.panel.Panel3d;
import com.tom.cpm.shared.util.Log;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_181;
import net.minecraft.class_211;
import net.minecraft.class_31;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_34;
import net.minecraft.class_564;
import net.minecraft.class_583;
import net.minecraft.class_629;
import net.minecraft.class_67;
import net.minecraft.class_92;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiImpl
extends class_32
implements IGui {
    private static final KeyCodes CODES = new LWJGLKeyCodes();
    private static final NativeGuiComponents nativeComponents = new NativeGuiComponents();
    protected static class_92 itemRenderer = new class_92();
    private Frame gui;
    private class_32 parent;
    private IGui.CtxStack stack;
    private UIColors colors = new UIColors();
    private Consumer<Runnable> closeListener;
    private int vanillaScale = -1;
    private int eventButton = 0;
    private long dragStart = 0L;

    public GuiImpl(Function<IGui, Frame> creator, class_32 parent) {
        this.parent = parent;
        try {
            this.gui = creator.apply(this);
        }
        catch (Throwable e) {
            this.onGuiException("Error creating gui", e, true);
        }
    }

    private static <G extends Supplier<IGui>, N> NativeGuiComponents.NativeConstructor<G, N> local(Function<GuiImpl, N> fac) {
        return f -> fac.apply((GuiImpl)f.get());
    }

    public boolean method_121() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_118(int mouseX, int mouseY, float partialTicks) {
        this.method_134();
        try {
            GL11.glEnable((int)3089);
            this.stack = new IGui.CtxStack(this.field_152, this.field_153);
            this.gui.draw(mouseX, mouseY, partialTicks);
        }
        catch (Throwable e) {
            this.onGuiException("Error drawing gui", e, true);
        }
        finally {
            GL11.glDisable((int)3089);
            Object s = "Minecraft b1.7.3 (babric) " + MinecraftCommonAccess.get().getModVersion();
            this.field_156.method_1906((String)s, this.field_152 - this.field_156.method_1901((String)s) - 4, 2, -16777216);
            s = this.field_151.field_2775;
            this.field_156.method_1906((String)s, this.field_152 - this.field_156.method_1901((String)s) - 4, 11, -16777216);
        }
    }

    public void method_133() {
        Keyboard.enableRepeatEvents((boolean)false);
        if (this.vanillaScale != -1 && this.vanillaScale != this.field_151.field_2824.field_1450) {
            this.field_151.field_2824.field_1450 = this.vanillaScale;
        }
        if (this.parent != null) {
            class_32 p = this.parent;
            this.parent = null;
            this.field_151.method_2112(p);
        }
    }

    @Override
    public void drawBox(int x, int y, int w, int h, int color) {
        GuiImpl.drawRect(x += this.getOffset().x, y += this.getOffset().y, x + w, y + h, color);
    }

    public void method_119() {
        Keyboard.enableRepeatEvents((boolean)true);
        try {
            this.gui.init(this.field_152, this.field_153);
        }
        catch (Throwable e) {
            this.onGuiException("Error in init gui", e, true);
        }
    }

    @Override
    public void drawText(int x, int y, String text, int color) {
        this.field_156.method_1906(text, x += this.getOffset().x, y += this.getOffset().y, color);
    }

    protected void method_117(char typedChar, int keyCode) {
        try {
            KeyboardEvent evt = new KeyboardEvent(keyCode, 0, typedChar, Keyboard.getKeyName((int)keyCode));
            this.gui.keyPressed(evt);
            if (!evt.isConsumed() && this.field_151.field_2806 != null && this.field_151.field_2824.field_1475.field_2381 == keyCode) {
                this.field_151.method_2112((class_32)new Overlay());
            }
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
        }
    }

    protected void method_124(int mouseX, int mouseY, int mouseButton) {
        try {
            this.gui.mouseClick(new MouseEvent(mouseX, mouseY, mouseButton));
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
        }
    }

    protected void func_85041_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        try {
            this.gui.mouseDrag(new MouseEvent(mouseX, mouseY, clickedMouseButton));
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
        }
    }

    protected void mouseMovedOrUp(int mouseX, int mouseY, int state) {
        if (state == -1) {
            return;
        }
        try {
            this.gui.mouseRelease(new MouseEvent(mouseX, mouseY, state));
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
        }
    }

    public void method_131() {
        int var1 = Mouse.getEventX() * this.field_152 / this.field_151.field_2802;
        int var2 = this.field_153 - Mouse.getEventY() * this.field_153 / this.field_151.field_2803 - 1;
        if (Mouse.getEventButtonState()) {
            this.eventButton = Mouse.getEventButton();
            this.dragStart = System.currentTimeMillis();
            this.method_124(var1, var2, this.eventButton);
        } else if (Mouse.getEventButton() != -1) {
            this.eventButton = -1;
            this.mouseMovedOrUp(var1, var2, Mouse.getEventButton());
        } else if (this.eventButton != -1 && this.dragStart > 0L) {
            long var3 = System.currentTimeMillis() - this.dragStart;
            this.func_85041_a(var1, var2, this.eventButton, var3);
        }
        int i = Mouse.getEventDWheel();
        if (i > 0) {
            i = 1;
        }
        if (i < 0) {
            i = -1;
        }
        if (i != 0) {
            try {
                int x = Mouse.getEventX() * this.field_152 / this.field_151.field_2802;
                int y = this.field_153 - Mouse.getEventY() * this.field_153 / this.field_151.field_2803 - 1;
                this.gui.mouseWheel(new MouseEvent(x, y, i));
            }
            catch (Throwable e) {
                this.onGuiException("Error processing mouse event", e, false);
            }
        }
    }

    @Override
    public void displayError(final String e) {
        final class_32 p = this.parent;
        this.parent = null;
        this.field_151.method_2112(new class_32(){
            private class_32 parent;
            private String message1;
            private String message2;
            {
                this.parent = p;
                this.message1 = "Custom Player Models";
                this.message2 = Lang.format("error.cpm.crash", e);
            }

            public void method_119() {
                super.method_119();
                this.field_154.add(new class_33(0, this.field_152 / 2 - 100, 140, Lang.format("gui.cancel", new Object[0])));
            }

            protected void method_117(char typedChar, int keyCode) {
            }

            public void method_118(int par1, int par2, float par3) {
                GuiImpl.drawGradientRect(0, 0, this.field_152, this.field_153, -12574688, -11530224, 0.0);
                this.method_1934(this.field_156, this.message1, this.field_152 / 2, 90, 0xFFFFFF);
                this.method_1934(this.field_156, this.message2, this.field_152 / 2, 110, 0xFFFFFF);
                super.method_118(par1, par2, par3);
            }

            public void method_133() {
                if (this.parent != null) {
                    class_32 p2 = this.parent;
                    this.parent = null;
                    this.field_151.method_2112(p2);
                }
            }

            protected void method_120(class_33 button) {
                this.field_151.method_2112((class_32)null);
            }
        });
    }

    @Override
    public void closeGui() {
        if (this.closeListener != null) {
            this.closeListener.accept(() -> this.field_151.method_2112((class_32)null));
        } else {
            this.field_151.method_2112((class_32)null);
        }
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture) {
        this.field_151.field_2814.method_1097(this.field_151.field_2814.method_1100("/assets/cpm/textures/gui/" + texture + ".png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.method_1936(x += this.getOffset().x, y += this.getOffset().y, u, v, w, h);
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture, int color) {
        this.field_151.field_2814.method_1097(this.field_151.field_2814.method_1100("/assets/cpm/textures/gui/" + texture + ".png"));
        x += this.getOffset().x;
        y += this.getOffset().y;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        this.method_1936(x, y, u, v, w, h);
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float u1, float v1, float u2, float v2) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_67 t = class_67.field_2054;
        t.method_1695();
        t.method_1688((double)(x += this.getOffset().x), (double)((y += this.getOffset().y) + height), 0.0, (double)u1, (double)v2);
        t.method_1688((double)(x + width), (double)(y + height), 0.0, (double)u2, (double)v2);
        t.method_1688((double)(x + width), (double)y, 0.0, (double)u2, (double)v1);
        t.method_1688((double)x, (double)y, 0.0, (double)u1, (double)v1);
        t.method_1685();
    }

    @Override
    public String i18nFormat(String key, Object ... obj) {
        return Lang.format(key, obj);
    }

    @Override
    public void setupCut() {
        float multiplierX = (float)this.field_151.field_2802 / (float)this.field_152;
        float multiplierY = (float)this.field_151.field_2803 / (float)this.field_153;
        Box box = this.getContext().cutBox;
        GL11.glScissor((int)((int)((float)box.x * multiplierX)), (int)(this.field_151.field_2803 - (int)((float)(box.y + box.h) * multiplierY)), (int)((int)((float)box.w * multiplierX)), (int)((int)((float)box.h * multiplierY)));
    }

    @Override
    public int textWidth(String text) {
        return this.field_156.method_1901(text);
    }

    private TextField.ITextField createTextField() {
        return new TxtField();
    }

    @Override
    public UIColors getColors() {
        return this.colors;
    }

    @Override
    public void setCloseListener(Consumer<Runnable> listener) {
        this.closeListener = listener;
    }

    @Override
    public boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    @Override
    public boolean isCtrlDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    @Override
    public boolean isAltDown() {
        return false;
    }

    @Override
    public KeyCodes getKeyCodes() {
        return CODES;
    }

    @Override
    public void drawGradientBox(int x, int y, int w, int h, int topLeft, int topRight, int bottomLeft, int bottomRight) {
        int left = x;
        int top = y;
        int right = x + w;
        int bottom = y + h;
        float atr = (float)(topRight >> 24 & 0xFF) / 255.0f;
        float rtr = (float)(topRight >> 16 & 0xFF) / 255.0f;
        float gtr = (float)(topRight >> 8 & 0xFF) / 255.0f;
        float btr = (float)(topRight & 0xFF) / 255.0f;
        float atl = (float)(topLeft >> 24 & 0xFF) / 255.0f;
        float rtl = (float)(topLeft >> 16 & 0xFF) / 255.0f;
        float gtl = (float)(topLeft >> 8 & 0xFF) / 255.0f;
        float btl = (float)(topLeft & 0xFF) / 255.0f;
        float abl = (float)(bottomLeft >> 24 & 0xFF) / 255.0f;
        float rbl = (float)(bottomLeft >> 16 & 0xFF) / 255.0f;
        float gbl = (float)(bottomLeft >> 8 & 0xFF) / 255.0f;
        float bbl = (float)(bottomLeft & 0xFF) / 255.0f;
        float abr = (float)(bottomRight >> 24 & 0xFF) / 255.0f;
        float rbr = (float)(bottomRight >> 16 & 0xFF) / 255.0f;
        float gbr = (float)(bottomRight >> 8 & 0xFF) / 255.0f;
        float bbr = (float)(bottomRight & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        RetroGL.glBlendFunc(770, 771, 1, 0);
        GL11.glShadeModel((int)7425);
        RetroGL.RetroTessellator t = RetroGL.tessellator;
        t.begin(7);
        t.pos(right, top, this.field_2522).color(rtr, gtr, btr, atr, false).endVertex();
        t.pos(left, top, this.field_2522).color(rtl, gtl, btl, atl, false).endVertex();
        t.pos(left, bottom, this.field_2522).color(rbl, gbl, bbl, abl, false).endVertex();
        t.pos(right, bottom, this.field_2522).color(rbr, gbr, bbr, abr, false).endVertex();
        t.draw();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    @Override
    public NativeGuiComponents getNative() {
        return nativeComponents;
    }

    @Override
    public void setClipboardText(String text) {
        try {
            StringSelection var1 = new StringSelection(text);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(var1, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Frame getFrame() {
        return this.gui;
    }

    @Override
    public String getClipboardText() {
        return GuiImpl.method_129();
    }

    @Override
    public void setScale(int value) {
        if (value != this.field_151.field_2824.field_1450) {
            if (this.vanillaScale == -1) {
                this.vanillaScale = this.field_151.field_2824.field_1450;
            }
            if (value == -1) {
                if (this.field_151.field_2824.field_1450 != this.vanillaScale) {
                    this.field_151.field_2824.field_1450 = this.vanillaScale;
                    this.vanillaScale = -1;
                    class_564 scaledresolution = new class_564(this.field_151.field_2824, this.field_151.field_2802, this.field_151.field_2803);
                    int j = scaledresolution.method_1857();
                    int k = scaledresolution.method_1858();
                    this.method_125(this.field_151, j, k);
                }
            } else {
                this.field_151.field_2824.field_1450 = value;
                class_564 scaledresolution = new class_564(this.field_151.field_2824, this.field_151.field_2802, this.field_151.field_2803);
                int j = scaledresolution.method_1857();
                int k = scaledresolution.method_1858();
                this.method_125(this.field_151, j, k);
            }
        }
    }

    @Override
    public int getScale() {
        return this.field_151.field_2824.field_1450;
    }

    @Override
    public int getMaxScale() {
        return 4;
    }

    @Override
    public IGui.CtxStack getStack() {
        return this.stack;
    }

    public void method_122() {
        try {
            this.gui.tick();
        }
        catch (Throwable e) {
            this.onGuiException("Error in tick gui", e, true);
        }
    }

    @Override
    public void drawFormattedText(float x, float y, IText text, int color, float scale) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(x += (float)this.getOffset().x), (float)(y += (float)this.getOffset().y), (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.field_156.method_1906((String)text.remap(), 0, 0, color);
        GL11.glPopMatrix();
    }

    @Override
    public int textWidthFormatted(IText text) {
        return this.field_156.method_1901((String)text.remap());
    }

    @Override
    public void openURL0(String url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, new URI(url));
        }
        catch (Throwable throwable1) {
            Throwable throwable = throwable1.getCause();
            Log.error("Couldn't open link: " + (throwable == null ? "<UNKNOWN>" : throwable.getMessage()));
        }
    }

    public void onOpened() {
        this.vanillaScale = -1;
    }

    @Override
    public void drawStack(int x, int y, Stack stack) {
        x += this.getOffset().x;
        y += this.getOffset().y;
        class_31 s = (class_31)ItemStackHandlerImpl.impl.unwrap(stack);
        GL11.glEnable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
        GL11.glPushMatrix();
        GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        class_583.method_1930();
        GL11.glPopMatrix();
        itemRenderer.method_1487(this.field_156, this.field_151.field_2814, s, x, y);
        itemRenderer.method_1488(this.field_156, this.field_151.field_2814, s, x, y);
        GL11.glDisable((int)2929);
        GL11.glPopMatrix();
    }

    @Override
    public void drawStackTooltip(int mx, int my, Stack stack) {
        class_31 s = (class_31)ItemStackHandlerImpl.impl.unwrap(stack);
        this.drawItemStackTooltip(s, mx, my);
    }

    protected void drawItemStackTooltip(class_31 par1ItemStack, int par2, int par3) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(class_629.method_2049((String)(par1ItemStack.method_726() + ".name")));
        this.drawHoveringText(list, par2, par3, this.field_156);
    }

    protected void drawHoveringText(List<String> par1List, int par2, int par3, class_34 font) {
        if (!par1List.isEmpty()) {
            int j1;
            GL11.glDisable((int)32826);
            class_583.method_1927();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : par1List) {
                j1 = font.method_1901(s);
                if (j1 <= k) continue;
                k = j1;
            }
            int i1 = par2 + 12;
            j1 = par3 - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            if (i1 + k > this.field_152) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.field_153) {
                j1 = this.field_153 - k1 - 6;
            }
            this.field_2522 = 300.0f;
            int l1 = -267386864;
            this.drawGradientRect(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.drawGradientRect(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.drawGradientRect(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.drawGradientRect(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.drawGradientRect(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.drawGradientRect(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.drawGradientRect(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.drawGradientRect(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.drawGradientRect(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = par1List.get(k2);
                font.method_1903(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_2522 = 0.0f;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            class_583.method_1930();
            GL11.glEnable((int)32826);
        }
    }

    public static void drawRect(int var0, int var1, int var2, int var3, int var4) {
        int var5;
        if (var0 < var2) {
            var5 = var0;
            var0 = var2;
            var2 = var5;
        }
        if (var1 < var3) {
            var5 = var1;
            var1 = var3;
            var3 = var5;
        }
        float var10 = (float)(var4 >> 24 & 0xFF) / 255.0f;
        float var6 = (float)(var4 >> 16 & 0xFF) / 255.0f;
        float var7 = (float)(var4 >> 8 & 0xFF) / 255.0f;
        float var8 = (float)(var4 & 0xFF) / 255.0f;
        class_67 var9 = class_67.field_2054;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)var6, (float)var7, (float)var8, (float)var10);
        var9.method_1695();
        var9.method_1687((double)var0, (double)var3, 0.0);
        var9.method_1687((double)var2, (double)var3, 0.0);
        var9.method_1687((double)var2, (double)var1, 0.0);
        var9.method_1687((double)var0, (double)var1, 0.0);
        var9.method_1685();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    protected void drawGradientRect(int var1, int var2, int var3, int var4, int var5, int var6) {
        GuiImpl.drawGradientRect(var1, var2, var3, var4, var5, var6, this.field_2522);
    }

    protected static void drawGradientRect(int var1, int var2, int var3, int var4, int var5, int var6, double z) {
        float var7 = (float)(var5 >> 24 & 0xFF) / 255.0f;
        float var8 = (float)(var5 >> 16 & 0xFF) / 255.0f;
        float var9 = (float)(var5 >> 8 & 0xFF) / 255.0f;
        float var10 = (float)(var5 & 0xFF) / 255.0f;
        float var11 = (float)(var6 >> 24 & 0xFF) / 255.0f;
        float var12 = (float)(var6 >> 16 & 0xFF) / 255.0f;
        float var13 = (float)(var6 >> 8 & 0xFF) / 255.0f;
        float var14 = (float)(var6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        class_67 var15 = class_67.field_2054;
        var15.method_1695();
        var15.method_1690(var8, var9, var10, var7);
        var15.method_1687((double)var3, (double)var2, z);
        var15.method_1687((double)var1, (double)var2, z);
        var15.method_1690(var12, var13, var14, var11);
        var15.method_1687((double)var1, (double)var4, z);
        var15.method_1687((double)var3, (double)var4, z);
        var15.method_1685();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    static {
        nativeComponents.register(TextField.class, GuiImpl.local(GuiImpl::createTextField));
        nativeComponents.register(FileChooserPopup.class, AWTChooser::new);
        nativeComponents.register(Panel3d.class, Panel3dImpl::new);
    }

    public class Overlay
    extends class_211 {
        public void method_118(int mouseX, int mouseY, float partialTicks) {
            GuiImpl.this.method_118(Integer.MIN_VALUE, Integer.MIN_VALUE, partialTicks);
            super.method_118(mouseX, mouseY, partialTicks);
        }

        public class_32 getGui() {
            return GuiImpl.this;
        }
    }

    private class TxtField
    implements TextField.ITextField {
        private class_181 field;
        private Runnable eventListener;
        private Vec2i currentOff = new Vec2i(0, 0);
        private Box bounds = new Box(0, 0, 0, 0);
        private boolean refreshTextBox;

        public TxtField() {
            this.field = new class_181(GuiImpl.this, GuiImpl.this.field_156, 0, 0, 0, 0, ""){

                public void method_1883() {
                    if (this.field_2421) {
                        boolean var1 = this.field_2420 && this.field_2429 / 6 % 2 == 0;
                        this.method_1937(this.field_2422, this.method_1876() + (var1 ? "_" : ""), this.field_2423 + 4, this.field_2424 + (this.field_2426 - 8) / 2, GuiImpl.this.colors.label_text_color);
                    } else {
                        this.method_1937(this.field_2422, this.method_1876(), this.field_2423 + 4, this.field_2424 + (this.field_2426 - 8) / 2, 0x707070);
                    }
                }
            };
            this.field.method_1878(0x100000);
        }

        @Override
        public void draw(int mouseX, int mouseY, float partialTicks, Box bounds) {
            Vec2i off = GuiImpl.this.getOffset();
            this.field.field_2423 = bounds.x + off.x + 4;
            this.field.field_2424 = bounds.y + off.y + 6;
            this.currentOff.x = off.x;
            this.currentOff.y = off.y;
            this.bounds.x = bounds.x;
            this.bounds.y = bounds.y;
            this.bounds.w = bounds.w;
            this.bounds.h = bounds.h;
            this.field.field_2425 = bounds.w - 5;
            this.field.field_2426 = bounds.h - 12;
            if (this.refreshTextBox) {
                this.refreshTextBox = false;
            }
            this.field.method_1883();
        }

        @Override
        public void keyPressed(KeyboardEvent e) {
            if (e.isConsumed()) {
                return;
            }
            String text = this.field.method_1876();
            if (this.field.field_2421 && this.field.field_2420) {
                if (e.charTyped == '\t') {
                    return;
                }
                this.field.method_1877(e.charTyped, e.keyCode);
                e.consume();
                if (this.eventListener != null && !text.equals(this.field.method_1876())) {
                    this.eventListener.run();
                }
            }
        }

        @Override
        public void mouseClick(MouseEvent e) {
            if (e.isConsumed()) {
                this.field.method_1879(Integer.MIN_VALUE, Integer.MIN_VALUE, e.btn);
                return;
            }
            this.field.field_2423 = this.bounds.x + this.currentOff.x;
            this.field.field_2424 = this.bounds.y + this.currentOff.y;
            this.field.field_2425 = this.bounds.w;
            this.field.field_2426 = this.bounds.h;
            this.field.method_1879(e.x + this.currentOff.x, e.y + this.currentOff.y, e.btn);
            if (this.bounds.isInBounds(e.x, e.y)) {
                e.consume();
            }
        }

        @Override
        public String getText() {
            return this.field.method_1876();
        }

        @Override
        public void setText(String txt) {
            this.field.method_1880(txt);
            this.refreshTextBox = true;
        }

        @Override
        public void setEventListener(Runnable eventListener) {
            this.eventListener = eventListener;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.field.field_2421 = enabled;
        }

        @Override
        public boolean isFocused() {
            return this.field.field_2420;
        }

        @Override
        public void setFocused(boolean focused) {
            this.field.method_1881(focused);
        }

        @Override
        public int getCursorPos() {
            return 0;
        }

        @Override
        public void setCursorPos(int pos) {
        }

        @Override
        public void setSelectionPos(int pos) {
        }

        @Override
        public int getSelectionPos() {
            return 0;
        }
    }
}

