/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.util.Hand;
import com.tom.cpm.common.EntityTypeHandlerImpl;
import com.tom.cpm.common.PlayerInventory;
import com.tom.cpm.common.WorldImpl;
import com.tom.cpm.retro.GameProfile;
import com.tom.cpm.retro.GameProfileManager;
import com.tom.cpm.retro.NetHandlerExt;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.render.PlayerModelSetup;
import com.tom.cpm.shared.skin.PlayerTextureLoader;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_87;

public class PlayerProfile
extends Player<class_54>
implements NetHandlerExt.IPlayerProfile {
    public static boolean inGui;
    private final GameProfile profile;
    public int encGesture;

    public PlayerProfile(GameProfile profile) {
        this.profile = new GameProfile(profile.getId(), profile.getName());
    }

    @Override
    public SkinType getSkinType() {
        return SkinType.DEFAULT;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.profile == null ? 0 : this.profile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlayerProfile other = (PlayerProfile)obj;
        return !(this.profile == null ? other.profile != null : !this.profile.equals(other.profile));
    }

    @Override
    protected PlayerTextureLoader initTextures() {
        return new PlayerTextureLoader(){

            @Override
            protected CompletableFuture<Void> load0() {
                return GameProfileManager.getProfileFuture(PlayerProfile.this.profile.getName()).thenAccept(gp -> this.defineAll(gp.getTextureURLMap(), f -> f));
            }
        };
    }

    @Override
    public UUID getUUID() {
        return this.profile.getId();
    }

    @Override
    public void updateFromPlayer(class_54 player) {
        this.animState.resetPlayer();
        if (player.method_943()) {
            this.animState.sleeping = true;
        }
        if (player.field_1630) {
            this.animState.dying = true;
        }
        if (player.method_1360()) {
            this.animState.riding = true;
        }
        if (player.method_1373()) {
            this.animState.sneaking = true;
        }
        if (player.method_1334()) {
            this.animState.retroSwimming = true;
        }
        this.animState.moveAmountX = this.round(player.field_1600 - player.field_1597);
        this.animState.moveAmountY = this.round(player.field_1601 - player.field_1598);
        this.animState.moveAmountZ = this.round(player.field_1602 - player.field_1599);
        this.animState.yaw = player.field_1606 * 2.0f - player.field_1012;
        this.animState.pitch = player.field_1607;
        this.animState.bodyYaw = player.field_1012;
        this.animState.encodedState = this.encGesture;
        this.animState.wearingHelm = player.field_519.field_746[3] != null;
        this.animState.wearingBody = player.field_519.field_746[2] != null;
        this.animState.wearingLegs = player.field_519.field_746[1] != null;
        this.animState.wearingBoots = player.field_519.field_746[0] != null;
        this.animState.activeHand = this.animState.mainHand = Hand.RIGHT;
        this.animState.hurtTime = player.field_1038;
        this.animState.isOnLadder = player.method_932();
        this.animState.isBurning = player.method_1359();
        this.animState.inGui = inGui;
        PlayerInventory.setInv(this.animState, player.field_519);
        WorldImpl.setWorld(this.animState, (class_57)player);
        if (player.field_1595 != null) {
            this.animState.vehicle = EntityTypeHandlerImpl.impl.wrap(player.field_1595.getClass());
        }
    }

    private float round(double d) {
        return Math.abs(d) < 0.01 ? 0.0f : (float)d;
    }

    @Override
    public void updateFromModel(Object model) {
        if (model instanceof class_87) {
            class_87 m = (class_87)model;
            this.animState.resetModel();
            this.animState.attackTime = m.field_1427;
            this.animState.leftArm = PlayerModelSetup.ArmPose.EMPTY;
            if (m.field_629) {
                this.animState.rightArm = PlayerModelSetup.ArmPose.ITEM;
            }
            if (m.field_628) {
                this.animState.leftArm = PlayerModelSetup.ArmPose.ITEM;
            }
        }
    }

    @Override
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public Object getGameProfile() {
        return this.profile;
    }

    @Override
    public void setEncGesture(int g) {
        this.encGesture = g;
    }
}

