/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.VBuffers;
import com.tom.cpm.client.RetroGL;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.render.ModelRenderManager;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.retro.RedirectHolderRetro;
import java.util.function.Supplier;
import net.minecraft.class_163;
import net.minecraft.class_173;
import net.minecraft.class_87;
import org.lwjgl.opengl.GL11;

public class PlayerRenderManager
extends ModelRenderManager<Void, Void, class_163, class_173> {
    private static final float scale = 0.0625f;

    public PlayerRenderManager() {
        this.setFactory(new ModelRenderManager.RedirectHolderFactory<Void, Void, class_163>(){

            @Override
            public <M> ModelRenderManager.RedirectHolder<?, Void, Void, class_163> create(M model, String arg) {
                if (model instanceof class_87) {
                    if ("armor1".equals(arg)) {
                        return new RedirectHolderArmor1(PlayerRenderManager.this, (class_87)model);
                    }
                    if ("armor2".equals(arg)) {
                        return new RedirectHolderArmor2(PlayerRenderManager.this, (class_87)model);
                    }
                    return new RedirectHolderPlayer(PlayerRenderManager.this, (class_87)model);
                }
                return null;
            }
        });
        this.setRedirectFactory(new ModelRenderManager.RedirectRendererFactory<class_173, Void, class_163>(){

            @Override
            public ModelRenderManager.RedirectRenderer<class_163> create(class_173 model, ModelRenderManager.RedirectHolder<class_173, ?, Void, class_163> access, Supplier<class_163> modelPart, VanillaModelPart part) {
                return new RedirectModelPart((RDH)access, modelPart, part);
            }
        });
        this.setVis(m -> m.field_2299, (m, v) -> {
            m.field_2299 = v;
        });
        this.setModelPosGetters(m -> m.field_2292, m -> m.field_2293, m -> m.field_2294);
        this.setModelRotGetters(m -> m.field_2295, m -> m.field_2296, m -> m.field_2297);
        this.setModelSetters((m, x, y, z) -> {
            m.field_2292 = x;
            m.field_2293 = y;
            m.field_2294 = z;
        }, (m, x, y, z) -> {
            m.field_2295 = x;
            m.field_2296 = y;
            m.field_2297 = z;
        });
        this.setRenderPart(new class_163(0, 0));
    }

    public static void multiplyStacks(MatrixStack.Entry e) {
        e.getMatrix().multiplyNative(GL11::glMultMatrix);
    }

    private static class RedirectModelPart
    extends class_163
    implements ModelRenderManager.RedirectRenderer<class_163> {
        private final RDH holder;
        private final VanillaModelPart part;
        private final Supplier<class_163> parentProvider;
        private class_163 parent;
        private VBuffers buffers;

        public RedirectModelPart(RDH holder, Supplier<class_163> parent, VanillaModelPart part) {
            super(0, 0);
            this.holder = holder;
            this.parentProvider = parent;
            this.part = part;
        }

        public void method_1815(float scale) {
            this.buffers = new VBuffers(RetroGL::buffer);
            this.render();
            this.buffers.finishAll();
        }

        @Override
        public class_163 swapIn() {
            if (this.parent != null) {
                return this;
            }
            this.parent = this.parentProvider.get();
            RedirectModelPart.copyModel(this.parent, this);
            return this;
        }

        @Override
        public class_163 swapOut() {
            if (this.parent == null) {
                return this.parentProvider.get();
            }
            class_163 p = this.parent;
            this.parent = null;
            return p;
        }

        private static void copyModel(class_163 s, class_163 d) {
            d.field_2292 = s.field_2292;
            d.field_2293 = s.field_2293;
            d.field_2294 = s.field_2294;
            d.field_2295 = s.field_2295;
            d.field_2296 = s.field_2296;
            d.field_2297 = s.field_2297;
            d.field_2299 = s.field_2299;
            d.field_2300 = s.field_2300;
        }

        @Override
        public ModelRenderManager.RedirectHolder<?, ?, ?, class_163> getHolder() {
            return this.holder;
        }

        @Override
        public class_163 getParent() {
            return this.parent;
        }

        @Override
        public VanillaModelPart getPart() {
            return this.part;
        }

        @Override
        public void renderParent() {
            this.parent.method_1815(0.0625f);
        }

        @Override
        public VBuffers getVBuffers() {
            return this.buffers;
        }

        @Override
        public Vec4f getColor() {
            return RetroGL.getColor();
        }

        public void method_1820(float scale) {
            MatrixStack.Entry e = this.getPartTransform();
            if (e != null) {
                PlayerRenderManager.multiplyStacks(e);
            } else if (this.field_2295 == 0.0f && this.field_2296 == 0.0f && this.field_2297 == 0.0f) {
                if (this.field_2292 != 0.0f || this.field_2293 != 0.0f || this.field_2294 != 0.0f) {
                    GL11.glTranslatef((float)(this.field_2292 * scale), (float)(this.field_2293 * scale), (float)(this.field_2294 * scale));
                }
            } else {
                GL11.glTranslatef((float)(this.field_2292 * scale), (float)(this.field_2293 * scale), (float)(this.field_2294 * scale));
                if (this.field_2297 != 0.0f) {
                    GL11.glRotatef((float)(this.field_2297 * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.field_2296 != 0.0f) {
                    GL11.glRotatef((float)(this.field_2296 * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.field_2295 != 0.0f) {
                    GL11.glRotatef((float)(this.field_2295 * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
        }
    }

    private static abstract class RDH
    extends RedirectHolderRetro<class_173, class_163> {
        public RDH(ModelRenderManager<Void, Void, class_163, class_173> mngr, class_173 model) {
            super(mngr, model);
        }
    }

    private static class RedirectHolderArmor2
    extends RDH {
        public RedirectHolderArmor2(PlayerRenderManager mngr, class_87 model) {
            super(mngr, (class_173)model);
            this.register(new ModelRenderManager.Field<class_163>(() -> model.field_621, v -> {
                model.field_621 = v;
            }, RootModelType.ARMOR_LEGGINGS_BODY));
            this.register(new ModelRenderManager.Field<class_163>(() -> model.field_624, v -> {
                model.field_624 = v;
            }, RootModelType.ARMOR_RIGHT_LEG));
            this.register(new ModelRenderManager.Field<class_163>(() -> model.field_625, v -> {
                model.field_625 = v;
            }, RootModelType.ARMOR_LEFT_LEG));
        }
    }

    private static class RedirectHolderArmor1
    extends RDH {
        public RedirectHolderArmor1(PlayerRenderManager mngr, class_87 model) {
            super(mngr, (class_173)model);
            this.register(new ModelRenderManager.Field<class_163>(() -> model.field_619, v -> {
                model.field_619 = v;
            }, RootModelType.ARMOR_HELMET));
            this.register(new ModelRenderManager.Field<class_163>(() -> model.field_621, v -> {
                model.field_621 = v;
            }, RootModelType.ARMOR_BODY));
            this.register(new ModelRenderManager.Field<class_163>(() -> model.field_622, v -> {
                model.field_622 = v;
            }, RootModelType.ARMOR_RIGHT_ARM));
            this.register(new ModelRenderManager.Field<class_163>(() -> model.field_623, v -> {
                model.field_623 = v;
            }, RootModelType.ARMOR_LEFT_ARM));
            this.register(new ModelRenderManager.Field<class_163>(() -> model.field_624, v -> {
                model.field_624 = v;
            }, RootModelType.ARMOR_RIGHT_FOOT));
            this.register(new ModelRenderManager.Field<class_163>(() -> model.field_625, v -> {
                model.field_625 = v;
            }, RootModelType.ARMOR_LEFT_FOOT));
            this.register(new ModelRenderManager.Field<class_163>(() -> model.field_620, v -> {
                model.field_620 = v;
            }, null));
        }
    }

    private static class RedirectHolderPlayer
    extends RDH {
        private ModelRenderManager.RedirectRenderer<class_163> head = this.registerHead(new ModelRenderManager.Field<class_163>(() -> model.field_619, v -> {
            model.field_619 = v;
        }, PlayerModelParts.HEAD));

        public RedirectHolderPlayer(PlayerRenderManager mngr, class_87 model) {
            super(mngr, (class_173)model);
            this.register(new ModelRenderManager.Field<class_163>(() -> model.field_621, v -> {
                model.field_621 = v;
            }, PlayerModelParts.BODY));
            this.register(new ModelRenderManager.Field<class_163>(() -> model.field_622, v -> {
                model.field_622 = v;
            }, PlayerModelParts.RIGHT_ARM));
            this.register(new ModelRenderManager.Field<class_163>(() -> model.field_623, v -> {
                model.field_623 = v;
            }, PlayerModelParts.LEFT_ARM));
            this.register(new ModelRenderManager.Field<class_163>(() -> model.field_624, v -> {
                model.field_624 = v;
            }, PlayerModelParts.RIGHT_LEG));
            this.register(new ModelRenderManager.Field<class_163>(() -> model.field_625, v -> {
                model.field_625 = v;
            }, PlayerModelParts.LEFT_LEG));
            this.register(new ModelRenderManager.Field<class_163>(() -> model.field_620, v -> {
                model.field_620 = v;
            }, null)).setCopyFrom(this.head);
            this.register(new ModelRenderManager.Field<class_163>(() -> model.field_627, v -> {
                model.field_627 = v;
            }, RootModelType.CAPE));
        }
    }
}

