/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.command.StringCommandHandler;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.text.IText;
import com.tom.cpm.CustomPlayerModels;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_54;

public class Command {

    public static abstract class CommandHandlerBase<L>
    extends StringCommandHandler<Void, L, CommandException> {
        private Map<String, StringCommandHandler.CommandImpl> commands;

        public CommandHandlerBase(Map<String, StringCommandHandler.CommandImpl> commands) {
            super(i -> commands.put(i.getName(), (StringCommandHandler.CommandImpl)i), false);
            this.commands = commands;
        }

        public CommandHandlerBase() {
            this(new HashMap<String, StringCommandHandler.CommandImpl>());
        }

        @Override
        public String toStringPlayer(Object pl) {
            return ((class_54)pl).field_528;
        }

        public boolean onCommand(L sender, String fullText) {
            try {
                String[] sp = fullText.split(" ");
                StringCommandHandler.CommandImpl cmd = this.commands.get(sp[0]);
                if (cmd != null) {
                    cmd.execute(null, sender, Arrays.copyOfRange(sp, 1, sp.length));
                    return true;
                }
            }
            catch (CommandException e) {
                this.sendMessage(sender, "\u00a7c" + (String)e.msg.remap());
                return true;
            }
            return false;
        }

        public List<String> onTabComplete(String command) {
            String[] sp = command.split(" ");
            try {
                StringCommandHandler.CommandImpl cmd = this.commands.get(sp[0]);
                if (cmd != null) {
                    return cmd.getTabCompletions(null, null, Arrays.copyOfRange(sp, 1, sp.length));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Collections.emptyList();
        }

        @Override
        public void sendSuccess(L sender, IText text) {
            this.sendMessage(sender, (String)text.remap());
        }

        protected abstract void sendMessage(L var1, String var2);

        @Override
        public CommandException generic(String text, Object ... format) {
            return new CommandException(new FormatText(text, format));
        }

        @Override
        public CommandException wrongUsage(String text, Object ... format) {
            return new CommandException(new FormatText(text, format));
        }

        @Override
        public Object getPlayerObj(Void server, L sender, String name) throws CommandException {
            return CustomPlayerModels.proxy.getPlayersOnline().stream().filter(e -> e.field_528.equals(name)).findFirst().orElse(null);
        }

        @Override
        public CommandException checkExc(Exception exc) {
            if (exc instanceof CommandException) {
                return (CommandException)exc;
            }
            return new CommandException(new FormatText("commands.generic.exception", new Object[0]));
        }

        @Override
        public List<String> getOnlinePlayers(Void server) {
            return CustomPlayerModels.proxy.getPlayersOnline().stream().map(e -> e.field_528).collect(Collectors.toList());
        }
    }

    private static class CommandException
    extends Exception {
        private static final long serialVersionUID = 3508944502637337553L;
        private IText msg;

        public CommandException(IText msg) {
            this.msg = msg;
        }
    }
}

