/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.util;

import com.tom.cpl.render.VBuffers;
import com.tom.cpl.render.VertexBuffer;
import java.util.function.Predicate;

public class FilterBuffers {
    private Predicate<VBuffers.NativeRenderType> predicate;

    public FilterBuffers(Predicate<VBuffers.NativeRenderType> predicate) {
        this.predicate = predicate;
    }

    public VBuffers filter(VBuffers in) {
        return in.map((x$0, x$1) -> new Filtered((VBuffers.NativeRenderType)x$0, (VertexBuffer)x$1));
    }

    private class Filtered
    implements VertexBuffer {
        private VertexBuffer b;
        private VBuffers.NativeRenderType nrt;
        private boolean enable;

        public Filtered(VBuffers.NativeRenderType nrt, VertexBuffer b) {
            this.b = b;
            this.nrt = nrt;
        }

        private boolean enable() {
            this.enable = FilterBuffers.this.predicate.test(this.nrt);
            return this.enable;
        }

        @Override
        public VertexBuffer pos(float x, float y, float z) {
            if (this.enable()) {
                this.b.pos(x, y, z);
            }
            return this;
        }

        @Override
        public VertexBuffer tex(float u, float v) {
            if (this.enable) {
                this.b.tex(u, v);
            }
            return this;
        }

        @Override
        public VertexBuffer color(float red, float green, float blue, float alpha) {
            if (this.enable) {
                this.b.color(red, green, blue, alpha);
            }
            return this;
        }

        @Override
        public VertexBuffer normal(float x, float y, float z) {
            if (this.enable) {
                this.b.normal(x, y, z);
            }
            return this;
        }

        @Override
        public void endVertex() {
            if (this.enable) {
                this.b.endVertex();
            }
        }

        @Override
        public void finish() {
            this.b.finish();
        }
    }
}

