/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.gui.panel.ListPanel;
import java.util.List;
import java.util.function.Consumer;

public class ListPicker<T>
extends GuiElement {
    private Frame frame;
    private List<T> values;
    private int selectedId = -1;
    private Runnable action;
    private Consumer<ListPanel<T>> listLoader;

    public ListPicker(Frame frm, List<T> values) {
        super(frm.getGui());
        this.frame = frm;
        this.values = values;
        if (!values.isEmpty()) {
            this.selectedId = 0;
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        String v = this.values.size() > this.selectedId && this.selectedId >= 0 ? String.valueOf(this.values.get(this.selectedId)) : this.gui.i18nFormat("label.cpm.no_elements", new Object[0]);
        int w = this.gui.textWidth(v);
        int bgColor = this.gui.getColors().button_fill;
        int color = this.gui.getColors().button_text_color;
        if (!this.enabled) {
            color = this.gui.getColors().button_text_disabled;
            bgColor = this.gui.getColors().button_disabled;
        } else if (event.isHovered(this.bounds)) {
            color = this.gui.getColors().button_text_hover;
            bgColor = this.gui.getColors().button_hover;
        }
        this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, this.gui.getColors().button_border);
        this.gui.drawBox(this.bounds.x + 1, this.bounds.y + 1, this.bounds.w - 2, this.bounds.h - 2, bgColor);
        this.gui.drawText(this.bounds.x + this.bounds.w / 2 - w / 2, this.bounds.y + this.bounds.h / 2 - 4, v, color);
        this.gui.drawTexture(this.bounds.x + this.bounds.w - 10, this.bounds.y + this.bounds.h / 2 - 4, 8, 8, 0, 8, "editor");
    }

    @Override
    public void mouseClick(MouseEvent evt) {
        if (this.enabled && evt.isInBounds(this.bounds) && !evt.isConsumed()) {
            this.frame.openPopup(new Popup());
            evt.consume();
        }
    }

    @Override
    public GuiElement setBounds(Box b) {
        super.setBounds(b);
        return this;
    }

    public void setAction(Runnable action) {
        this.action = action;
    }

    public void setSelected(T sel) {
        this.selectedId = this.values.indexOf(sel);
    }

    public T getSelected() {
        return this.values.size() > this.selectedId && this.selectedId >= 0 ? (T)this.values.get(this.selectedId) : null;
    }

    public void setListLoader(Consumer<ListPanel<T>> listLoader) {
        this.listLoader = listLoader;
    }

    private class Popup
    extends PopupPanel {
        protected Popup() {
            super(ListPicker.this.gui);
            int w = Math.min(((ListPicker)ListPicker.this).frame.getBounds().w / 4 * 3, 500);
            int h = Math.min(((ListPicker)ListPicker.this).frame.getBounds().h / 4 * 3, 350);
            ListPanel list = new ListPanel(this.gui, ListPicker.this.values, w - 10, h - 35);
            if (ListPicker.this.listLoader != null) {
                ListPicker.this.listLoader.accept(list);
            }
            list.setSelected(ListPicker.this.getSelected());
            list.setBounds(new Box(5, 5, w - 10, h - 35));
            this.addElement(list);
            Button btn = new Button(this.gui, this.gui.i18nFormat("button.cpm.ok", new Object[0]), () -> {
                this.close();
                ListPicker.this.setSelected(list.getSelected());
                if (ListPicker.this.action != null) {
                    ListPicker.this.action.run();
                }
            });
            btn.setBounds(new Box(5, h - 25, 60, 20));
            this.addElement(btn);
            this.setBounds(new Box(0, 0, w, h));
        }

        @Override
        public String getTitle() {
            return this.gui.i18nFormat("label.cpm.editElement", new Object[0]);
        }
    }
}

