/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm;

import com.tom.cpl.block.BlockStateHandler;
import com.tom.cpl.block.entity.EntityTypeHandler;
import com.tom.cpl.config.ModConfigFile;
import com.tom.cpl.item.ItemStackHandler;
import com.tom.cpl.text.TextRemapper;
import com.tom.cpl.text.TextStyle;
import com.tom.cpl.util.ILogger;
import com.tom.cpm.CommonProxy;
import com.tom.cpm.Log4JLogger;
import com.tom.cpm.MinecraftServerObject;
import com.tom.cpm.api.CPMApiManager;
import com.tom.cpm.api.ICPMPlugin;
import com.tom.cpm.common.BlockStateHandlerImpl;
import com.tom.cpm.common.Command;
import com.tom.cpm.common.EntityTypeHandlerImpl;
import com.tom.cpm.common.ItemStackHandlerImpl;
import com.tom.cpm.common.ServerHandler;
import com.tom.cpm.shared.MinecraftCommonAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.PlatformFeature;
import com.tom.cpm.shared.config.ModConfig;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import java.io.File;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="customplayermodels", acceptableRemoteVersions="*", guiFactory="com.tom.cpm.Config")
public class CustomPlayerModels
implements MinecraftCommonAccess {
    public static final String ID = "customplayermodels";
    @SidedProxy(clientSide="com.tom.cpm.client.ClientProxy", serverSide="com.tom.cpm.CommonProxy")
    public static CommonProxy proxy;
    public static final Logger LOG;
    public static final ILogger log;
    public static CPMApiManager api;
    private ModConfigFile cfg;
    private static final EnumSet<PlatformFeature> features;

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        api = new CPMApiManager();
        proxy.init();
        ServerHandler sh = new ServerHandler();
        MinecraftForge.EVENT_BUS.register((Object)sh);
        FMLCommonHandler.instance().bus().register((Object)sh);
        LOG.info("Customizable Player Models Initialized");
    }

    @Mod.EventHandler
    public void processIMC(FMLInterModComms.IMCEvent event) {
        event.getMessages().forEach(m -> {
            try {
                if (m.key.equals("api")) {
                    ICPMPlugin plugin = (ICPMPlugin)Class.forName(m.getStringValue()).newInstance();
                    api.register(plugin);
                }
            }
            catch (Throwable e) {
                LOG.error("Mod {} provides a broken implementation of CPM api", new Object[]{m.getSender(), e});
            }
        });
        LOG.info("Customizable Player Models IMC processed: " + api.getPluginStatus());
        api.buildCommon().player(EntityPlayer.class).init();
        proxy.apiInit();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent evt) {
        MinecraftObjectHolder.setServerObject(new MinecraftServerObject(evt.getServer()));
        new Command(arg_0 -> ((FMLServerStartingEvent)evt).registerServerCommand(arg_0), false);
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppingEvent evt) {
        ModConfig.getWorldConfig().save();
        MinecraftObjectHolder.setServerObject(null);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        this.cfg = new ModConfigFile(new File(evt.getModConfigurationDirectory(), "cpm.json"));
        MinecraftObjectHolder.setCommonObject(this);
    }

    @Override
    public ModConfigFile getConfig() {
        return this.cfg;
    }

    @Override
    public ILogger getLogger() {
        return log;
    }

    @Override
    public EnumSet<PlatformFeature> getSupportedFeatures() {
        return features;
    }

    @Override
    public String getMCVersion() {
        return "1.7.10";
    }

    @Override
    public String getMCBrand() {
        return "(" + FMLCommonHandler.instance().getModName() + ")";
    }

    @Override
    public String getModVersion() {
        return ((ModContainer)Loader.instance().getIndexedModList().get(ID)).getDisplayVersion();
    }

    public TextRemapper<IChatComponent> getTextRemapper() {
        return new TextRemapper<IChatComponent>(ChatComponentTranslation::new, ChatComponentText::new, IChatComponent::func_150257_a, null, CustomPlayerModels::styleText);
    }

    private static IChatComponent styleText(IChatComponent in, TextStyle style) {
        ChatStyle s = new ChatStyle();
        s.func_150227_a(Boolean.valueOf(style.bold));
        s.func_150217_b(Boolean.valueOf(style.italic));
        s.func_150228_d(Boolean.valueOf(style.underline));
        s.func_150225_c(Boolean.valueOf(style.strikethrough));
        return in.func_150255_a(s);
    }

    @Override
    public CPMApiManager getApi() {
        return api;
    }

    @Override
    public BlockStateHandler<?> getBlockStateHandler() {
        return BlockStateHandlerImpl.impl;
    }

    @Override
    public ItemStackHandler<?> getItemStackHandler() {
        return ItemStackHandlerImpl.impl;
    }

    @Override
    public EntityTypeHandler<?> getEntityTypeHandler() {
        return EntityTypeHandlerImpl.impl;
    }

    static {
        LOG = LogManager.getLogger((String)"CPM");
        log = new Log4JLogger(LOG);
        features = EnumSet.noneOf(PlatformFeature.class);
    }
}

