/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.tag.TagManager;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.util.ErrorLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;

public class CPMTagLoader
implements IResourceManagerReloadListener {
    private final TagManager<?> tags;
    private final String prefix;

    public CPMTagLoader(IResourceManager mngr, TagManager<?> tags, String prefix) {
        this.tags = tags;
        this.prefix = prefix;
        if (mngr instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)mngr).func_110542_a((IResourceManagerReloadListener)this);
        }
    }

    private Map<String, List<Map<String, Object>>> load(IResourceManager mngr) {
        HashMap<String, List<Map<String, Object>>> el = new HashMap<String, List<Map<String, Object>>>();
        HashSet allEntries = new HashSet();
        mngr.func_135055_a().forEach(d -> {
            ResourceLocation rl = new ResourceLocation((String)d, "cpm_tags/dictionary.json");
            try {
                List res = mngr.func_135056_b(rl);
                for (IResource r : res) {
                    try {
                        InputStream inputstream = r.func_110527_b();
                        Throwable throwable = null;
                        try {
                            BufferedReader rd = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                            Throwable throwable2 = null;
                            try {
                                Map tag = (Map)MinecraftObjectHolder.gson.fromJson((Reader)rd, Object.class);
                                List entries = (List)tag.get(this.prefix);
                                if (entries == null) continue;
                                for (String e : entries) {
                                    allEntries.add(new ResourceLocation((String)d, "cpm_tags/" + this.prefix + "/" + e + ".json"));
                                }
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (rd == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        ((Reader)rd).close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                ((Reader)rd).close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (inputstream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputstream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            inputstream.close();
                        }
                    }
                    catch (Exception e) {
                        ErrorLog.addLog(ErrorLog.LogLevel.WARNING, "Failed to load cpm tag dictionary: " + rl, e);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        allEntries.forEach(rl -> {
            ArrayList<Map> res = new ArrayList<Map>();
            el.put(rl.func_110624_b() + ":" + rl.func_110623_a().substring(9, rl.func_110623_a().length() - 5), res);
            try {
                for (IResource r : mngr.func_135056_b(rl)) {
                    InputStream inputstream = r.func_110527_b();
                    Throwable throwable = null;
                    try {
                        BufferedReader rd = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                        Throwable throwable2 = null;
                        try {
                            Map tag = (Map)MinecraftObjectHolder.gson.fromJson((Reader)rd, Object.class);
                            res.add(tag);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (rd == null) continue;
                            if (throwable2 != null) {
                                try {
                                    ((Reader)rd).close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            ((Reader)rd).close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (inputstream == null) continue;
                        if (throwable != null) {
                            try {
                                inputstream.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        inputstream.close();
                    }
                }
            }
            catch (Exception e) {
                ErrorLog.addLog(ErrorLog.LogLevel.WARNING, "Failed to load cpm builtin tag: " + rl, e);
            }
        });
        return el;
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.tags.applyBuiltin(this.load(resourceManager), this.prefix);
    }
}

