/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.tom.cpl.text.FormatText;
import com.tom.cpm.CommonProxy;
import com.tom.cpm.CustomPlayerModels;
import com.tom.cpm.client.GuiImpl;
import com.tom.cpm.client.KeyBindings;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.common.Command;
import com.tom.cpm.common.NetHandlerExt;
import com.tom.cpm.common.PlayerAnimUpdater;
import com.tom.cpm.lefix.FixSSL;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.gui.GestureGui;
import com.tom.cpm.shared.model.TextureSheetType;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class ClientProxy
extends CommonProxy {
    public static MinecraftObject mc;
    private Minecraft minecraft;
    public static ClientProxy INSTANCE;
    public com.tom.cpm.shared.model.RenderManager<GameProfile, EntityPlayer, ModelBase, Void> manager;
    public NetHandlerExt<ResourceLocation, EntityPlayer, NetHandlerPlayClient> netHandler;

    @Override
    public void init() {
        super.init();
        FixSSL.fixup();
        INSTANCE = this;
        this.minecraft = Minecraft.func_71410_x();
        mc = new MinecraftObject(this.minecraft);
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        KeyBindings.init();
        this.manager = new com.tom.cpm.shared.model.RenderManager<GameProfile, EntityPlayer, ModelBase, Void>(mc.getPlayerRenderManager(), mc.getDefinitionLoader(), EntityPlayer::func_146103_bH);
        this.manager.setGPGetters(GameProfile::getProperties, Property::getValue);
        this.netHandler = new NetHandlerExt(ResourceLocation::new);
        Executor ex = arg_0 -> ((Minecraft)this.minecraft).func_152344_a(arg_0);
        this.netHandler.setExecutor(() -> ex);
        this.netHandler.setSendPacketClient((c, rl, pb) -> c.func_147297_a((Packet)new C17PacketCustomPayload(rl.toString(), pb)));
        this.netHandler.setPlayerToLoader(EntityPlayer::func_146103_bH);
        this.netHandler.setGetPlayerById(id -> {
            Entity ent = Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
            if (ent instanceof EntityPlayer) {
                return (EntityPlayer)ent;
            }
            return null;
        });
        this.netHandler.setGetClient(() -> this.minecraft.field_71439_g);
        this.netHandler.setGetNet(c -> ((EntityClientPlayerMP)c).field_71174_a);
        this.netHandler.setDisplayText(f -> this.minecraft.field_71456_v.func_146158_b().func_146227_a((IChatComponent)f.remap()));
        this.netHandler.setGetPlayerAnimGetters(new PlayerAnimUpdater());
        new Command(arg_0 -> ((ClientCommandHandler)ClientCommandHandler.instance).func_71560_a(arg_0), true);
    }

    @Override
    public void apiInit() {
        CustomPlayerModels.api.buildClient().voicePlayer(EntityPlayer.class, Entity::func_110124_au).localModelApi(GameProfile::new).renderApi(ModelBase.class, GameProfile.class).init();
    }

    @SubscribeEvent
    public void playerRenderPre(RenderPlayerEvent.Pre event) {
        this.manager.bindPlayer(event.entityPlayer, null, (ModelBase)event.renderer.field_77109_a);
        this.manager.bindSkin((ModelBase)event.renderer.field_77109_a, TextureSheetType.SKIN);
        ModelBiped model = event.renderer.field_77109_a;
        this.manager.bindArmor((ModelBase)model, (ModelBase)event.renderer.field_77108_b, 1);
        this.manager.bindArmor((ModelBase)model, (ModelBase)event.renderer.field_77111_i, 2);
        this.manager.bindSkin((ModelBase)event.renderer.field_77108_b, TextureSheetType.ARMOR1);
        this.manager.bindSkin((ModelBase)event.renderer.field_77111_i, TextureSheetType.ARMOR2);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void playerRenderPreC(RenderPlayerEvent.Pre event) {
        if (event.isCanceled()) {
            this.manager.unbind((ModelBase)event.renderer.field_77111_i);
            this.manager.unbind((ModelBase)event.renderer.field_77108_b);
            this.manager.unbindClear((ModelBase)event.renderer.field_77109_a);
        }
    }

    @SubscribeEvent
    public void playerRenderPost(RenderPlayerEvent.Post event) {
        this.manager.unbind((ModelBase)event.renderer.field_77111_i);
        this.manager.unbind((ModelBase)event.renderer.field_77108_b);
        this.manager.unbindClear((ModelBase)event.renderer.field_77109_a);
    }

    @SubscribeEvent
    public void initGui(GuiScreenEvent.InitGuiEvent.Post evt) {
        if (evt.gui instanceof GuiMainMenu && ModConfig.getCommonConfig().getSetBoolean("titleScreenButton", true) || evt.gui instanceof GuiOptions) {
            evt.buttonList.add(new Button(0, 0));
        }
    }

    @SubscribeEvent
    public void buttonPress(GuiScreenEvent.ActionPerformedEvent.Pre evt) {
        if (evt.button instanceof Button) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiImpl(EditorGui::new, evt.gui));
        }
    }

    @SubscribeEvent
    public void openGui(GuiOpenEvent openGui) {
        if (openGui.gui == null && this.minecraft.field_71462_r instanceof GuiImpl.Overlay) {
            openGui.gui = ((GuiImpl.Overlay)this.minecraft.field_71462_r).getGui();
        }
        if (openGui.gui instanceof GuiMainMenu && !(this.minecraft.field_71462_r instanceof GuiSelectWorld) && !(this.minecraft.field_71462_r instanceof GuiMainMenu) && EditorGui.doOpenEditor()) {
            openGui.gui = new GuiImpl(EditorGui::new, openGui.gui);
        }
        if (openGui.gui instanceof GuiImpl) {
            ((GuiImpl)openGui.gui).onOpened();
        }
    }

    @SubscribeEvent
    public void drawGuiPre(GuiScreenEvent.DrawScreenEvent.Pre evt) {
        PlayerProfile.inGui = true;
    }

    @SubscribeEvent
    public void drawGuiPost(GuiScreenEvent.DrawScreenEvent.Post evt) {
        PlayerProfile.inGui = false;
    }

    public void renderSkull(ModelBase skullModel, GameProfile profile) {
        this.manager.bindSkull(profile, null, skullModel);
        this.manager.bindSkin(skullModel, TextureSheetType.SKIN);
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            mc.getPlayerRenderManager().getAnimationEngine().update(evt.renderTickTime);
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START && !this.minecraft.func_147113_T()) {
            mc.getPlayerRenderManager().getAnimationEngine().tick();
            if (this.minecraft.field_71439_g != null && this.minecraft.field_71439_g.field_70122_E && this.minecraft.field_71474_y.field_74314_A.func_151470_d()) {
                this.manager.jump((EntityPlayer)this.minecraft.field_71439_g);
            }
        }
        if (this.minecraft.field_71439_g == null || evt.phase == TickEvent.Phase.START) {
            return;
        }
        if (KeyBindings.gestureMenuBinding.func_151468_f()) {
            this.minecraft.func_147108_a((GuiScreen)new GuiImpl(GestureGui::new, null));
        }
        if (KeyBindings.renderToggleBinding.func_151468_f()) {
            Player.setEnableRendering(!Player.isEnableRendering());
        }
        mc.getPlayerRenderManager().getAnimationEngine().updateKeys(KeyBindings.quickAccess);
    }

    @SubscribeEvent
    public void onRenderName(RenderLivingEvent.Specials.Pre evt) {
        if (evt.entity instanceof AbstractClientPlayer) {
            FormatText st;
            if (!Player.isEnableNames()) {
                evt.setCanceled(true);
            }
            if (Player.isEnableLoadingInfo() && this.canRenderName(evt.entity) && (st = ClientProxy.INSTANCE.manager.getStatus(((AbstractClientPlayer)evt.entity).func_146103_bH(), "player")) != null) {
                float f = 1.6f;
                float f1 = 0.016666668f * f / 2.0f;
                double d3 = evt.entity.func_70068_e((Entity)RenderManager.field_78727_a.field_78734_h);
                if (d3 < 1024.0) {
                    Scoreboard scoreboard = ((EntityPlayer)evt.entity).func_96123_co();
                    ScoreObjective scoreobjective = scoreboard.func_96539_a(2);
                    double y = evt.y;
                    if (scoreobjective != null) {
                        y += (double)((float)evt.renderer.func_76983_a().field_78288_b * 1.15f * 0.025f);
                    }
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)0.0, (double)0.125, (double)0.0);
                    String s = ((IChatComponent)st.remap()).func_150254_d();
                    if (evt.entity.func_70093_af()) {
                        FontRenderer fontrenderer = this.minecraft.field_71466_p;
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)((float)evt.x + 0.0f), (float)((float)y + evt.entity.field_70131_O + 0.5f), (float)((float)evt.z));
                        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
                        GL11.glDisable((int)2896);
                        GL11.glTranslatef((float)0.0f, (float)(0.25f / f1), (float)0.0f);
                        GL11.glDepthMask((boolean)false);
                        GL11.glEnable((int)3042);
                        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                        Tessellator tessellator = Tessellator.field_78398_a;
                        GL11.glDisable((int)3553);
                        tessellator.func_78382_b();
                        int i = fontrenderer.func_78256_a(s) / 2;
                        tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.25f);
                        tessellator.func_78377_a((double)(-i - 1), -1.0, 0.0);
                        tessellator.func_78377_a((double)(-i - 1), 8.0, 0.0);
                        tessellator.func_78377_a((double)(i + 1), 8.0, 0.0);
                        tessellator.func_78377_a((double)(i + 1), -1.0, 0.0);
                        tessellator.func_78381_a();
                        GL11.glEnable((int)3553);
                        GL11.glDepthMask((boolean)true);
                        fontrenderer.func_78276_b(s, -fontrenderer.func_78256_a(s) / 2, 0, 0x20FFFFFF);
                        GL11.glEnable((int)2896);
                        GL11.glDisable((int)3042);
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GL11.glPopMatrix();
                    } else {
                        this.renderLivingLabel(evt.entity, evt.x, y, evt.z, s, f1, d3);
                    }
                    GL11.glPopMatrix();
                }
            }
        }
    }

    protected boolean canRenderName(EntityLivingBase p_110813_1_) {
        return Minecraft.func_71382_s() && !p_110813_1_.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g) && p_110813_1_.field_70153_n == null;
    }

    protected void renderLivingLabel(EntityLivingBase p_96449_1_, double p_96449_2_, double p_96449_4_, double p_96449_6_, String p_96449_8_, float p_96449_9_, double p_96449_10_) {
        if (p_96449_1_.func_70608_bn()) {
            this.renderLivingLabel0((Entity)p_96449_1_, p_96449_8_, p_96449_2_, p_96449_4_ - 1.5, p_96449_6_, 64);
        } else {
            this.renderLivingLabel0((Entity)p_96449_1_, p_96449_8_, p_96449_2_, p_96449_4_, p_96449_6_, 64);
        }
    }

    protected void renderLivingLabel0(Entity p_147906_1_, String p_147906_2_, double p_147906_3_, double p_147906_5_, double p_147906_7_, int p_147906_9_) {
        double d3 = p_147906_1_.func_70068_e((Entity)RenderManager.field_78727_a.field_78734_h);
        if (d3 <= (double)(p_147906_9_ * p_147906_9_)) {
            FontRenderer fontrenderer = this.minecraft.field_71466_p;
            float f = 1.6f;
            float f1 = 0.016666668f * f / 2.0f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)p_147906_3_ + 0.0f), (float)((float)p_147906_5_ + p_147906_1_.field_70131_O + 0.5f), (float)((float)p_147906_7_));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            Tessellator tessellator = Tessellator.field_78398_a;
            int b0 = 0;
            if (p_147906_2_.equals("deadmau5")) {
                b0 = -10;
            }
            GL11.glDisable((int)3553);
            tessellator.func_78382_b();
            int j = fontrenderer.func_78256_a(p_147906_2_) / 2;
            tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.25f);
            tessellator.func_78377_a((double)(-j - 1), (double)(-1 + b0), 0.0);
            tessellator.func_78377_a((double)(-j - 1), (double)(8 + b0), 0.0);
            tessellator.func_78377_a((double)(j + 1), (double)(8 + b0), 0.0);
            tessellator.func_78377_a((double)(j + 1), (double)(-1 + b0), 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
            fontrenderer.func_78276_b(p_147906_2_, -fontrenderer.func_78256_a(p_147906_2_) / 2, b0, 0x20FFFFFF);
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
            fontrenderer.func_78276_b(p_147906_2_, -fontrenderer.func_78256_a(p_147906_2_) / 2, b0, -1);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    public void onLogout() {
        mc.onLogOut();
    }

    public static void renderCape(AbstractClientPlayer playerIn, float partialTicks, ModelBiped model, ModelDefinition modelDefinition) {
        float f7;
        float f6;
        float f5;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
        if (playerIn != null) {
            double d3 = playerIn.field_71091_bM + (playerIn.field_71094_bP - playerIn.field_71091_bM) * (double)partialTicks - (playerIn.field_70169_q + (playerIn.field_70165_t - playerIn.field_70169_q) * (double)partialTicks);
            double d4 = playerIn.field_71096_bN + (playerIn.field_71095_bQ - playerIn.field_71096_bN) * (double)partialTicks - (playerIn.field_70167_r + (playerIn.field_70163_u - playerIn.field_70167_r) * (double)partialTicks);
            double d0 = playerIn.field_71097_bO + (playerIn.field_71085_bR - playerIn.field_71097_bO) * (double)partialTicks - (playerIn.field_70166_s + (playerIn.field_70161_v - playerIn.field_70166_s) * (double)partialTicks);
            float f4 = playerIn.field_70760_ar + (playerIn.field_70761_aq - playerIn.field_70760_ar) * partialTicks;
            double d1 = MathHelper.func_76126_a((float)(f4 * (float)Math.PI / 180.0f));
            double d2 = -MathHelper.func_76134_b((float)(f4 * (float)Math.PI / 180.0f));
            f5 = (float)d4 * 10.0f;
            if (f5 < -6.0f) {
                f5 = -6.0f;
            }
            if (f5 > 32.0f) {
                f5 = 32.0f;
            }
            f6 = (float)(d3 * d1 + d0 * d2) * 100.0f;
            f7 = (float)(d3 * d2 - d0 * d1) * 100.0f;
            if (f6 < 0.0f) {
                f6 = 0.0f;
            }
            float f8 = playerIn.field_71107_bF + (playerIn.field_71109_bG - playerIn.field_71107_bF) * partialTicks;
            f5 += MathHelper.func_76126_a((float)((playerIn.field_70141_P + (playerIn.field_70140_Q - playerIn.field_70141_P) * partialTicks) * 6.0f)) * 32.0f * f8;
            if (playerIn.func_70093_af()) {
                f5 += 25.0f;
            }
        } else {
            f5 = 0.0f;
            f6 = 0.0f;
            f7 = 0.0f;
        }
        model.field_78122_k.field_78795_f = (float)(-Math.toRadians(6.0f + f6 / 2.0f + f5));
        model.field_78122_k.field_78796_g = (float)Math.toRadians(180.0f - f7 / 2.0f);
        model.field_78122_k.field_78808_h = (float)Math.toRadians(f7 / 2.0f);
        mc.getPlayerRenderManager().setModelPose(model);
        model.field_78122_k.field_78795_f = 0.0f;
        model.field_78122_k.field_78796_g = 0.0f;
        model.field_78122_k.field_78808_h = 0.0f;
        model.func_78111_c(0.0625f);
        GL11.glPopMatrix();
    }

    public static class Button
    extends GuiButton {
        public Button(int x, int y) {
            super(99, x, y, 100, 20, I18n.func_135052_a((String)"button.cpm.open_editor", (Object[])new Object[0]));
        }
    }
}

