/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.tom.cpl.block.BiomeHandler;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.IKeybind;
import com.tom.cpl.render.RenderTypeBuilder;
import com.tom.cpl.tag.AllTagManagers;
import com.tom.cpl.util.AWTImageIO;
import com.tom.cpl.util.DynamicTexture;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ImageIO;
import com.tom.cpm.client.CPMTagLoader;
import com.tom.cpm.client.ClientProxy;
import com.tom.cpm.client.GuiImpl;
import com.tom.cpm.client.KeyBindings;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.client.PlayerRenderManager;
import com.tom.cpm.client.RetroGL;
import com.tom.cpm.common.BiomeHandlerImpl;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.retro.RetroGLAccess;
import com.tom.cpm.shared.util.MojangAPI;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MinecraftObject
implements MinecraftClientAccess {
    private final Minecraft mc;
    private final PlayerRenderManager prm;
    private final AllTagManagers tags;
    private final ModelDefinitionLoader<GameProfile> loader;
    private final RenderTypeBuilder<ResourceLocation, RetroGLAccess.RetroLayer> renderBuilder = RenderTypeBuilder.setupRetro(new RetroGL());

    public MinecraftObject(Minecraft mc) {
        this.mc = mc;
        MinecraftObjectHolder.setClientObject(this);
        this.loader = new ModelDefinitionLoader<GameProfile>(PlayerProfile::new, GameProfile::getId, GameProfile::getName);
        this.prm = new PlayerRenderManager();
        this.tags = new AllTagManagers(mc.func_110442_L(), CPMTagLoader::new);
    }

    @Override
    public PlayerRenderManager getPlayerRenderManager() {
        return this.prm;
    }

    @Override
    public DynamicTexture.ITexture createTexture() {
        return new DynTexture(this.mc);
    }

    @Override
    public void executeOnGameThread(Runnable r) {
        this.mc.func_152344_a(r);
    }

    @Override
    public ModelDefinitionLoader<GameProfile> getDefinitionLoader() {
        return this.loader;
    }

    @Override
    public SkinType getSkinType() {
        return SkinType.DEFAULT;
    }

    @Override
    public void setEncodedGesture(int value) {
        ClientProxy.INSTANCE.netHandler.sendLayer(value);
    }

    @Override
    public boolean isInGame() {
        return this.mc.field_71439_g != null;
    }

    @Override
    public Object getPlayerIDObject() {
        return this.mc.func_110432_I().func_148256_e();
    }

    @Override
    public Object getCurrentPlayerIDObject() {
        return this.mc.field_71439_g != null ? this.mc.field_71439_g.func_146103_bH() : null;
    }

    @Override
    public List<IKeybind> getKeybinds() {
        return KeyBindings.kbs;
    }

    @Override
    public MinecraftClientAccess.ServerStatus getServerSideStatus() {
        return this.isInGame() ? (this.getNetHandler().hasModClient() ? MinecraftClientAccess.ServerStatus.INSTALLED : MinecraftClientAccess.ServerStatus.UNAVAILABLE) : MinecraftClientAccess.ServerStatus.OFFLINE;
    }

    @Override
    public File getGameDir() {
        return this.mc.field_71412_D;
    }

    @Override
    public void openGui(Function<IGui, Frame> creator) {
        this.mc.func_147108_a((GuiScreen)new GuiImpl(creator, this.mc.field_71462_r));
    }

    @Override
    public Runnable openSingleplayer() {
        return () -> this.mc.func_147108_a((GuiScreen)new GuiSelectWorld(this.mc.field_71462_r));
    }

    @Override
    public NetHandler<?, ?, ?> getNetHandler() {
        return ClientProxy.INSTANCE.netHandler;
    }

    @Override
    public ImageIO.IImageIO getImageIO() {
        return new AWTImageIO();
    }

    @Override
    public MojangAPI getMojangAPI() {
        return new MojangAPI(this.mc.func_110432_I().func_148256_e().getName(), this.mc.func_110432_I().func_148256_e().getId(), this.mc.func_110432_I().func_148254_d());
    }

    @Override
    public void clearSkinCache() {
        MojangAPI.clearYggdrasilCache(this.mc.func_152347_ac());
    }

    @Override
    public String getConnectedServer() {
        if (this.mc.func_147114_u() == null) {
            return null;
        }
        SocketAddress sa = this.mc.func_147114_u().func_147298_b().channel().remoteAddress();
        if (sa instanceof InetSocketAddress) {
            return ((InetSocketAddress)sa).getHostString();
        }
        return null;
    }

    @Override
    public List<Object> getPlayers() {
        if (this.mc.field_71439_g == null) {
            return Collections.emptyList();
        }
        NetHandlerPlayClient net = this.mc.field_71439_g.field_71174_a;
        List plInfo = net.field_147303_b;
        List players = this.mc.field_71441_e.field_73010_i;
        return plInfo.stream().map(i -> players.stream().filter(e -> e.func_70005_c_().equalsIgnoreCase(i.field_78831_a)).findFirst().orElse(null)).filter(e -> e != null).map(EntityPlayer::func_146103_bH).collect(Collectors.toList());
    }

    @Override
    public Proxy getProxy() {
        return this.mc.func_110437_J();
    }

    @Override
    public RenderTypeBuilder<?, ?> getRenderBuilder() {
        return this.renderBuilder;
    }

    @Override
    public AllTagManagers getBuiltinTags() {
        return this.tags;
    }

    @Override
    public BiomeHandler<?> getBiomeHandler() {
        return BiomeHandlerImpl.impl;
    }

    public static class DynTexture
    extends DynamicTexture
    implements DynamicTexture.ITexture {
        private final ResourceLocation loc;
        private final Minecraft mc;
        private static ResourceLocation bound_loc;

        public DynTexture(Minecraft mc) {
            super(1, 1);
            this.loc = mc.func_110434_K().func_110578_a("cpm", (DynamicTexture)this);
            this.mc = mc;
        }

        @Override
        public void bind() {
            GL11.glBindTexture((int)3553, (int)this.func_110552_b());
            bound_loc = this.loc;
            if (this.mc.func_110434_K().func_110581_b(this.loc) == null) {
                this.mc.func_110434_K().func_110579_a(this.loc, (ITextureObject)this);
            }
        }

        @Override
        public void load(Image image) {
            this.func_147631_c();
            TextureUtil.func_110989_a((int)this.func_110552_b(), (BufferedImage)AWTImageIO.toBufferedImage(image), (boolean)false, (boolean)false);
        }

        @Override
        public void free() {
            this.func_147631_c();
            this.mc.func_110434_K().func_147645_c(this.loc);
        }

        public void func_110551_a(IResourceManager resourceManager) throws IOException {
        }

        public static ResourceLocation getBoundLoc() {
            return bound_loc;
        }
    }
}

