/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.tom.cpl.block.entity.ActiveEffect;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.util.Hand;
import com.tom.cpl.util.HandAnimation;
import com.tom.cpl.util.TriConsumer;
import com.tom.cpm.client.ClientProxy;
import com.tom.cpm.common.EntityTypeHandlerImpl;
import com.tom.cpm.common.NetHandlerExt;
import com.tom.cpm.common.PlayerInventory;
import com.tom.cpm.common.WorldImpl;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.render.PlayerModelSetup;
import com.tom.cpm.shared.skin.PlayerTextureLoader;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class PlayerProfile
extends Player<EntityPlayer>
implements NetHandlerExt.IPlayerProfile {
    public static boolean inGui;
    private final GameProfile profile;
    public int encGesture;

    public PlayerProfile(GameProfile profile) {
        this.profile = new GameProfile(profile.getId(), profile.getName());
        PlayerProfile.cloneProperties(profile.getProperties(), this.profile.getProperties());
    }

    @Override
    public SkinType getSkinType() {
        return SkinType.DEFAULT;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.profile == null ? 0 : this.profile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlayerProfile other = (PlayerProfile)obj;
        return !(this.profile == null ? other.profile != null : !this.profile.equals((Object)other.profile));
    }

    @Override
    protected PlayerTextureLoader initTextures() {
        return new PlayerTextureLoader(Minecraft.func_71410_x().func_152342_ad().field_152796_d){

            @Override
            protected CompletableFuture<Void> load0() {
                Map map = Minecraft.func_71410_x().func_152342_ad().func_152788_a(PlayerProfile.this.profile);
                this.defineAll(map, MinecraftProfileTexture::getUrl, MinecraftProfileTexture::getHash);
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    return CompletableFuture.completedFuture(null);
                }
                CompletableFuture<Void> cf = new CompletableFuture<Void>();
                Minecraft.func_71410_x().func_152342_ad().func_152790_a(PlayerProfile.this.profile, (SkinManager.SkinAvailableCallback)new SkinCB(cf, this::defineTexture), true);
                return cf;
            }
        };
    }

    @Override
    public UUID getUUID() {
        return this.profile.getId();
    }

    @Override
    public void updateFromPlayer(EntityPlayer player) {
        this.animState.resetPlayer();
        if (player.func_70608_bn()) {
            this.animState.sleeping = true;
        }
        if (player.field_70128_L) {
            this.animState.dying = true;
        }
        if (player.func_70115_ae() && player.field_70154_o != null && player.field_70154_o.shouldRiderSit()) {
            this.animState.riding = true;
        }
        if (player.func_70093_af()) {
            this.animState.sneaking = true;
        }
        if (player.func_70051_ag()) {
            this.animState.sprinting = true;
        }
        if (player.func_71039_bw() && player.func_71011_bu() != null) {
            this.animState.usingAnimation = HandAnimation.of(player.func_71011_bu().func_77975_n());
        }
        if (player.func_70090_H()) {
            this.animState.retroSwimming = true;
        }
        this.animState.moveAmountX = (float)(player.field_70165_t - player.field_70169_q);
        this.animState.moveAmountY = (float)(player.field_70163_u - player.field_70167_r);
        this.animState.moveAmountZ = (float)(player.field_70161_v - player.field_70166_s);
        this.animState.yaw = player.field_70759_as * 2.0f - player.field_70761_aq;
        this.animState.pitch = player.field_70125_A;
        this.animState.bodyYaw = player.field_70759_as;
        this.animState.encodedState = this.encGesture;
        ItemStack is = player.func_71124_b(4);
        this.animState.hasSkullOnHead = is != null && is.func_77973_b() instanceof ItemSkull;
        this.animState.wearingHelm = is != null;
        this.animState.wearingBody = player.func_71124_b(3) != null;
        this.animState.wearingLegs = player.func_71124_b(2) != null;
        this.animState.wearingBoots = player.func_71124_b(1) != null;
        this.animState.activeHand = this.animState.mainHand = Hand.RIGHT;
        this.animState.hurtTime = player.field_70737_aN;
        this.animState.isOnLadder = player.func_70617_f_();
        this.animState.isBurning = player.func_90999_ad();
        this.animState.inGui = inGui;
        PlayerInventory.setInv(this.animState, player.field_71071_by);
        WorldImpl.setWorld(this.animState, (Entity)player);
        if (player.field_70154_o != null) {
            this.animState.vehicle = EntityTypeHandlerImpl.impl.wrap(player.field_70154_o.getClass());
        }
        player.func_70651_bq().forEach(e -> this.animState.allEffects.add(new ActiveEffect(e.func_76453_d(), e.func_76458_c(), e.func_76459_b(), false)));
        if (player.func_71011_bu() != null && player.func_71011_bu().func_77973_b() instanceof ItemBow) {
            float f = 20.0f;
            float f1 = MathHelper.clamp((float)player.func_71057_bx(), 0.0f, f);
            this.animState.bowPullback = f1 / f;
        }
    }

    @Override
    public void updateFromModel(Object model) {
        if (model instanceof ModelBiped) {
            ModelBiped m = (ModelBiped)model;
            this.animState.resetModel();
            this.animState.attackTime = m.field_78095_p;
            this.animState.leftArm = PlayerModelSetup.ArmPose.EMPTY;
            if (m.field_78120_m == 1) {
                this.animState.rightArm = PlayerModelSetup.ArmPose.ITEM;
            } else if (m.field_78120_m == 3) {
                this.animState.rightArm = PlayerModelSetup.ArmPose.BLOCK;
            }
            if (m.field_78119_l == 1) {
                this.animState.leftArm = PlayerModelSetup.ArmPose.ITEM;
            } else if (m.field_78119_l == 3) {
                this.animState.leftArm = PlayerModelSetup.ArmPose.BLOCK;
            }
            if (m.field_78118_o) {
                this.animState.rightArm = PlayerModelSetup.ArmPose.BOW_AND_ARROW;
            }
        }
    }

    @Override
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public Object getGameProfile() {
        return this.profile;
    }

    @Override
    public void setEncGesture(int g) {
        this.encGesture = g;
    }

    public class SkinCB
    implements SkinManager.SkinAvailableCallback {
        private final CompletableFuture<Void> cf;
        private final TriConsumer<MinecraftProfileTexture.Type, String, String> define;

        public SkinCB(CompletableFuture<Void> cf, TriConsumer<MinecraftProfileTexture.Type, String, String> define) {
            this.cf = cf;
            this.define = define;
        }

        public void func_152121_a(MinecraftProfileTexture.Type p_152121_1_, ResourceLocation p_152121_2_) {
        }

        public void skinAvailable(MinecraftProfileTexture.Type typeIn, ResourceLocation location, MinecraftProfileTexture profileTexture) {
            this.define.accept(typeIn, profileTexture.getUrl(), profileTexture.getHash());
            switch (typeIn) {
                case SKIN: {
                    ClientProxy.mc.getDefinitionLoader().execute(() -> Minecraft.func_71410_x().func_152344_a(() -> this.cf.complete(null)));
                    break;
                }
            }
        }
    }
}

