/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.DirectBuffer;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.shared.retro.RetroGLAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RetroGL
implements RetroGLAccess<ResourceLocation> {
    public static final RetroTessellator tessellator = new RetroTessellator(Tessellator.field_78398_a);
    public static int renderCallLoc;
    public static final int GLINT_OVERLAY_LOC = 2;
    public static final int HURT_OVERLAY_LOC = 3;
    private static final RenderStage lines;
    private static final RenderStage color;
    private static float lx;
    private static float ly;
    private static float red;
    private static float green;
    private static float blue;
    private static float alpha;

    public RenderStage texture(ResourceLocation tex) {
        return new RenderStage(true, true, true, () -> {
            RetroGL.bindTex(tex);
            if (renderCallLoc != 2) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
        }, () -> {}, 7);
    }

    public RenderStage eyes(ResourceLocation tex) {
        return new RenderStage(true, true, true, () -> {
            if (renderCallLoc == 3) {
                return;
            }
            lx = OpenGlHelper.lastBrightnessX;
            ly = OpenGlHelper.lastBrightnessY;
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            GL11.glBlendFunc((int)1, (int)1);
            GL11.glDepthMask((boolean)true);
            int i = 240;
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            RetroGL.bindTex(tex);
        }, () -> {
            if (renderCallLoc == 3) {
                return;
            }
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lx, (float)ly);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glEnable((int)3008);
        }, 7);
    }

    @Override
    public RenderStage linesNoDepth() {
        return lines;
    }

    @Override
    public RenderStage color() {
        return color;
    }

    private static void bindTex(ResourceLocation tex) {
        if (tex != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(tex);
        }
    }

    public static VertexBuffer buffer(VBuffers.NativeRenderType type) {
        RenderStage stage = (RenderStage)type.getNativeType();
        return new RetroBuffer(tessellator, stage);
    }

    public static Vec4f getColor() {
        return new Vec4f(red, green, blue, alpha);
    }

    public static void color4f(float r, float g, float b, float a) {
        red = r;
        green = g;
        blue = b;
        alpha = a;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    @Override
    public ResourceLocation getDynTexture() {
        return MinecraftObject.DynTexture.getBoundLoc();
    }

    static {
        lines = new RenderStage(true, false, false, () -> {
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
        }, () -> {
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2929);
        }, 1);
        color = new RenderStage(true, false, false, () -> GL11.glDisable((int)3553), () -> GL11.glEnable((int)3553), 7);
    }

    public static class RetroTessellator {
        private Tessellator t;
        private double x;
        private double y;
        private double z;

        public RetroTessellator(Tessellator t) {
            this.t = t;
        }

        public RetroTessellator tex(float i, float j) {
            this.t.func_78385_a((double)i, (double)j);
            return this;
        }

        public void endVertex() {
            this.t.func_78377_a(this.x, this.y, this.z);
        }

        public void begin(int p_78371_1_) {
            this.t.func_78371_b(p_78371_1_);
        }

        public RetroTessellator pos(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public RetroTessellator color(float p_78369_1_, float p_78369_2_, float p_78369_3_, float p_78369_4_) {
            this.t.func_78369_a(p_78369_1_, p_78369_2_, p_78369_3_, p_78369_4_);
            return this;
        }

        public RetroTessellator normal(float p_78375_1_, float p_78375_2_, float p_78375_3_) {
            this.t.func_78375_b(p_78375_1_, p_78375_2_, p_78375_3_);
            return this;
        }

        public int draw() {
            return this.t.func_78381_a();
        }
    }

    private static class RetroBuffer
    extends DirectBuffer<RetroTessellator> {
        private RenderStage stage;

        public RetroBuffer(RetroTessellator tes, RenderStage stage) {
            super(tes);
            this.stage = stage;
            stage.begin((RetroTessellator)this.buffer);
        }

        @Override
        protected void pushVertex(float x, float y, float z, float red, float green, float blue, float alpha, float u, float v, float nx, float ny, float nz) {
            ((RetroTessellator)this.buffer).pos(x, y, z);
            if (this.stage.texture) {
                ((RetroTessellator)this.buffer).tex(u, v);
            }
            if (this.stage.color) {
                ((RetroTessellator)this.buffer).color(red, green, blue, alpha);
            }
            if (this.stage.normal) {
                ((RetroTessellator)this.buffer).normal(nx, ny, nz);
            }
            ((RetroTessellator)this.buffer).endVertex();
        }

        @Override
        public void finish() {
            ((RetroTessellator)this.buffer).draw();
            this.stage.end();
        }
    }

    private static class RenderStage
    implements RetroGLAccess.RetroLayer {
        private boolean color;
        private boolean texture;
        private boolean normal;
        private Runnable begin;
        private Runnable end;
        private int glMode;

        public RenderStage(boolean color, boolean texture, boolean normal, Runnable begin, Runnable end, int glMode) {
            this.color = color;
            this.texture = texture;
            this.normal = normal;
            this.begin = begin;
            this.end = end;
            this.glMode = glMode;
        }

        public void begin(RetroTessellator buf) {
            this.begin.run();
            buf.begin(this.glMode);
        }

        public void end() {
            this.end.run();
        }
    }
}

