/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpl.block.BlockState;
import com.tom.cpl.block.BlockStateHandler;
import com.tom.cpl.item.Stack;
import com.tom.cpm.common.BlockMeta;
import com.tom.cpm.common.ItemStackHandlerImpl;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class BlockStateHandlerImpl
extends BlockStateHandler<BlockMeta> {
    public static final String META = "metadata";
    public static final List<String> STATES = Collections.singletonList("metadata");
    public static final List<String> META_VALUES = new ArrayList<String>();
    public static final BlockStateHandlerImpl impl = new BlockStateHandlerImpl();

    @Override
    public String getBlockId(BlockMeta stack) {
        return stack.getBlock().delegate.name();
    }

    @Override
    public List<String> getBlockStates(BlockMeta stack) {
        return STATES;
    }

    @Override
    public String getPropertyValue(BlockMeta state, String property) {
        if (property.equals(META)) {
            return String.valueOf(state.getMeta());
        }
        return null;
    }

    @Override
    public int getPropertyValueInt(BlockMeta state, String property) {
        if (property.equals(META)) {
            return state.getMeta();
        }
        return -1;
    }

    @Override
    public List<String> getAllValuesFor(BlockMeta state, String property) {
        if (property.equals(META)) {
            return META_VALUES;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> listTags(BlockMeta stack) {
        return Collections.emptyList();
    }

    @Override
    public List<BlockState> listNativeEntries(String tag) {
        if (tag.charAt(0) == '#') {
            return Collections.emptyList();
        }
        ArrayList<BlockState> stacks = new ArrayList<BlockState>();
        ResourceLocation rl = ItemStackHandlerImpl.tryParse(tag);
        Block item = (Block)GameData.getBlockRegistry().func_82594_a((Object)rl);
        if (item != null) {
            stacks.add(this.wrap(new BlockMeta(item, 0)));
        }
        return stacks;
    }

    @Override
    public List<String> listNativeTags() {
        return Collections.emptyList();
    }

    @Override
    public List<BlockState> getAllElements() {
        Iterator itr = GameData.getBlockRegistry().iterator();
        ArrayList<BlockState> list = new ArrayList<BlockState>();
        while (itr.hasNext()) {
            Block block = (Block)itr.next();
            list.add(this.wrap(new BlockMeta(block, 0)));
        }
        return list;
    }

    @Override
    public boolean isInTag(String tag, BlockMeta stack) {
        if (tag.charAt(0) == '#') {
            return false;
        }
        return this.getBlockId(stack).equals(tag);
    }

    @Override
    public boolean equals(BlockMeta a, BlockMeta b) {
        return a.getBlock() == b.getBlock();
    }

    @Override
    public Stack getStackFromState(BlockMeta state) {
        return ItemStackHandlerImpl.impl.wrap(new ItemStack(state.getBlock()));
    }

    @Override
    public boolean equalsFull(BlockMeta a, BlockMeta b) {
        return a.equals(b);
    }

    @Override
    public BlockState emptyObject() {
        return this.wrap(new BlockMeta(Blocks.field_150350_a, 0));
    }

    static {
        for (int i = 0; i < 16; ++i) {
            META_VALUES.add(String.valueOf(i));
        }
    }
}

