/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.config.PlayerData;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.network.IC2SPacket;
import com.tom.cpm.shared.network.IS2CPacket;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import java.io.IOException;
import java.util.function.BiFunction;

public class NetHandlerExt<RL, P, N>
extends NetHandler<RL, P, N> {
    public static final String SKIN_LAYERS = "layer";

    public NetHandlerExt(BiFunction<String, String, RL> keyFactory) {
        super(keyFactory);
        this.register(this.packetC2S, SKIN_LAYERS, LayerC2S.class, LayerC2S::new);
        this.register(this.packetS2C, SKIN_LAYERS, LayerS2C.class, LayerS2C::new);
    }

    @Override
    public void sendPlayerData(P target, P to) {
        super.sendPlayerData(target, to);
        NetH.ServerNetH netTo = this.getSNetH(to);
        PlayerDataExt dt = (PlayerDataExt)this.getSNetH(target).cpm$getEncodedModelData();
        if (dt == null) {
            return;
        }
        this.sendPacketTo(netTo, new LayerS2C(this.getPlayerId(target), dt.getSkinLayer()));
    }

    @Override
    protected PlayerData newData() {
        return new PlayerDataExt();
    }

    public void sendLayer(int value) {
        if (this.hasModClient()) {
            this.sendPacketToServer(new LayerC2S(value));
        }
    }

    public static interface IPlayerProfile {
        public void setEncGesture(int var1);
    }

    public static class PlayerDataExt
    extends PlayerData {
        private int skinLayer;

        public void setSkinLayer(int skinLayer) {
            this.skinLayer = skinLayer;
        }

        public int getSkinLayer() {
            return this.skinLayer;
        }
    }

    public static class LayerS2C
    implements IS2CPacket {
        private int entId;
        private int layer;

        public LayerS2C() {
        }

        public LayerS2C(int entId, int layer) {
            this.entId = entId;
            this.layer = layer;
        }

        @Override
        public void read(IOHelper pb) throws IOException {
            this.entId = pb.readVarInt();
            this.layer = pb.readByte();
        }

        @Override
        public void write(IOHelper pb) throws IOException {
            pb.writeVarInt(this.entId);
            pb.writeByte(this.layer);
        }

        @Override
        public void handle(NetHandler<?, ?, ?> handler, NetH from) {
            this.handle0(handler, from);
        }

        private <P> void handle0(NetHandler<?, P, ?> handler, NetH from) {
            P ent = handler.getPlayerById(this.entId);
            IPlayerProfile profile = (IPlayerProfile)((Object)MinecraftClientAccess.get().getDefinitionLoader().loadPlayer(handler.getLoaderId(ent), "player"));
            profile.setEncGesture(this.layer);
        }
    }

    public static class LayerC2S
    implements IC2SPacket {
        private int layer;

        public LayerC2S(int layer) {
            this.layer = layer;
        }

        public LayerC2S() {
        }

        @Override
        public void read(IOHelper pb) throws IOException {
            this.layer = pb.readByte();
        }

        @Override
        public void write(IOHelper pb) throws IOException {
            pb.writeByte(this.layer);
        }

        @Override
        public <P> void handle(NetHandler<?, P, ?> handler, NetH.ServerNetH from, P pl) {
            PlayerDataExt dt = (PlayerDataExt)handler.getSNetH(pl).cpm$getEncodedModelData();
            dt.setSkinLayer(this.layer);
            handler.sendPacketToTracking(pl, new LayerS2C(handler.getPlayerId(pl), this.layer));
        }
    }
}

