/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.template.args;

import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.template.Template;
import java.util.List;
import java.util.Map;

public abstract class ArgBase
implements Template.IArg {
    private String name;

    public ArgBase() {
    }

    public ArgBase(String name) {
        this.name = name;
    }

    @Override
    public void write(Map<String, Object> map) {
        map.put("value", this.toJson());
    }

    @Override
    public void load(Map<String, Object> map) {
        this.fromJson(map.get("value"));
    }

    @Override
    public void init(Map<String, Object> map) {
        this.name = (String)map.get("name");
        this.fromJson(map.get("default"));
    }

    public abstract Object toJson();

    public abstract void fromJson(Object var1);

    @Override
    public void apply(Map<String, Object> map) {
        this.walk(map);
    }

    private void walk(Object v) {
        String key = ArgBase.wrapName(this.name);
        if (v instanceof List) {
            ((List)v).replaceAll(e -> {
                if (key.equals(v)) {
                    return this.toJson();
                }
                this.walk(e);
                return e;
            });
        } else if (v instanceof Map) {
            ((Map)v).replaceAll((k, e) -> {
                if (key.equals(e)) {
                    return this.toJson();
                }
                this.walk(e);
                return e;
            });
        }
    }

    @Override
    public void apply(RenderedCube cube) {
    }

    @Override
    public void export(Map<String, Object> map) {
        map.put("default", this.toJson());
        map.put("name", this.name);
    }

    public static String wrapName(String name) {
        return "${" + name + "}$";
    }

    public String getName() {
        return this.name;
    }
}

