/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmcore;

import com.tom.cpm.shared.config.PlayerData;
import com.tom.cpm.shared.network.NetH;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CPMTransformerService
implements IClassTransformer {
    public static final Logger LOG = LogManager.getLogger((String)"CPM Core");
    private static final String HOOKS_CLASS = "com/tom/cpmcore/CPMASMClientHooks";
    private static final String HOOKS_CLASS_SERVER = "com/tom/cpmcore/CPMASMServerHooks";
    private static final String NO_MODEL_SETUP_FIELD = "cpm$noModelSetup";
    private static final String HAS_MOD_FIELD = "cpm$hasMod";
    private static final String DATA_FIELD = "cpm$data";
    private static Map<String, UnaryOperator<ClassNode>> transformers;

    public static void init() {
        transformers = new HashMap<String, UnaryOperator<ClassNode>>();
        transformers.put("net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                InsnList lst = new InsnList();
                int modelBase = 8;
                lst.add((AbstractInsnNode)new VarInsnNode(25, modelBase));
                lst.add((AbstractInsnNode)new VarInsnNode(25, 7));
                lst.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "renderSkull", "(Lnet/minecraft/client/model/ModelBase;Lcom/mojang/authlib/GameProfile;)V", false));
                InsnList lst2 = new InsnList();
                lst2.add((AbstractInsnNode)new VarInsnNode(25, modelBase));
                lst2.add((AbstractInsnNode)new VarInsnNode(25, 7));
                lst2.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "renderSkullPost", "(Lnet/minecraft/client/model/ModelBase;Lcom/mojang/authlib/GameProfile;)V", false));
                MethodNode m = null;
                for (MethodNode method : input.methods) {
                    if (!method.desc.equals("(FFFIFILcom/mojang/authlib/GameProfile;)V")) continue;
                    m = method;
                    LOG.info("CPM Skull Hook: found method");
                    break;
                }
                for (AbstractInsnNode insnNode : m.instructions) {
                    if (insnNode instanceof VarInsnNode) {
                        VarInsnNode nd = (VarInsnNode)insnNode;
                        if (nd.getOpcode() != 25 || nd.var != modelBase) continue;
                        m.instructions.insertBefore((AbstractInsnNode)nd, lst);
                        LOG.info("CPM Skull Hook: injected (Pre)");
                        continue;
                    }
                    if (!(insnNode instanceof InsnNode) || insnNode.getOpcode() != 177) continue;
                    m.instructions.insertBefore(insnNode, lst2);
                    LOG.info("CPM Skull Hook: injected (Post)");
                }
                return input;
            }
        });
        transformers.put("net.minecraft.client.resources.SkinManager", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                for (MethodNode m : input.methods) {
                    if ((!m.name.equals("a") || !m.desc.equals("(Lcom/mojang/authlib/minecraft/MinecraftProfileTexture;Lcom/mojang/authlib/minecraft/MinecraftProfileTexture$Type;Lbro;)Lbqx;")) && !m.name.equals("func_152789_a")) continue;
                    LOG.info("CPM Load Skin Hook: Found loadSkin method");
                    InsnList lst = new InsnList();
                    lst.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    lst.add((AbstractInsnNode)new VarInsnNode(25, 2));
                    lst.add((AbstractInsnNode)new VarInsnNode(25, 3));
                    lst.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "loadSkinHook", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])Type.getArgumentTypes((String)m.desc)), false));
                    m.instructions.insertBefore(m.instructions.getFirst(), lst);
                    LOG.info("CPM Load Skin Hook: injected");
                    break;
                }
                return input;
            }
        });
        transformers.put("net.minecraft.client.renderer.entity.RendererLivingEntity", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                for (MethodNode m : input.methods) {
                    if ((!m.name.equals("a") || !m.desc.equals("(Lsv;DDDFF)V")) && !m.name.equals("doRender")) continue;
                    LOG.info("CPM Armor Hook: Found doRender method");
                    m.instructions.insertBefore(m.instructions.getFirst(), (AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "prePlayerRender", "()V", false));
                    int callLoc = 0;
                    for (AbstractInsnNode insnNode : m.instructions) {
                        if (!(insnNode instanceof MethodInsnNode)) continue;
                        MethodInsnNode mn = (MethodInsnNode)insnNode;
                        if (mn.name.equals("a") && mn.desc.equals("(Lsa;FFFFFF)V") || mn.name.equals("render")) {
                            LOG.info("CPM Armor Hook: Found render call");
                            Type[] argsD = Type.getArgumentTypes((String)mn.desc);
                            Type[] args = new Type[argsD.length + 3];
                            args[0] = Type.getObjectType((String)mn.owner);
                            System.arraycopy(argsD, 0, args, 1, argsD.length);
                            args[args.length - 2] = Type.getType((String)"Lnet/minecraft/client/renderer/entity/RendererLivingEntity;");
                            args[args.length - 1] = Type.INT_TYPE;
                            mn.desc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])args);
                            mn.name = "renderPass";
                            mn.setOpcode(184);
                            mn.owner = CPMTransformerService.HOOKS_CLASS;
                            InsnList lst = new InsnList();
                            lst.add((AbstractInsnNode)new VarInsnNode(25, 0));
                            lst.add((AbstractInsnNode)new LdcInsnNode((Object)callLoc++));
                            m.instructions.insertBefore(insnNode, lst);
                            LOG.info("CPM Armor Hook/Layer: injected");
                            continue;
                        }
                        if (!mn.name.equals("glColor4f")) continue;
                        mn.owner = CPMTransformerService.HOOKS_CLASS;
                        LOG.info("CPM Player Renderer/Color hook: injected");
                    }
                }
                return input;
            }
        });
        transformers.put("com.tom.cpmcore.CPMClientAccess", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                for (MethodNode method : input.methods) {
                    if (!method.name.equals("setNoSetup")) continue;
                    method.instructions.clear();
                    method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    method.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
                    method.instructions.add((AbstractInsnNode)new FieldInsnNode(181, Type.getArgumentTypes((String)method.desc)[0].getInternalName(), CPMTransformerService.NO_MODEL_SETUP_FIELD, "Z"));
                    method.instructions.add((AbstractInsnNode)new InsnNode(177));
                    LOG.info("CPM ASM fields/No Render: injected");
                }
                return input;
            }
        });
        transformers.put("net.minecraft.client.model.ModelBiped", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                input.fields.add(new FieldNode(1, CPMTransformerService.NO_MODEL_SETUP_FIELD, "Z", null, (Object)0));
                for (MethodNode method : input.methods) {
                    if ((!method.name.equals("a") || !method.desc.equals("(FFFFFFLsa;)V")) && !method.name.equals("setRotationAngles")) continue;
                    LOG.info("CPM Armor Hook/No setup: found setRotationAngles method");
                    InsnList lst = new InsnList();
                    lst.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    lst.add((AbstractInsnNode)new FieldInsnNode(180, input.name, CPMTransformerService.NO_MODEL_SETUP_FIELD, "Z"));
                    LabelNode lbln = new LabelNode();
                    lst.add((AbstractInsnNode)new JumpInsnNode(153, lbln));
                    lst.add((AbstractInsnNode)new InsnNode(177));
                    lst.add((AbstractInsnNode)lbln);
                    method.instructions.insertBefore(method.instructions.getFirst(), lst);
                    LOG.info("CPM Armor Hook/No setup: injected");
                }
                return input;
            }
        });
        transformers.put("net.minecraft.client.Minecraft", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                InsnList lst = new InsnList();
                lst.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onLogout", "()V", false));
                for (MethodNode method : input.methods) {
                    if (!method.name.equals("loadWorld") && (!method.name.equals("a") || !method.desc.equals("(Lbjf;Ljava/lang/String;)V"))) continue;
                    LOG.info("CPM ClientLogout Hook: Found loadWorld");
                    for (AbstractInsnNode insnNode : method.instructions) {
                        if (!(insnNode instanceof MethodInsnNode)) continue;
                        MethodInsnNode mn = (MethodInsnNode)insnNode;
                        if ((!mn.name.equals("b") || !mn.desc.equals("()V") || !(mn.getPrevious() instanceof FieldInsnNode) || !((FieldInsnNode)mn.getPrevious()).name.equals("q")) && !mn.name.equals("func_146257_b")) continue;
                        method.instructions.insert((AbstractInsnNode)mn, lst);
                        LOG.info("CPM ClientLogout Hook: injected");
                    }
                }
                return input;
            }
        });
        transformers.put("net.minecraft.client.network.NetHandlerPlayClient", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                InsnList lst = new InsnList();
                lst.add((AbstractInsnNode)new VarInsnNode(25, 1));
                lst.add((AbstractInsnNode)new VarInsnNode(25, 0));
                lst.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onClientPacket", "(Lnet/minecraft/network/play/server/S3FPacketCustomPayload;Lnet/minecraft/client/network/NetHandlerPlayClient;)Z", false));
                LabelNode lbln = new LabelNode();
                lst.add((AbstractInsnNode)new JumpInsnNode(153, lbln));
                lst.add((AbstractInsnNode)new InsnNode(177));
                lst.add((AbstractInsnNode)lbln);
                input.interfaces.add(Type.getInternalName(NetH.class));
                input.fields.add(new FieldNode(1, CPMTransformerService.HAS_MOD_FIELD, "Z", null, (Object)0));
                for (MethodNode method : input.methods) {
                    if (!method.name.equals("handleCustomPayload") && (!method.name.equals("a") || !method.desc.equals("(Lgr;)V"))) continue;
                    LOG.info("CPM ClientNet Hook: Found handleCustomPayload");
                    method.instructions.insertBefore(method.instructions.getFirst(), lst);
                    LOG.info("CPM ClientNet Hook: injected");
                }
                CPMTransformerService.injectHasMod("ClientNet", input);
                return input;
            }
        });
        transformers.put("net.minecraft.network.NetHandlerPlayServer", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                InsnList lst = new InsnList();
                lst.add((AbstractInsnNode)new VarInsnNode(25, 1));
                lst.add((AbstractInsnNode)new VarInsnNode(25, 0));
                lst.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS_SERVER, "onServerPacket", "(Lnet/minecraft/network/play/client/C17PacketCustomPayload;Lnet/minecraft/network/NetHandlerPlayServer;)Z", false));
                LabelNode lbln = new LabelNode();
                lst.add((AbstractInsnNode)new JumpInsnNode(153, lbln));
                lst.add((AbstractInsnNode)new InsnNode(177));
                lst.add((AbstractInsnNode)lbln);
                input.interfaces.add(Type.getInternalName(NetH.ServerNetH.class));
                input.fields.add(new FieldNode(1, CPMTransformerService.HAS_MOD_FIELD, "Z", null, (Object)0));
                input.fields.add(new FieldNode(1, CPMTransformerService.DATA_FIELD, Type.getDescriptor(PlayerData.class), null, null));
                for (MethodNode method : input.methods) {
                    if (!method.name.equals("processVanilla250Packet") && (!method.name.equals("a") || !method.desc.equals("(Liz;)V"))) continue;
                    LOG.info("CPM ServerNet Hook: Found processCustomPayload");
                    method.instructions.insertBefore(method.instructions.getFirst(), lst);
                    LOG.info("CPM ServerNet Hook: injected");
                }
                CPMTransformerService.injectHasMod("ServerNet", input);
                MethodNode method = new MethodNode(1, "cpm$getEncodedModelData", Type.getMethodDescriptor((Type)Type.getType(PlayerData.class), (Type[])new Type[0]), null, null);
                input.methods.add(method);
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, input.name, CPMTransformerService.DATA_FIELD, Type.getDescriptor(PlayerData.class)));
                method.instructions.add((AbstractInsnNode)new InsnNode(176));
                method.maxLocals = 2;
                method.maxStack = 2;
                LOG.info("CPM ServerNet/getData: injected");
                method = new MethodNode(1, "cpm$setEncodedModelData", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(PlayerData.class)}), null, null);
                input.methods.add(method);
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                method.instructions.add((AbstractInsnNode)new FieldInsnNode(181, input.name, CPMTransformerService.DATA_FIELD, Type.getDescriptor(PlayerData.class)));
                method.instructions.add((AbstractInsnNode)new InsnNode(177));
                method.maxLocals = 2;
                method.maxStack = 2;
                LOG.info("CPM ServerNet/setData: injected");
                return input;
            }
        });
        transformers.put("net.minecraft.client.renderer.entity.RenderPlayer", new UnaryOperator<ClassNode>(){

            @Override
            public ClassNode apply(ClassNode input) {
                boolean isDeobf = false;
                input.interfaces.add("com/tom/cpmcore/IPlayerRenderer");
                for (MethodNode method : input.methods) {
                    FieldInsnNode mn;
                    if (method.name.equals("renderEquippedItems") || method.name.equals("a") && method.desc.equals("(Lblg;F)V")) {
                        LOG.info("CPM Cape Hook: Found renderEquippedItems");
                        for (AbstractInsnNode insnNode : method.instructions) {
                            if (!(insnNode instanceof FieldInsnNode)) continue;
                            mn = (FieldInsnNode)insnNode;
                            if (!mn.owner.equals("net/minecraftforge/client/event/RenderPlayerEvent$Specials$Pre") || !mn.name.equals("renderCape")) continue;
                            LOG.info("CPM Cape Hook: Found renderCape");
                            InsnList lst = new InsnList();
                            lst.add((AbstractInsnNode)new VarInsnNode(25, 0));
                            lst.add((AbstractInsnNode)new VarInsnNode(25, 1));
                            lst.add((AbstractInsnNode)new VarInsnNode(23, 2));
                            lst.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "renderCape", "(ZLnet/minecraft/client/renderer/entity/RenderPlayer;Lnet/minecraft/client/entity/AbstractClientPlayer;F)Z", false));
                            method.instructions.insert(insnNode, lst);
                        }
                    }
                    if (method.name.equals("renderFirstPersonArm") || method.name.equals("a") && method.desc.equals("(Lyz;)V")) {
                        LOG.info("CPM Hand Hook: Found renderFirstPersonArm");
                        if (method.name.equals("renderFirstPersonArm")) {
                            isDeobf = true;
                        }
                        InsnList lst = new InsnList();
                        lst.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        lst.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        lst.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onHandPre", "(Lnet/minecraft/client/renderer/entity/RenderPlayer;Lnet/minecraft/entity/player/EntityPlayer;)V", false));
                        method.instructions.insertBefore(method.instructions.getFirst(), lst);
                        LOG.info("CPM Render Hand Hook Pre: injected");
                        InsnList lst2 = new InsnList();
                        lst2.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        lst2.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        lst2.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onHandPost", "(Lnet/minecraft/client/renderer/entity/RenderPlayer;Lnet/minecraft/entity/player/EntityPlayer;)V", false));
                        for (AbstractInsnNode insnNode : method.instructions) {
                            if (!(insnNode instanceof InsnNode) || insnNode.getOpcode() != 177) continue;
                            method.instructions.insertBefore(insnNode, lst2);
                            LOG.info("CPM Render Hand Hook Post: injected");
                        }
                    }
                    for (AbstractInsnNode insnNode : method.instructions) {
                        if (!(insnNode instanceof MethodInsnNode)) continue;
                        mn = (MethodInsnNode)insnNode;
                        if (mn.name.equals("glColor4f")) {
                            mn.owner = CPMTransformerService.HOOKS_CLASS;
                            LOG.info("CPM Player Renderer/Color hook: injected");
                            continue;
                        }
                        if (!mn.name.equals("glColor3f")) continue;
                        mn.owner = CPMTransformerService.HOOKS_CLASS;
                        LOG.info("CPM Player Renderer/Color hook: injected");
                    }
                }
                String name = isDeobf ? "renderModel" : "func_77036_a";
                LOG.info("CPM Render Invis Hook: Injecting method " + (isDeobf ? "deobf" : ""));
                MethodNode mn = new MethodNode(1, name, "(Lnet/minecraft/entity/EntityLivingBase;FFFFFF)V", null, null);
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 3));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 4));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 5));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 6));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 7));
                mn.instructions.add((AbstractInsnNode)new MethodInsnNode(184, CPMTransformerService.HOOKS_CLASS, "onRenderPlayerModel", "(Lnet/minecraft/client/renderer/entity/RenderPlayer;Lnet/minecraft/entity/EntityLivingBase;FFFFFF)Z", false));
                LabelNode lbln = new LabelNode();
                mn.instructions.add((AbstractInsnNode)new JumpInsnNode(153, lbln));
                mn.instructions.add((AbstractInsnNode)new InsnNode(177));
                mn.instructions.add((AbstractInsnNode)lbln);
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 3));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 4));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 5));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 6));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 7));
                mn.instructions.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/client/renderer/entity/RendererLivingEntity", name, "(Lnet/minecraft/entity/EntityLivingBase;FFFFFF)V", false));
                mn.instructions.add((AbstractInsnNode)new InsnNode(177));
                input.methods.add(mn);
                LOG.info("CPM Render Invis Hook: injected");
                name = isDeobf ? "bindEntityTexture" : "func_110777_b";
                mn = new MethodNode(1, "cpm$bindEntityTexture", "(Lnet/minecraft/client/entity/AbstractClientPlayer;)V", null, null);
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, input.name, name, "(Lnet/minecraft/entity/Entity;)V", false));
                mn.instructions.add((AbstractInsnNode)new InsnNode(177));
                input.methods.add(mn);
                LOG.info("CPM Render Invis Hook/Bind Texture: injected");
                return input;
            }
        });
    }

    private static void injectHasMod(String name, ClassNode input) {
        MethodNode method = new MethodNode(1, HAS_MOD_FIELD, "()Z", null, null);
        input.methods.add(method);
        method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        method.instructions.add((AbstractInsnNode)new FieldInsnNode(180, input.name, HAS_MOD_FIELD, "Z"));
        method.instructions.add((AbstractInsnNode)new InsnNode(172));
        method.maxLocals = 2;
        method.maxStack = 2;
        LOG.info("CPM " + name + "/hasMod: injected");
        method = new MethodNode(1, "cpm$setHasMod", "(Z)V", null, null);
        input.methods.add(method);
        method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        method.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        method.instructions.add((AbstractInsnNode)new FieldInsnNode(181, input.name, HAS_MOD_FIELD, "Z"));
        method.instructions.add((AbstractInsnNode)new InsnNode(177));
        method.maxLocals = 2;
        method.maxStack = 2;
        LOG.info("CPM " + name + "/setHasMod: injected");
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformers == null) {
            return basicClass;
        }
        UnaryOperator<ClassNode> tr = transformers.get(transformedName);
        if (tr != null) {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            LOG.info("Applying cpm transformer: " + transformedName);
            classNode = (ClassNode)tr.apply(classNode);
            ClassWriter writer = new ClassWriter(0);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }
}

