/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.math.Box;
import java.util.function.Consumer;

public class InputPopup
extends PopupPanel
implements Runnable {
    private boolean okPressed;
    private Frame frm;
    private String title;
    private TextField inputField;
    private Consumer<String> ok;

    public InputPopup(Frame frame, String msg, Consumer<String> ok, Runnable cancel) {
        this(frame, frame.getGui().i18nFormat("label.cpm.input", new Object[0]), msg, ok, cancel);
    }

    public InputPopup(Frame frame, String title, String msg, Consumer<String> ok, Runnable cancel) {
        super(frame.getGui());
        int w;
        int i;
        this.frm = frame;
        this.title = title;
        this.ok = ok;
        String[] lines = msg.split("\\\\");
        int wm = 180;
        for (i = 0; i < lines.length; ++i) {
            w = this.gui.textWidth(lines[i]);
            if (w <= wm) continue;
            wm = w;
        }
        for (i = 0; i < lines.length; ++i) {
            w = this.gui.textWidth(lines[i]);
            this.addElement(new Label(this.gui, lines[i]).setBounds(new Box(wm / 2 - w / 2 + 10, 5 + i * 10, 0, 0)));
        }
        this.setBounds(new Box(0, 0, wm + 20, 70 + lines.length * 10));
        this.inputField = new TextField(this.gui);
        this.inputField.setBounds(new Box(5, 20 + lines.length * 10, wm + 10, 20));
        this.addElement(this.inputField);
        Button btn = new Button(this.gui, this.gui.i18nFormat("button.cpm.ok", new Object[0]), this::okPressed);
        Button btnNo = new Button(this.gui, this.gui.i18nFormat("button.cpm.cancel", new Object[0]), () -> {
            this.close();
            if (cancel != null) {
                cancel.run();
            }
            this.inputField.setText("");
        });
        btn.setBounds(new Box(5, 45 + lines.length * 10, 40, 20));
        btnNo.setBounds(new Box(50, 45 + lines.length * 10, 40, 20));
        this.addElement(btn);
        this.addElement(btnNo);
        this.setOnClosed(() -> {
            if (cancel != null && !this.okPressed) {
                cancel.run();
            }
            this.inputField.setText("");
        });
    }

    private void okPressed() {
        this.okPressed = true;
        String text = this.inputField.getText();
        this.close();
        this.ok.accept(text);
        this.inputField.setText("");
    }

    @Override
    public void run() {
        this.frm.openPopup(this);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        if (event.matches(this.gui.getKeyCodes().KEY_ENTER)) {
            this.okPressed();
            event.consume();
        }
        super.keyPressed(event);
    }
}

