/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.nbt;

import com.tom.cpl.item.NbtMapper;
import com.tom.cpl.nbt.NBTTag;
import com.tom.cpl.nbt.NBTTagByte;
import com.tom.cpl.nbt.NBTTagByteArray;
import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpl.nbt.NBTTagDouble;
import com.tom.cpl.nbt.NBTTagFloat;
import com.tom.cpl.nbt.NBTTagInt;
import com.tom.cpl.nbt.NBTTagIntArray;
import com.tom.cpl.nbt.NBTTagList;
import com.tom.cpl.nbt.NBTTagLong;
import com.tom.cpl.nbt.NBTTagLongArray;
import com.tom.cpl.nbt.NBTTagShort;
import com.tom.cpl.nbt.NBTTagString;

public class MappedNBTCompound<C>
extends NBTTagCompound {
    private final NbtMapper<?, C, ?, ?> mapper;
    private final C compoundIn;

    public MappedNBTCompound(NbtMapper<?, C, ?, ?> mapper, C compoundIn) {
        this.mapper = mapper;
        this.compoundIn = compoundIn;
    }

    @Override
    protected void loadLazy() {
        this.load0();
    }

    private <T, L, N> void load0() {
        NbtMapper<?, C, ?, ?> mapper = this.mapper;
        for (String key : mapper.keys(this.compoundIn)) {
            Object tag = mapper.getTag(this.compoundIn, key);
            NBTTag m = MappedNBTCompound.mapTag(mapper, tag);
            if (m == null) continue;
            this.setTag(key, m);
        }
    }

    private static <T, C, L, N> NBTTag mapTag(NbtMapper<T, C, L, N> mapper, T tag) {
        int id = mapper.getId(tag);
        N n = mapper.asNumber(tag);
        if (n != null) {
            switch (id) {
                case 1: {
                    return new NBTTagByte(mapper.getByte(n));
                }
                case 2: {
                    return new NBTTagShort(mapper.getShort(n));
                }
                case 3: {
                    return new NBTTagInt(mapper.getInt(n));
                }
                case 4: {
                    return new NBTTagLong(mapper.getLong(n));
                }
                case 5: {
                    return new NBTTagFloat(mapper.getFloat(n));
                }
                case 6: {
                    return new NBTTagDouble(mapper.getDouble(n));
                }
            }
            return null;
        }
        switch (id) {
            case 7: {
                return new NBTTagByteArray(mapper.getByteArray(tag));
            }
            case 8: {
                return new NBTTagString(mapper.getString(tag));
            }
            case 9: {
                return new MappedNBTList<L>(mapper, mapper.asList(tag));
            }
            case 10: {
                return new MappedNBTCompound<C>(mapper, mapper.asCompound(tag));
            }
            case 11: {
                return new NBTTagIntArray(mapper.getIntArray(tag));
            }
            case 12: {
                return new NBTTagLongArray(mapper.getLongArray(tag));
            }
        }
        return null;
    }

    public static class MappedNBTList<L>
    extends NBTTagList {
        private final NbtMapper<?, ?, L, ?> mapper;
        private final L listIn;

        public MappedNBTList(NbtMapper<?, ?, L, ?> mapper, L listIn) {
            this.mapper = mapper;
            this.listIn = listIn;
        }

        @Override
        protected void loadLazy() {
            this.load0();
        }

        private <T, C, N> void load0() {
            NbtMapper<?, ?, L, ?> mapper = this.mapper;
            int len = mapper.listSize(this.listIn);
            for (int i = 0; i < len; ++i) {
                Object tag = mapper.getAt(this.listIn, i);
                NBTTag m = MappedNBTCompound.mapTag(mapper, tag);
                if (m == null) continue;
                this.appendTag(m);
            }
        }
    }
}

