/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.cpl.block.entity.ActiveEffect;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.util.Hand;
import com.tom.cpl.util.HandAnimation;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.client.FirstPersonDetector;
import com.tom.cpm.client.Platform;
import com.tom.cpm.client.RealCameraDetector;
import com.tom.cpm.client.vr.VRPlayerRenderer;
import com.tom.cpm.common.EntityTypeHandlerImpl;
import com.tom.cpm.common.PlayerInventory;
import com.tom.cpm.common.WorldImpl;
import com.tom.cpm.mixinplugin.FPMDetector;
import com.tom.cpm.mixinplugin.RCDetector;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.render.PlayerModelSetup;
import com.tom.cpm.shared.skin.PlayerTextureLoader;
import com.tom.cpm.shared.skin.TextureType;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;

public class PlayerProfile
extends com.tom.cpm.shared.config.Player<Player> {
    public static boolean inGui;
    private static BooleanSupplier inFirstPerson;
    private final GameProfile profile;
    private String skinType;

    public static void addInFirstPerson(BooleanSupplier inFirstPerson) {
        BooleanSupplier old = PlayerProfile.inFirstPerson;
        PlayerProfile.inFirstPerson = () -> inFirstPerson.getAsBoolean() || old.getAsBoolean();
    }

    public static GameProfile getPlayerProfile(Player player) {
        PlayerInfo info;
        ClientPacketListener conn;
        if (player == null) {
            return null;
        }
        GameProfile profile = player.getGameProfile();
        if (profile.getProperties().isEmpty() && (conn = Minecraft.getInstance().getConnection()) != null && (info = conn.getPlayerInfo(profile.getId())) != null) {
            profile = info.getProfile();
        }
        return profile;
    }

    public PlayerProfile(GameProfile profile) {
        this.profile = new GameProfile(profile.getId(), profile.getName());
        PlayerProfile.cloneProperties(profile.getProperties(), this.profile.getProperties());
        if (profile.getId() != null) {
            this.skinType = DefaultPlayerSkin.get((UUID)profile.getId()).model().id();
        }
    }

    @Override
    public SkinType getSkinType() {
        return SkinType.get(this.skinType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.profile == null ? 0 : this.profile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlayerProfile other = (PlayerProfile)obj;
        return !(this.profile == null ? other.profile != null : !this.profile.equals((Object)other.profile));
    }

    @Override
    public UUID getUUID() {
        return this.profile.getId();
    }

    @Override
    public void updateFromPlayer(Player player) {
        float f1;
        float f;
        ItemStack is;
        Pose p = player.getPose();
        this.animState.resetPlayer();
        switch (p) {
            case FALL_FLYING: {
                this.animState.elytraFlying = true;
                break;
            }
            case SLEEPING: {
                this.animState.sleeping = true;
                break;
            }
            case SPIN_ATTACK: {
                this.animState.tridentSpin = true;
                break;
            }
        }
        this.animState.sneaking = player.isCrouching();
        this.animState.crawling = player.isVisuallyCrawling();
        this.animState.swimming = player.isVisuallySwimming();
        if (!player.isAlive()) {
            this.animState.dying = true;
        }
        if (Platform.isSitting(player)) {
            this.animState.riding = true;
        }
        if (player.isSprinting()) {
            this.animState.sprinting = true;
        }
        if (player.isUsingItem()) {
            this.animState.usingAnimation = HandAnimation.of(player.getUseItem().getUseAnimation());
        }
        if (player.isInWater()) {
            this.animState.retroSwimming = true;
        }
        this.animState.moveAmountX = (float)(player.getX() - player.xo);
        this.animState.moveAmountY = (float)(player.getY() - player.yo);
        this.animState.moveAmountZ = (float)(player.getZ() - player.zo);
        this.animState.yaw = player.getYRot();
        this.animState.pitch = player.getXRot();
        this.animState.bodyYaw = player.yBodyRot;
        if (player.isModelPartShown(PlayerModelPart.HAT)) {
            this.animState.encodedState |= 1;
        }
        if (player.isModelPartShown(PlayerModelPart.JACKET)) {
            this.animState.encodedState |= 2;
        }
        if (player.isModelPartShown(PlayerModelPart.LEFT_PANTS_LEG)) {
            this.animState.encodedState |= 4;
        }
        if (player.isModelPartShown(PlayerModelPart.RIGHT_PANTS_LEG)) {
            this.animState.encodedState |= 8;
        }
        if (player.isModelPartShown(PlayerModelPart.LEFT_SLEEVE)) {
            this.animState.encodedState |= 0x10;
        }
        if (player.isModelPartShown(PlayerModelPart.RIGHT_SLEEVE)) {
            this.animState.encodedState |= 0x20;
        }
        this.animState.hasSkullOnHead = (is = player.getItemBySlot(EquipmentSlot.HEAD)).getItem() instanceof BlockItem && ((BlockItem)is.getItem()).getBlock() instanceof AbstractSkullBlock;
        this.animState.wearingHelm = !is.isEmpty();
        is = player.getItemBySlot(EquipmentSlot.CHEST);
        this.animState.wearingElytra = is.get(DataComponents.GLIDER) != null;
        this.animState.wearingBody = !is.isEmpty();
        this.animState.wearingLegs = !player.getItemBySlot(EquipmentSlot.LEGS).isEmpty();
        this.animState.wearingBoots = !player.getItemBySlot(EquipmentSlot.FEET).isEmpty();
        this.animState.mainHand = Hand.of(player.getMainArm());
        this.animState.activeHand = Hand.of(this.animState.mainHand, player.getUsedItemHand());
        this.animState.swingingHand = Hand.of(this.animState.mainHand, player.swingingArm);
        this.animState.hurtTime = player.hurtTime;
        this.animState.isOnLadder = player.onClimbable();
        this.animState.isBurning = player.displayFireAnimation();
        this.animState.isFreezing = player.getTicksFrozen() > 0;
        this.animState.inGui = inGui;
        this.animState.firstPersonMod = inFirstPerson.getAsBoolean();
        PlayerInventory.setInv(this.animState, player.getInventory());
        WorldImpl.setWorld(this.animState, (Entity)player);
        if (player.getVehicle() != null) {
            this.animState.vehicle = EntityTypeHandlerImpl.impl.wrap(player.getVehicle().getType());
        }
        player.getActiveEffects().forEach(e -> this.animState.allEffects.add(new ActiveEffect(BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)e.getEffect().value())).toString(), e.getAmplifier(), e.getDuration(), !e.isVisible())));
        if (player.getUseItem().getItem() instanceof CrossbowItem) {
            f = CrossbowItem.getChargeDuration((ItemStack)player.getUseItem(), (LivingEntity)player);
            f1 = MathHelper.clamp((float)player.getTicksUsingItem(), 0.0f, f);
            this.animState.crossbowPullback = f1 / f;
        }
        if (player.getUseItem().getItem() instanceof BowItem) {
            f = 20.0f;
            f1 = MathHelper.clamp((float)player.getTicksUsingItem(), 0.0f, f);
            this.animState.bowPullback = f1 / f;
        }
        this.animState.parrotLeft = !player.getShoulderEntityLeft().getString("id").isEmpty();
        this.animState.parrotRight = !player.getShoulderEntityRight().getString("id").isEmpty();
    }

    @Override
    public void updateFromModel(Object model) {
        if (model instanceof PlayerModel) {
            this.animState.vrState = CustomPlayerModelsClient.vrLoaded ? VRPlayerRenderer.getVRState(this.animState.animationMode, model) : null;
        }
    }

    public void updateFromState(PlayerModel model, PlayerRenderState state) {
        this.animState.resetModel();
        this.animState.attackTime = state.attackTime;
        this.animState.swimAmount = state.swimAmount;
        this.animState.leftArm = PlayerModelSetup.ArmPose.of(state.leftArmPose);
        this.animState.rightArm = PlayerModelSetup.ArmPose.of(state.rightArmPose);
    }

    @Override
    protected PlayerTextureLoader initTextures() {
        File cache = Minecraft.getInstance().getSkinManager().skinTextures.root.toFile();
        return new PlayerTextureLoader(cache){

            @Override
            protected CompletableFuture<Void> load0() {
                return CompletableFuture.supplyAsync(() -> {
                    Minecraft mc = Minecraft.getInstance();
                    MinecraftSessionService mss = mc.getMinecraftSessionService();
                    Property pt = mss.getPackedTextures(PlayerProfile.this.profile);
                    if (pt == null) {
                        return MinecraftProfileTextures.EMPTY;
                    }
                    MinecraftProfileTextures mpts = mss.unpackTextures(pt);
                    return mpts;
                }, Util.backgroundExecutor().forName("CPM:unpackSkinTextures")).thenAcceptAsync(mpts -> {
                    MinecraftProfileTexture skin = mpts.skin();
                    MinecraftProfileTexture cape = mpts.cape();
                    MinecraftProfileTexture elytra = mpts.elytra();
                    if (skin != null) {
                        PlayerProfile.this.skinType = skin.getMetadata("model");
                        this.defineTexture(TextureType.SKIN, skin.getUrl(), skin.getHash());
                    }
                    if (cape != null) {
                        this.defineTexture(TextureType.CAPE, cape.getUrl(), cape.getHash());
                    }
                    if (elytra != null) {
                        this.defineTexture(TextureType.ELYTRA, elytra.getUrl(), elytra.getHash());
                    }
                }, t -> RenderSystem.recordRenderCall(t::run));
            }
        };
    }

    @Override
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public Object getGameProfile() {
        return this.profile;
    }

    static {
        inFirstPerson = () -> false;
        if (FPMDetector.doApply()) {
            FirstPersonDetector.init();
        }
        if (RCDetector.doApply()) {
            RealCameraDetector.init();
        }
    }
}

