/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpl.tag.TagManager;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.util.ErrorLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;

public class CPMTagLoader
implements ISelectiveResourceReloadListener {
    private final TagManager<?> tags;
    private final String prefix;

    public CPMTagLoader(IResourceManager mngr, TagManager<?> tags, String prefix) {
        this.tags = tags;
        this.prefix = prefix;
        if (mngr instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)mngr).func_110542_a((IResourceManagerReloadListener)this);
        }
    }

    private Map<String, List<Map<String, Object>>> load(IResourceManager mngr) {
        HashMap<String, List<Map<String, Object>>> el = new HashMap<String, List<Map<String, Object>>>();
        HashSet allEntries = new HashSet();
        mngr.func_135055_a().forEach(d -> {
            ResourceLocation rl = new ResourceLocation(d, "cpm_tags/dictionary.json");
            try {
                List res = mngr.func_135056_b(rl);
                for (IResource r : res) {
                    try {
                        IResource iresource = r;
                        Throwable throwable = null;
                        try {
                            InputStream inputstream = iresource.func_110527_b();
                            Throwable throwable2 = null;
                            try {
                                BufferedReader rd = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                                Throwable throwable3 = null;
                                try {
                                    Map tag = (Map)MinecraftObjectHolder.gson.fromJson((Reader)rd, Object.class);
                                    List entries = (List)tag.get(this.prefix);
                                    if (entries == null) continue;
                                    for (String e : entries) {
                                        allEntries.add(new ResourceLocation(d, "cpm_tags/" + this.prefix + "/" + e + ".json"));
                                    }
                                }
                                catch (Throwable throwable4) {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    if (rd == null) continue;
                                    if (throwable3 != null) {
                                        try {
                                            ((Reader)rd).close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable3.addSuppressed(throwable5);
                                        }
                                        continue;
                                    }
                                    ((Reader)rd).close();
                                }
                            }
                            catch (Throwable throwable6) {
                                throwable2 = throwable6;
                                throw throwable6;
                            }
                            finally {
                                if (inputstream == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        inputstream.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                    continue;
                                }
                                inputstream.close();
                            }
                        }
                        catch (Throwable throwable8) {
                            throwable = throwable8;
                            throw throwable8;
                        }
                        finally {
                            if (iresource == null) continue;
                            if (throwable != null) {
                                try {
                                    iresource.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                }
                                continue;
                            }
                            iresource.close();
                        }
                    }
                    catch (Exception e) {
                        ErrorLog.addLog(ErrorLog.LogLevel.WARNING, "Failed to load cpm tag dictionary: " + rl, e);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        allEntries.forEach(rl -> {
            ArrayList<Map> res = new ArrayList<Map>();
            el.put(rl.func_110624_b() + ":" + rl.func_110623_a().substring(9, rl.func_110623_a().length() - 5), res);
            try {
                Iterator iterator = mngr.func_135056_b(rl).iterator();
                while (iterator.hasNext()) {
                    IResource r;
                    IResource iresource = r = (IResource)iterator.next();
                    Throwable throwable = null;
                    try {
                        InputStream inputstream = iresource.func_110527_b();
                        Throwable throwable2 = null;
                        try {
                            BufferedReader rd = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                            Throwable throwable3 = null;
                            try {
                                Map tag = (Map)MinecraftObjectHolder.gson.fromJson((Reader)rd, Object.class);
                                res.add(tag);
                            }
                            catch (Throwable throwable4) {
                                throwable3 = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (rd == null) continue;
                                if (throwable3 != null) {
                                    try {
                                        ((Reader)rd).close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable3.addSuppressed(throwable5);
                                    }
                                    continue;
                                }
                                ((Reader)rd).close();
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable2 = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (inputstream == null) continue;
                            if (throwable2 != null) {
                                try {
                                    inputstream.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable2.addSuppressed(throwable7);
                                }
                                continue;
                            }
                            inputstream.close();
                        }
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (iresource == null) continue;
                        if (throwable != null) {
                            try {
                                iresource.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                            continue;
                        }
                        iresource.close();
                    }
                }
            }
            catch (Exception e) {
                ErrorLog.addLog(ErrorLog.LogLevel.WARNING, "Failed to load cpm builtin tag: " + rl, e);
            }
        });
        return el;
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.LANGUAGES)) {
            this.tags.applyBuiltin(this.load(resourceManager), this.prefix);
        }
    }
}

