/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.tom.cpl.block.entity.ActiveEffect;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.util.Hand;
import com.tom.cpl.util.HandAnimation;
import com.tom.cpm.client.ClientProxy;
import com.tom.cpm.common.EntityTypeHandlerImpl;
import com.tom.cpm.common.PlayerInventory;
import com.tom.cpm.common.WorldImpl;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.render.PlayerModelSetup;
import com.tom.cpm.shared.skin.PlayerTextureLoader;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PlayerProfile
extends Player<EntityPlayer> {
    public static boolean inGui;
    private final GameProfile profile;
    private String skinType;

    public static GameProfile getPlayerProfile(EntityPlayer player) {
        NetworkPlayerInfo info;
        NetHandlerPlayClient conn;
        if (player == null) {
            return null;
        }
        GameProfile profile = player.func_146103_bH();
        if (profile.getProperties().isEmpty() && (conn = Minecraft.func_71410_x().func_147114_u()) != null && (info = conn.func_175102_a(profile.getId())) != null) {
            profile = info.func_178845_a();
        }
        return profile;
    }

    public PlayerProfile(GameProfile profile) {
        this.profile = profile;
        if (profile.getId() != null) {
            this.skinType = DefaultPlayerSkin.func_177332_b((UUID)profile.getId());
        }
    }

    @Override
    public SkinType getSkinType() {
        return SkinType.get(this.skinType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.profile == null ? 0 : this.profile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlayerProfile other = (PlayerProfile)obj;
        return !(this.profile == null ? other.profile != null : !this.profile.equals((Object)other.profile));
    }

    @Override
    public UUID getUUID() {
        return this.profile.getId();
    }

    @Override
    public void updateFromPlayer(EntityPlayer player) {
        this.animState.resetPlayer();
        if (player.func_70608_bn()) {
            this.animState.sleeping = true;
        }
        if (player.field_70128_L) {
            this.animState.dying = true;
        }
        if (player.func_184613_cA()) {
            this.animState.elytraFlying = true;
        }
        if (player.func_184218_aH() && player.func_184187_bx() != null && player.func_184187_bx().shouldRiderSit()) {
            this.animState.riding = true;
        }
        if (player.func_70093_af()) {
            this.animState.sneaking = true;
        }
        if (player.func_70051_ag()) {
            this.animState.sprinting = true;
        }
        if (player.func_184587_cr()) {
            this.animState.usingAnimation = HandAnimation.of(player.func_184607_cu().func_77975_n());
        }
        if (player.func_70090_H()) {
            this.animState.retroSwimming = true;
        }
        this.animState.moveAmountX = (float)(player.field_70165_t - player.field_70169_q);
        this.animState.moveAmountY = (float)(player.field_70163_u - player.field_70167_r);
        this.animState.moveAmountZ = (float)(player.field_70161_v - player.field_70166_s);
        this.animState.yaw = player.field_70759_as * 2.0f - player.field_70761_aq;
        this.animState.pitch = player.field_70125_A;
        this.animState.bodyYaw = player.field_70759_as;
        if (player.func_175148_a(EnumPlayerModelParts.HAT)) {
            this.animState.encodedState |= 1;
        }
        if (player.func_175148_a(EnumPlayerModelParts.JACKET)) {
            this.animState.encodedState |= 2;
        }
        if (player.func_175148_a(EnumPlayerModelParts.LEFT_PANTS_LEG)) {
            this.animState.encodedState |= 4;
        }
        if (player.func_175148_a(EnumPlayerModelParts.RIGHT_PANTS_LEG)) {
            this.animState.encodedState |= 8;
        }
        if (player.func_175148_a(EnumPlayerModelParts.LEFT_SLEEVE)) {
            this.animState.encodedState |= 0x10;
        }
        if (player.func_175148_a(EnumPlayerModelParts.RIGHT_SLEEVE)) {
            this.animState.encodedState |= 0x20;
        }
        ItemStack is = player.func_184582_a(EntityEquipmentSlot.HEAD);
        this.animState.hasSkullOnHead = is.func_77973_b() instanceof ItemSkull;
        this.animState.wearingHelm = !is.func_190926_b();
        is = player.func_184582_a(EntityEquipmentSlot.CHEST);
        this.animState.wearingElytra = is.func_77973_b() instanceof ItemElytra;
        this.animState.wearingBody = !is.func_190926_b();
        this.animState.wearingLegs = !player.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b();
        this.animState.wearingBoots = !player.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b();
        this.animState.mainHand = Hand.of(player.func_184591_cq());
        this.animState.activeHand = Hand.of(this.animState.mainHand, player.func_184600_cs());
        this.animState.swingingHand = Hand.of(this.animState.mainHand, player.field_184622_au);
        this.animState.hurtTime = player.field_70737_aN;
        this.animState.isOnLadder = player.func_70617_f_();
        this.animState.isBurning = player.func_90999_ad();
        this.animState.inGui = inGui;
        PlayerInventory.setInv(this.animState, player.field_71071_by);
        WorldImpl.setWorld(this.animState, (Entity)player);
        if (player.func_184187_bx() != null) {
            this.animState.vehicle = EntityTypeHandlerImpl.impl.wrap(EntityRegistry.getEntry(player.func_184187_bx().getClass()));
        }
        player.func_70651_bq().forEach(e -> this.animState.allEffects.add(new ActiveEffect(ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)e.func_188419_a()).toString(), e.func_76458_c(), e.func_76459_b(), !e.func_188418_e())));
        if (player.func_184607_cu().func_77973_b() instanceof ItemBow) {
            float f = 20.0f;
            float f1 = MathHelper.clamp((float)player.func_184612_cw(), 0.0f, f);
            this.animState.bowPullback = f1 / f;
        }
        this.animState.parrotLeft = !player.func_192023_dk().func_74779_i("id").isEmpty();
        this.animState.parrotRight = !player.func_192025_dl().func_74779_i("id").isEmpty();
    }

    @Override
    public void updateFromModel(Object model) {
        if (model instanceof ModelPlayer) {
            ModelPlayer m = (ModelPlayer)model;
            this.animState.resetModel();
            this.animState.attackTime = m.field_78095_p;
            this.animState.leftArm = PlayerModelSetup.ArmPose.of(m.field_187075_l);
            this.animState.rightArm = PlayerModelSetup.ArmPose.of(m.field_187076_m);
        }
    }

    @Override
    protected PlayerTextureLoader initTextures() {
        return new PlayerTextureLoader(Minecraft.func_71410_x().func_152342_ad().field_152796_d){

            @Override
            protected CompletableFuture<Void> load0() {
                Map map = Minecraft.func_71410_x().func_152342_ad().func_152788_a(PlayerProfile.this.profile);
                this.defineAll(map, MinecraftProfileTexture::getUrl, MinecraftProfileTexture::getHash);
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    MinecraftProfileTexture tex = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
                    PlayerProfile.this.skinType = tex.getMetadata("model");
                    if (PlayerProfile.this.skinType == null) {
                        PlayerProfile.this.skinType = "default";
                    }
                    return CompletableFuture.completedFuture(null);
                }
                final CompletableFuture<Void> cf = new CompletableFuture<Void>();
                Minecraft.func_71410_x().func_152342_ad().func_152790_a(PlayerProfile.this.profile, new SkinManager.SkinAvailableCallback(){

                    public void func_180521_a(MinecraftProfileTexture.Type typeIn, ResourceLocation location, MinecraftProfileTexture profileTexture) {
                        this.defineTexture((Enum)typeIn, profileTexture.getUrl(), profileTexture.getHash());
                        switch (typeIn) {
                            case SKIN: {
                                PlayerProfile.this.skinType = profileTexture.getMetadata("model");
                                if (PlayerProfile.this.skinType == null) {
                                    PlayerProfile.this.skinType = "default";
                                }
                                ClientProxy.mc.getDefinitionLoader().execute(() -> Minecraft.func_71410_x().func_152343_a(() -> cf.complete(null)));
                                break;
                            }
                        }
                    }
                }, true);
                return cf;
            }
        };
    }

    @Override
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public Object getGameProfile() {
        return this.profile;
    }
}

